/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.outliers;

import commonSense.math.linear.Matrix;
import commonSense.stats.multivariate.PCA;
import commonSense.stats.multivariate.outliers.MVE;
import java.util.Date;
import java.util.LinkedHashMap;
import javax.swing.JOptionPane;
import kim.bin.bio.wings.LogFrame;
import kim.bin.bio.wings.individual.Alignment;
import kim.bin.bio.wings.individual.IndGroup;
import kim.bin.bio.wings.individual.Individual;
import kim.bin.bio.wings.individual.IndividualHeapSort;
import kim.bin.bio.wings.individual.IndividualStatus;
import kim.bin.bio.wings.outliers.OutlierType;
import kim.bio.Sex;
import kim.math.alignment.util.AlignmentMatrices;
import kim.math.sort.Sort;

public class Outliers
implements Sex,
IndividualStatus,
OutlierType,
Sort {
    public static Individual[] findOutliers(IndGroup individuals, int iteration, boolean onlySubset) {
        double d;
        int x;
        Matrix tttt;
        PCA mpca;
        LogFrame.log("Total: " + individuals.size());
        Individual[] males = individuals.getSubset(1, 8);
        Individual[] pseudomales = individuals.getSubset(3, 8);
        Individual[] females = individuals.getSubset(2, 8);
        int noMales = males.length;
        int noPseudoMales = pseudomales.length;
        int noFemales = females.length;
        LogFrame.log("Males: " + noMales + ";  females: " + noFemales);
        LinkedHashMap<Individual, Double> outliers = new LinkedHashMap<Individual, Double>(10);
        Date start = new Date();
        LogFrame.log("(Outliers.findOutliers) Start: " + start);
        if (males.length > 0) {
            if (males.length < 30) {
                JOptionPane.showMessageDialog(null, "Not enough males (" + males.length + ") to include in the outlier detection.");
            } else {
                Alignment algMales = new Alignment(males);
                Matrix[] alignedMales = algMales.landMarkGPA(true);
                Matrix guys = AlignmentMatrices.combineSpecimenMatrices((Matrix[])alignedMales);
                mpca = new PCA(guys, 0);
                tttt = mpca.getFactorScores().getSubMatrix(0, guys.getRowDimension() - 1, 0, mpca.noPositiveEigenvalues() - 1);
                MVE maleMVE = new MVE(tttt, false);
                int[] maleOutliers1 = maleMVE.getOutliers();
                double[] maleMD1 = maleMVE.getDistances(4);
                for (int x2 = 0; x2 < maleOutliers1.length; ++x2) {
                    if (maleOutliers1[x2] != 0) continue;
                    males[x2].MD = maleMD1[x2];
                    males[x2].setOutlierType(1);
                    outliers.put(males[x2], new Double(maleMD1[x2]));
                    individuals.setOutlierIteration(males[x2].ID, iteration);
                }
                alignedMales = algMales.outlineGPA(12);
                guys = AlignmentMatrices.combineSpecimenMatrices((Matrix[])alignedMales);
                mpca = new PCA(guys, 0);
                maleMVE = new MVE(mpca.getFactorScores().getSubMatrix(0, guys.getRowDimension() - 1, 0, mpca.noPositiveEigenvalues() - 1), false);
                int[] maleOutliers2 = maleMVE.getOutliers();
                double[] maleMD2 = maleMVE.getDistances(4);
                for (x = 0; x < maleOutliers2.length; ++x) {
                    if (maleOutliers2[x] != 0) continue;
                    if (outliers.containsKey(males[x])) {
                        d = (Double)outliers.get(males[x]);
                        males[x].setOutlierType(2);
                        if (!(maleMD2[x] > d)) continue;
                        males[x].MD = maleMD2[x];
                        outliers.put(males[x], new Double(maleMD2[x]));
                        individuals.setOutlierIteration(males[x].ID, iteration);
                        continue;
                    }
                    males[x].MD = maleMD2[x];
                    males[x].setOutlierType(2);
                    outliers.put(males[x], new Double(maleMD2[x]));
                    individuals.setOutlierIteration(males[x].ID, iteration);
                }
            }
        }
        if (pseudomales.length > 0) {
            if (pseudomales.length < 30) {
                JOptionPane.showMessageDialog(null, "Not enough pseudomales (" + pseudomales.length + ") to include in the outlier detection.");
            } else {
                Alignment algPseudoMales = new Alignment(pseudomales);
                Matrix[] alignedPseudoMales = algPseudoMales.landMarkGPA(true);
                Matrix pseudoGuys = AlignmentMatrices.combineSpecimenMatrices((Matrix[])alignedPseudoMales);
                mpca = new PCA(pseudoGuys, 0);
                tttt = mpca.getFactorScores().getSubMatrix(0, pseudoGuys.getRowDimension() - 1, 0, mpca.noPositiveEigenvalues() - 1);
                MVE pseudoMaleMVE = new MVE(tttt, false);
                int[] pseudoMaleOutliers1 = pseudoMaleMVE.getOutliers();
                double[] pseudoMaleMD1 = pseudoMaleMVE.getDistances(4);
                for (int x3 = 0; x3 < pseudoMaleOutliers1.length; ++x3) {
                    if (pseudoMaleOutliers1[x3] != 0) continue;
                    pseudomales[x3].MD = pseudoMaleMD1[x3];
                    pseudomales[x3].setOutlierType(1);
                    outliers.put(pseudomales[x3], new Double(pseudoMaleMD1[x3]));
                    individuals.setOutlierIteration(pseudomales[x3].ID, iteration);
                }
                alignedPseudoMales = algPseudoMales.outlineGPA(12);
                pseudoGuys = AlignmentMatrices.combineSpecimenMatrices((Matrix[])alignedPseudoMales);
                mpca = new PCA(pseudoGuys, 0);
                pseudoMaleMVE = new MVE(mpca.getFactorScores().getSubMatrix(0, pseudoGuys.getRowDimension() - 1, 0, mpca.noPositiveEigenvalues() - 1), false);
                int[] pseudoMaleOutliers2 = pseudoMaleMVE.getOutliers();
                double[] pseudoMaleMD2 = pseudoMaleMVE.getDistances(4);
                for (x = 0; x < pseudoMaleOutliers2.length; ++x) {
                    if (pseudoMaleOutliers2[x] != 0) continue;
                    if (outliers.containsKey(pseudomales[x])) {
                        d = (Double)outliers.get(pseudomales[x]);
                        pseudomales[x].setOutlierType(2);
                        if (!(pseudoMaleMD2[x] > d)) continue;
                        pseudomales[x].MD = pseudoMaleMD2[x];
                        outliers.put(pseudomales[x], new Double(pseudoMaleMD2[x]));
                        individuals.setOutlierIteration(pseudomales[x].ID, iteration);
                        continue;
                    }
                    pseudomales[x].MD = pseudoMaleMD2[x];
                    pseudomales[x].setOutlierType(2);
                    outliers.put(pseudomales[x], new Double(pseudoMaleMD2[x]));
                    individuals.setOutlierIteration(pseudomales[x].ID, iteration);
                }
            }
        }
        if (females.length > 0) {
            if (females.length < 30) {
                JOptionPane.showMessageDialog(null, "Not enough females (" + females.length + ") to include in the outlier detection.");
            } else {
                Alignment algFemales = new Alignment(females);
                Matrix[] alignedFemales = algFemales.landMarkGPA(true);
                Matrix gals = AlignmentMatrices.combineSpecimenMatrices((Matrix[])alignedFemales);
                PCA fpca = new PCA(gals, 0);
                MVE femaleMVE = new MVE(fpca.getFactorScores().getSubMatrix(0, gals.getRowDimension() - 1, 0, fpca.noPositiveEigenvalues() - 1), false);
                int[] femaleOutliers1 = femaleMVE.getOutliers();
                double[] femaleMD1 = femaleMVE.getDistances(4);
                for (int x4 = 0; x4 < femaleOutliers1.length; ++x4) {
                    if (femaleOutliers1[x4] != 0) continue;
                    females[x4].MD = femaleMD1[x4];
                    females[x4].setOutlierType(1);
                    outliers.put(females[x4], new Double(femaleMD1[x4]));
                    individuals.setOutlierIteration(females[x4].ID, iteration);
                }
                alignedFemales = algFemales.outlineGPA(12);
                gals = AlignmentMatrices.combineSpecimenMatrices((Matrix[])alignedFemales);
                fpca = new PCA(gals, 0);
                femaleMVE = new MVE(fpca.getFactorScores().getSubMatrix(0, gals.getRowDimension() - 1, 0, fpca.noPositiveEigenvalues() - 1), false);
                int[] femaleOutliers2 = femaleMVE.getOutliers();
                double[] femaleMD2 = femaleMVE.getDistances(4);
                for (int x5 = 0; x5 < femaleOutliers2.length; ++x5) {
                    if (femaleOutliers2[x5] != 0) continue;
                    if (outliers.containsKey(females[x5])) {
                        double d2 = (Double)outliers.get(females[x5]);
                        females[x5].setOutlierType(2);
                        if (!(femaleMD2[x5] > d2)) continue;
                        females[x5].MD = femaleMD2[x5];
                        outliers.put(females[x5], new Double(femaleMD2[x5]));
                        individuals.setOutlierIteration(females[x5].ID, iteration);
                        continue;
                    }
                    females[x5].MD = femaleMD2[x5];
                    females[x5].setOutlierType(2);
                    outliers.put(females[x5], new Double(femaleMD2[x5]));
                    individuals.setOutlierIteration(females[x5].ID, iteration);
                }
            }
        }
        int n = outliers.size();
        Individual[] outlierInd = new Individual[n];
        double[] outlierMD = new double[n];
        Object[] keys = outliers.keySet().toArray();
        Object[] values = outliers.values().toArray();
        for (int x6 = 0; x6 < n; ++x6) {
            outlierInd[x6] = (Individual)keys[x6];
            outlierMD[x6] = (Double)values[x6];
        }
        if (outlierMD.length > 0) {
            IndividualHeapSort ohs = new IndividualHeapSort(outlierMD, outlierInd);
            ohs.sortDirection(1);
            return ohs.getSortedIndividuals();
        }
        return null;
    }
}

