/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.landmark;

import commonSense.math.linear.Matrix;
import kim.bin.bio.wings.PointMatrix;
import kim.bin.bio.wings.landmark.LandMarkDefinition;
import kim.bin.bio.wings.landmark.LandMarkSubset;

public class LandMarks
extends PointMatrix {
    private static final long serialVersionUID = 1L;
    protected LandMarkDefinition LMDef;
    protected boolean containsOnlySubsetValues;

    public LandMarks(LandMarkDefinition LMDefinition, double[][] data, double[] distortions, boolean containsOnlySubsetValues, int orientation) {
        super(data, distortions);
        this.LMDef = LMDefinition;
        this.orientation = orientation;
        this.containsOnlySubsetValues = containsOnlySubsetValues;
    }

    public LandMarks(LandMarkDefinition LMDefinition, Matrix data, double[] distortions, boolean containsOnlySubsetValues, int orientation) {
        this(LMDefinition, data.getData(), distortions, containsOnlySubsetValues, orientation);
    }

    public void setSubset(LandMarkSubset subset) {
        this.LMDef.setSubset(subset);
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public double[] getPoint(int number, boolean onlySubset) throws ArrayIndexOutOfBoundsException {
        if (onlySubset) {
            return this.getRow(this.LMDef.getSubset().getLocation(number));
        }
        return this.getRow(number);
    }

    public int getNoPoints(boolean onlySubset) {
        return onlySubset ? this.LMDef.getSubset().getNoLandMarks() : this.rows;
    }

    public String getDatDataString(boolean onlySubset) {
        String dataString = "";
        double[] array = this.dataArray(onlySubset);
        for (int x = 0; x < array.length; ++x) {
            dataString = dataString + array[x] + " ";
        }
        return dataString;
    }

    public double[] dataArray(boolean onlySubset) {
        if (onlySubset) {
            return this.getDataMatrix(onlySubset).getRowPackedCopy();
        }
        return this.getRowPackedCopy();
    }

    public double[] dataArray(boolean onlySubset, boolean distortionCorrection, boolean rotationCorrection) {
        return this.getCorrectedDataMatrix(onlySubset, distortionCorrection, rotationCorrection).getRowPackedCopy();
    }

    public Matrix getDataMatrix(boolean onlySubset) {
        if (onlySubset) {
            return this.getSubMatrix(this.LMDef.getSubset().getPoints(), 0, this.columns - 1);
        }
        return this.copy();
    }

    public Matrix getCorrectedDataMatrix(boolean onlySubset, boolean distortionCorrection, boolean rotationCorrection) {
        Matrix m = this.getCorrectedDataMatrix(distortionCorrection, rotationCorrection);
        if (onlySubset) {
            return m.getSubMatrix(this.LMDef.getSubset().getPoints(), 0, this.columns - 1);
        }
        return m;
    }

    public LandMarks LMcopy() {
        double[] out = new double[this.columns];
        System.arraycopy(this.distortions, 0, out, 0, this.distortions.length);
        LandMarks newLM = new LandMarks(this.LMDef, this.data, out, this.containsOnlySubsetValues, this.orientation);
        return newLM;
    }
}

