/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.individual;

import javax.swing.table.AbstractTableModel;
import kim.bin.bio.wings.individual.Individual;
import kim.bin.bio.wings.individual.IndividualStatus;

class IndividualTableModel
extends AbstractTableModel
implements IndividualStatus {
    private static final long serialVersionUID = 1L;
    private Individual[] allIndividuals = null;
    private Object[][] data = null;
    private String[] columnNames = new String[]{"ID", "State", "Outlier", "Procrustes Distance", "Open radius", "Structural element height", "Threshold", "Fill size", "Short clean segment length", "Long clean segment length"};

    IndividualTableModel(Individual[] individuals) {
        this.allIndividuals = individuals;
        this.data = new Object[this.allIndividuals.length][10];
        System.out.println("Data matrix given to Individual frame (" + this.data.length + ", " + this.data[0].length + ")");
        for (int x = 0; x < this.allIndividuals.length; ++x) {
            this.setData(x, this.allIndividuals[x]);
        }
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.data[row][col] = value;
        this.fireTableCellUpdated(row, col);
    }

    public Individual getIndividual(Integer ID) {
        System.out.println(ID);
        return this.allIndividuals[ID];
    }

    public void setIndividualStatus(Individual ind) {
        for (int i = 0; i < this.data.length; ++i) {
            if (!this.data[i][0].equals(ind.ID)) continue;
            this.data[i][1] = ind.getProcessingStatus();
            this.fireTableCellUpdated(i, 1);
            return;
        }
    }

    public void setOutlier(Individual ind) {
        for (int i = 0; i < this.data.length; ++i) {
            if (!this.data[i][0].equals(ind.ID)) continue;
            this.data[i][2] = ind.isOutlier();
            this.fireTableCellUpdated(i, 2);
            return;
        }
    }

    public int updateIndividual(Individual ind) {
        for (int i = 0; i < this.data.length; ++i) {
            if (!((Individual)this.data[i][0]).ID.equals(ind.ID)) continue;
            this.setData(i, ind);
            this.fireTableRowsUpdated(i, i);
            return i;
        }
        return -1;
    }

    private void setData(int x, Individual ind) {
        this.data[x][0] = ind;
        this.data[x][1] = ind.isRejected() ? "Rejected" : stringValues[ind.getProcessingStatus()];
        this.data[x][2] = ind.isOutlier() ? "Yes" : "";
        this.data[x][3] = ind.procrustesDistance;
        this.data[x][4] = ind.splineParameters.openRadius;
        this.data[x][5] = ind.splineParameters.structElementHeight;
        this.data[x][6] = ind.splineParameters.threshold;
        this.data[x][7] = ind.splineParameters.fillSize;
        this.data[x][8] = ind.splineParameters.shortCleanSegment;
        this.data[x][9] = ind.splineParameters.longCleanSegment;
    }
}

