/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.individual;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import kim.bin.bio.wings.GlobalVariables;
import kim.bin.bio.wings.WingsInternalFrame;
import kim.bin.bio.wings.WingsStatus;
import kim.bin.bio.wings.fileTypes.CPXFile;
import kim.bin.bio.wings.individual.IndGroup;
import kim.bin.bio.wings.individual.Individual;
import kim.bin.bio.wings.individual.IndividualJTable;
import kim.bin.bio.wings.individual.IndividualTableModel;
import kim.bio.Sex;
import kim.swing.JTable.DefaultTableHeaderCellRenderer;
import kim.swing.JTable.VerticalTableHeaderCellRenderer;
import kim.util.JGridBag;

public class IndividualFrame
extends WingsInternalFrame
implements WingsStatus,
Sex,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JTable table = null;
    private IndividualTableModel individualTableModel = null;
    private Individual[] all = null;
    private JPanel top = new JPanel();
    private JLabel showLabel = new JLabel("Show: ");
    private ButtonGroup showGroup = new ButtonGroup();
    private JRadioButton showAll = new JRadioButton("All");
    private JRadioButton showOutliers = new JRadioButton("Outliers");
    private JRadioButton showUnsplined = new JRadioButton("Unsplined");
    private JComboBox sexesSelection = new JComboBox();
    private TableRowSorter<IndividualTableModel> sorter;
    private boolean hasOutliers = false;
    private JPopupMenu individualPopup = new JPopupMenu();
    private JMenuItem reject = new JMenuItem("Reject");
    private JMenuItem restore = new JMenuItem("Restore");
    private JMenuItem saveAsModel = new JMenuItem("Save as model file");
    private JMenuItem editImage = new JMenuItem("Edit");
    private JMenuItem debugImage = new JMenuItem("Debug");
    private int activeRow = -1;

    public IndividualFrame(IndGroup individuals) {
        super("Individuals");
        if (GlobalVariables.individualLock) {
            this.dispose();
            return;
        }
        this.reject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Individual ind = (Individual)IndividualFrame.this.table.getValueAt(IndividualFrame.this.activeRow, 0);
                ind.setRejected(true);
                IndividualFrame.this.updateIndividual(ind);
            }
        });
        this.restore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Individual ind = (Individual)IndividualFrame.this.table.getValueAt(IndividualFrame.this.activeRow, 0);
                ind.setRejected(false);
                IndividualFrame.this.updateIndividual(ind);
            }
        });
        this.debugImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Individual ind = (Individual)IndividualFrame.this.table.getValueAt(IndividualFrame.this.activeRow, 0);
                IndividualFrame.this.firePropertyChange("DebugIndividual", null, ind);
            }
        });
        this.editImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Individual ind = (Individual)IndividualFrame.this.table.getValueAt(IndividualFrame.this.activeRow, 0);
                IndividualFrame.this.firePropertyChange("EditIndividual", null, ind);
            }
        });
        this.saveAsModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Individual ind = (Individual)IndividualFrame.this.table.getValueAt(IndividualFrame.this.activeRow, 0);
                CPXFile.saveModelFile(ind.getSplineGroup());
            }
        });
        this.individualPopup.add(this.debugImage);
        this.individualPopup.add(this.editImage);
        this.individualPopup.add(this.reject);
        this.individualPopup.add(this.restore);
        this.individualPopup.addSeparator();
        this.individualPopup.add(this.saveAsModel);
        this.restore.setVisible(false);
        this.setClosable(false);
        this.content.setLayout(new GridLayout(1, 0));
        this.all = individuals.toArray();
        this.individualTableModel = new IndividualTableModel(this.all);
        this.table = new IndividualJTable(this.individualTableModel);
        this.sorter = new TableRowSorter<IndividualTableModel>(this.individualTableModel);
        this.table.setRowSorter(this.sorter);
        this.table.setAutoResizeMode(0);
        this.table.setToolTipText("Use right-click for options");
        DefaultTableHeaderCellRenderer headerRenderer = new DefaultTableHeaderCellRenderer();
        Enumeration<TableColumn> columns = this.table.getColumnModel().getColumns();
        for (int x = 0; x < 3; ++x) {
            columns.nextElement();
        }
        headerRenderer = new VerticalTableHeaderCellRenderer();
        while (columns.hasMoreElements()) {
            columns.nextElement().setHeaderRenderer(headerRenderer);
        }
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            DefaultTableColumnModel colModel = (DefaultTableColumnModel)this.table.getColumnModel();
            TableColumn col = colModel.getColumn(i);
            int width = 0;
            TableCellRenderer renderer = col.getHeaderRenderer();
            Component comp = null;
            for (int r = 0; r < this.table.getRowCount(); ++r) {
                renderer = this.table.getCellRenderer(r, i);
                comp = renderer.getTableCellRendererComponent(this.table, this.table.getValueAt(r, i), false, false, r, i);
                width = Math.max(width, 10 + comp.getPreferredSize().width);
            }
            comp = renderer.getTableCellRendererComponent(this.table, col.getHeaderValue(), false, false, 0, 0);
            width = i < 3 ? Math.max(width, 2 * comp.getPreferredSize().width) : Math.max(width, comp.getPreferredSize().height);
            col.setPreferredWidth(width + 2);
        }
        this.table.setPreferredScrollableViewportSize(new Dimension(475, 900));
        this.table.setFillsViewportHeight(true);
        this.table.setRowSelectionAllowed(true);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    System.out.println("Debug at individualFrame");
                    if (GlobalVariables.masterSplineGroup == null) {
                        JOptionPane.showInternalMessageDialog(IndividualFrame.this, "Please select a cpXFile first !");
                    } else {
                        Individual ind = (Individual)IndividualFrame.this.table.getValueAt(IndividualFrame.this.table.getSelectedRow(), 0);
                        if (GlobalVariables.wingsStatus >= 7) {
                            IndividualFrame.this.firePropertyChange("EditIndividual", null, ind);
                        } else {
                            IndividualFrame.this.firePropertyChange("DebugIndividual", null, ind);
                        }
                    }
                } else if (me.isPopupTrigger()) {
                    this.maybeShowPopup(me);
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    this.maybeShowPopup(me);
                }
            }

            private void maybeShowPopup(MouseEvent me) {
                IndividualFrame.this.activeRow = IndividualFrame.this.table.rowAtPoint(me.getPoint());
                Individual ind = (Individual)IndividualFrame.this.table.getValueAt(IndividualFrame.this.activeRow, 0);
                if (ind.isRejected()) {
                    IndividualFrame.this.reject.setVisible(false);
                    IndividualFrame.this.restore.setVisible(true);
                } else {
                    IndividualFrame.this.reject.setVisible(true);
                    IndividualFrame.this.restore.setVisible(false);
                }
                IndividualFrame.this.individualPopup.show(IndividualFrame.this.table, me.getX(), me.getY());
            }
        });
        this.sexesSelection.insertItemAt("All", 0);
        int count = 1;
        for (int x = 0; x < GlobalVariables.sexes.length; ++x) {
            if (!GlobalVariables.sexes[x]) continue;
            this.sexesSelection.insertItemAt(Sex.names[x], count++);
        }
        this.sexesSelection.setSelectedIndex(0);
        this.showAll.setSelected(true);
        this.showAll.setActionCommand("All");
        this.showOutliers.setActionCommand("Outliers");
        this.showUnsplined.setActionCommand("Unsplined");
        this.showAll.addActionListener(this);
        this.showOutliers.addActionListener(this);
        this.showUnsplined.addActionListener(this);
        this.showGroup.add(this.showAll);
        this.showGroup.add(this.showOutliers);
        this.showOutliers.setEnabled(false);
        this.showGroup.add(this.showUnsplined);
        this.individualFilter();
        this.top.setLayout(new GridBagLayout());
        JGridBag.add(this.top, (Component)this.showLabel, 0, 0, 1, 1);
        JGridBag.add(this.top, (Component)this.showAll, 1, 0, 1, 1);
        JGridBag.add(this.top, (Component)this.showOutliers, 2, 0, 1, 1);
        JGridBag.add(this.top, (Component)this.showUnsplined, 3, 0, 1, 1);
        JGridBag.add(this.top, (Component)this.sexesSelection, 4, 0, 1, 1);
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.table);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.top, "North");
        this.sexesSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                System.out.println(e);
                IndividualFrame.this.individualFilter();
            }
        });
        this.setSize(475, 900);
        this.setLocation(650, 0);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.individualFilter();
    }

    private void individualFilter() {
        RowFilter<IndividualTableModel, Integer> individualFilter = new RowFilter<IndividualTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends IndividualTableModel, ? extends Integer> entry) {
                IndividualTableModel individualTableModel = entry.getModel();
                Individual individual = individualTableModel.getIndividual(entry.getIdentifier());
                if (IndividualFrame.this.showGroup.getSelection().getActionCommand().equalsIgnoreCase("Outliers") && !individual.isOutlier()) {
                    return false;
                }
                if (IndividualFrame.this.showGroup.getSelection().getActionCommand().equalsIgnoreCase("Unsplined") && individual.getProcessingStatus() >= 8) {
                    return false;
                }
                if (((String)IndividualFrame.this.sexesSelection.getSelectedItem()).equalsIgnoreCase("All")) {
                    return true;
                }
                return Sex.names[individual.sex()].equalsIgnoreCase((String)IndividualFrame.this.sexesSelection.getSelectedItem());
            }
        };
        this.sorter.setRowFilter(individualFilter);
    }

    public void updateIndividual(Individual ind) {
        int row = this.individualTableModel.updateIndividual(ind);
        if (ind.isOutlier()) {
            this.showOutliers.setEnabled(true);
        }
    }

    public void updateAllIndividuals(IndGroup individuals) {
        for (int i = 0; i < this.all.length; ++i) {
            this.updateIndividual(this.all[i]);
        }
    }

    public IndGroup getSelectedIndividuals() {
        IndGroup selectedIndividuals = new IndGroup(GlobalVariables.LMDefinition, 2, "Selected");
        int[] selected = this.table.getSelectedRows();
        Individual ind = null;
        for (int i = 0; i < selected.length; ++i) {
            ind = (Individual)this.table.getValueAt(selected[i], 0);
            selectedIndividuals.put(ind.ID, ind);
        }
        return selectedIndividuals;
    }
}

