/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.individual;

import commonSense.math.linear.Matrix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import kim.bin.bio.wings.GlobalVariables;
import kim.bin.bio.wings.individual.Individual;
import kim.bin.bio.wings.individual.IndividualStatus;
import kim.bin.bio.wings.landmark.LandMarkDefinition;
import kim.bin.bio.wings.landmark.LandMarks;
import kim.bio.Sex;
import kim.math.Random;

public class IndGroup
extends LinkedHashMap<String, Individual>
implements Sex,
IndividualStatus {
    private static final long serialVersionUID = 1L;
    private int noIndividuals = 0;
    private int noExcluded = 0;
    private int noOutliers = 0;
    private int noImages = 0;
    private LandMarkDefinition LMDef;
    private LandMarks consensus = null;
    private int dim = 0;
    private String name = "";

    public IndGroup(LandMarkDefinition LMDefinition, int dim, String name) {
        this.name = name;
        this.LMDef = LMDefinition;
        this.dim = dim;
    }

    public IndGroup(int initialCapacity, LandMarkDefinition LMDefinition, int dim, String name) {
        super(initialCapacity);
        this.name = name;
        this.LMDef = LMDefinition;
        this.dim = dim;
    }

    @Override
    public void clear() {
        super.clear();
        this.noIndividuals = 0;
        this.noExcluded = 0;
        this.noOutliers = 0;
        this.consensus = null;
        this.noImages = 0;
        this.LMDef = null;
        this.dim = 0;
    }

    public Object remove(String key) {
        Individual o = (Individual)super.remove(key);
        --this.noIndividuals;
        if (o.getProcessingStatus() == 3) {
            --this.noImages;
        }
        if (o.getProcessingStatus() == -1) {
            --this.noExcluded;
        }
        if (o.isOutlier()) {
            --this.noOutliers;
        }
        return o;
    }

    @Override
    public Individual put(String key, Individual newInd) {
        GlobalVariables.sexes[newInd.sex()] = true;
        if (!this.containsKey(key)) {
            ++this.noIndividuals;
            if (newInd.getProcessingStatus() == 3) {
                ++this.noImages;
            } else if (newInd.getProcessingStatus() == 0) {
                ++this.noExcluded;
            }
            if (newInd.isOutlier()) {
                ++this.noOutliers;
            }
        }
        return super.put(key, newInd);
    }

    public int getImageCount() {
        return this.noImages;
    }

    public int nonExcludedCount() {
        return this.noIndividuals - this.noExcluded;
    }

    public int totalNumber() {
        return this.noIndividuals;
    }

    public int nonOutlierCount() {
        return this.noIndividuals - (this.noExcluded + this.noOutliers);
    }

    public int getNoLandmarks(boolean subsetOnly) {
        return this.LMDef.getNoLandMarks(subsetOnly);
    }

    public int setState(String name, int IndState) {
        Individual ind = (Individual)this.get(name);
        if (IndState == 0 && ind.getProcessingStatus() != 0) {
            ind.setProcessingStatus(IndState);
            ++this.noExcluded;
        } else if (IndState != 0 && ind.getProcessingStatus() == 0) {
            ind.setProcessingStatus(IndState);
            --this.noExcluded;
        } else if (IndState != ind.getProcessingStatus()) {
            ind.setProcessingStatus(IndState);
        }
        return IndState;
    }

    public int setOutlierIteration(String name, int iteration) {
        Individual ind = (Individual)this.get(name);
        if (ind == null) {
            return -1;
        }
        if (iteration != ind.getOutlierIteration()) {
            ind.setOutlier(iteration);
            this.noOutliers = ind.isOutlier() ? ++this.noOutliers : --this.noOutliers;
        }
        return iteration;
    }

    public String toString(boolean isExcluded, boolean isOutlier) {
        Iterator i = this.keySet().iterator();
        String data = this.name + ": ";
        while (i.hasNext()) {
            Individual ind = (Individual)this.get(i.next());
            if (ind.getProcessingStatus() == -1 || ind.isOutlier()) continue;
            data = data + ind.ID + "; ";
        }
        return data;
    }

    public Individual[] getSubset(int state) {
        ArrayList<Individual> subset = new ArrayList<Individual>(10);
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            Individual ind = (Individual)this.get(i.next());
            if (ind.getProcessingStatus() != state || ind.isRejected()) continue;
            subset.add(ind);
        }
        return IndGroup.toArray(subset);
    }

    public Individual[] getSubset(int sex, int state) {
        ArrayList<Individual> subset = new ArrayList<Individual>(10);
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            Individual ind = (Individual)this.get(i.next());
            if (ind.sex() != sex || ind.getProcessingStatus() < state || ind.isRejected()) continue;
            subset.add(ind);
        }
        return IndGroup.toArray(subset);
    }

    private static Individual[] toArray(ArrayList<Individual> subset) {
        int length = subset.size();
        Individual[] i = new Individual[length];
        for (int a = 0; a < length; ++a) {
            i[a] = subset.get(a);
        }
        return i;
    }

    public Individual[] toArray() {
        return this.toArray(2);
    }

    public Individual[] toArray(int state) {
        Collection<Individual> c = this.values(state);
        int length = c.size();
        Individual[] ind = new Individual[length];
        Iterator<Individual> i = c.iterator();
        for (int a = 0; a < length; ++a) {
            ind[a] = i.next();
        }
        return ind;
    }

    public Matrix[] getRawLandmarkMatrices(boolean onlySubset, int status, boolean distortionCorrection, boolean rotationCorrection) {
        return IndGroup.getRawLandmarkMatrices(this.toArray(status), onlySubset, status, distortionCorrection, rotationCorrection);
    }

    public static Matrix[] getRawLandmarkMatrices(Individual[] inds, boolean onlySubset, int status, boolean distortionCorrection, boolean rotationCorrection) {
        ArrayList<Individual> subsubset = new ArrayList<Individual>(10);
        int length = inds.length;
        for (int a = 0; a < length; ++a) {
            if (!inds[a].hasSplineGroup() || inds[a].getProcessingStatus() < status) continue;
            subsubset.add(inds[a]);
        }
        length = subsubset.size();
        inds = IndGroup.toArray(subsubset);
        Matrix[] m = new Matrix[length];
        for (int a = 0; a < length; ++a) {
            m[a] = inds[a].getRawLandMarks().getCorrectedDataMatrix(onlySubset, distortionCorrection, rotationCorrection);
        }
        return m;
    }

    public Matrix[] getSemiLandmarkMatrices(int splineNo, int numberOfSemiLandMarks, int status, boolean distortionCorrection, boolean rotationCorrection) {
        return IndGroup.getSemiLandmarkMatrices(this.toArray(status), splineNo, numberOfSemiLandMarks, status, distortionCorrection, rotationCorrection);
    }

    public static Matrix[] getSemiLandmarkMatrices(Individual[] inds, int splineNo, int numberOfSemiLandMarks, int status, boolean distortionCorrection, boolean rotationCorrection) {
        ArrayList<Individual> subsubset = new ArrayList<Individual>(10);
        int length = inds.length;
        for (int a = 0; a < length; ++a) {
            if (!inds[a].hasSplineGroup() || inds[a].getProcessingStatus() < status) continue;
            subsubset.add(inds[a]);
        }
        length = subsubset.size();
        inds = IndGroup.toArray(subsubset);
        Matrix[] m = new Matrix[length];
        for (int a = 0; a < length; ++a) {
            m[a] = inds[a].getSplineGroup().getSemiLandMarks(splineNo, numberOfSemiLandMarks, distortionCorrection, rotationCorrection);
        }
        return m;
    }

    @Override
    public Collection<Individual> values() {
        return this.values(2);
    }

    public Collection<Individual> values(int inclusionCriterion) {
        LinkedHashMap<String, Individual> c = new LinkedHashMap<String, Individual>(10);
        for (Individual ind : super.values()) {
            if (ind.getProcessingStatus() < inclusionCriterion) continue;
            c.put(ind.ID, ind);
        }
        return c.values();
    }

    public void reset() {
        Iterator<Individual> i = this.values().iterator();
        while (i.hasNext()) {
            i.next().reset();
        }
    }

    public void saveAll() {
        Iterator<Individual> i = this.values().iterator();
        Object ind = null;
        while (i.hasNext()) {
            i.next().saveData(true);
        }
    }

    public IndGroup getFraction(double fraction) {
        IndGroup fractionInd = new IndGroup(this.LMDef, this.dim, "Fraction");
        int[] series = Random.seriesInt(this.size());
        int cutoff = (int)((double)this.size() * fraction);
        Individual[] individuals = this.toArray();
        for (int i = 0; i < series.length; ++i) {
            if (series[i] > cutoff) continue;
            fractionInd.put(individuals[i].ID, individuals[i]);
        }
        return fractionInd;
    }

    public IndGroup getOutliers() {
        IndGroup outlierInd = new IndGroup(this.LMDef, this.dim, "Outliers");
        Individual[] individuals = this.toArray();
        for (int i = 0; i < individuals.length; ++i) {
            if (!individuals[i].isOutlier()) continue;
            outlierInd.put(individuals[i].ID, individuals[i]);
        }
        return outlierInd;
    }
}

