/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.images;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.text.NumberFormatter;
import kim.bin.bio.wings.WingsInternalFrame;
import kim.bin.bio.wings.images.DisplayImage;
import kim.bin.bio.wings.individual.IndGroup;
import kim.bin.bio.wings.individual.Individual;
import kim.bin.bio.wings.individual.IndividualStatus;
import kim.bin.bio.wings.splining.ImageProcessing;
import kim.util.JGridBag;

public class TiffViewerFrame
extends WingsInternalFrame
implements IndividualStatus {
    private static final long serialVersionUID = 1L;
    private String[] magnifications = new String[]{"100%", "125%", "150%", "175%", "200%", "225%", "250%", "275%", "300%"};
    private JComboBox magnificationComboBox = new JComboBox<String>(this.magnifications);
    private JLabel magnificationLabel = new JLabel("Magnification:");
    private JLabel goL = new JLabel("Go to image number:");
    private JFormattedTextField currentNo;
    private JButton next = new JButton("next");
    private JButton previous = new JButton("previous");
    private JButton reject = new JButton("reject");
    private JButton respline = new JButton("respline");
    private GridBagLayout gb = new GridBagLayout();
    private JPanel buttons = new JPanel(this.gb);
    private JPanel images = new JPanel(this.gb);
    private DisplayImage originalImage = new DisplayImage();
    private DisplayImage splineImage = new DisplayImage();
    private int current = 0;
    private float magnification = 1.0f;
    private Individual[] allIndividuals = null;
    private ImageProcessing ip = null;
    private JLabel nameLabel = new JLabel("");

    public TiffViewerFrame(IndGroup individuals) throws IOException {
        super("Tiff Viewer version 2.0");
        this.allIndividuals = individuals.toArray();
        this.setDefaultCloseOperation(1);
        NumberFormat intNumberFormat = NumberFormat.getIntegerInstance();
        intNumberFormat.setGroupingUsed(false);
        NumberFormatter startformatter = new NumberFormatter(intNumberFormat);
        startformatter.setMinimum(Integer.valueOf(0));
        startformatter.setMaximum(new Integer(Integer.MAX_VALUE));
        this.currentNo = new JFormattedTextField(startformatter);
        this.currentNo.setValue(0);
        this.currentNo.setColumns(5);
        this.setIndividual(null, this.allIndividuals[this.current]);
        this.setLayout(new GridBagLayout());
        JGridBag.add(this.images, (Component)this.originalImage, 0, 1, 1, 1);
        JGridBag.add(this.images, (Component)this.splineImage, 1, 1, 1, 1);
        JGridBag.add(this.buttons, (Component)this.reject, 0, 0, 1, 1);
        JGridBag.add(this.buttons, (Component)this.goL, 1, 0, 1, 1);
        JGridBag.add(this.buttons, (Component)this.currentNo, 2, 0, 1, 1);
        JGridBag.add(this.buttons, (Component)this.magnificationLabel, 3, 0, 1, 1);
        JGridBag.add(this.buttons, (Component)this.magnificationComboBox, 4, 0, 1, 1);
        JGridBag.add(this.buttons, (Component)this.previous, 5, 0, 1, 1);
        JGridBag.add(this.buttons, (Component)this.next, 6, 0, 1, 1);
        JGridBag.add(this.buttons, (Component)this.respline, 8, 0, 1, 1);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.images, "Center");
        this.getContentPane().add((Component)this.buttons, "South");
        this.getContentPane().add((Component)this.nameLabel, "North");
        this.validate();
        this.pack();
        this.setVisible(true);
        this.respline.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                TiffViewerFrame.this.firePropertyChange("SplineIndividual", null, TiffViewerFrame.this.allIndividuals[TiffViewerFrame.this.current]);
            }
        });
        this.next.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                TiffViewerFrame.this.next();
            }
        });
        this.previous.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                TiffViewerFrame.this.previous();
            }
        });
        this.reject.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                TiffViewerFrame.this.allIndividuals[TiffViewerFrame.this.current].setRejected(true);
                if (!TiffViewerFrame.this.next()) {
                    TiffViewerFrame.this.previous();
                }
            }
        });
        this.magnificationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String d = (String)TiffViewerFrame.this.magnificationComboBox.getSelectedItem();
                d = d.substring(0, d.length() - 1);
                TiffViewerFrame.this.magnification = Float.parseFloat(d) / 100.0f;
                TiffViewerFrame.this.rescaleImages(TiffViewerFrame.this.magnification);
                TiffViewerFrame.this.pack();
            }
        });
        this.currentNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TiffViewerFrame.this.setIndividual(TiffViewerFrame.this.allIndividuals[TiffViewerFrame.this.current], TiffViewerFrame.this.allIndividuals[Integer.parseInt(e.getActionCommand())]);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                System.out.println("this " + e.getKeyCode());
                if (e.getKeyCode() == 39) {
                    TiffViewerFrame.this.next();
                }
                if (e.getKeyCode() == 37) {
                    TiffViewerFrame.this.previous();
                }
            }
        });
        this.next.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                System.out.println("next " + e.getKeyCode());
                if (e.getKeyCode() == 39) {
                    TiffViewerFrame.this.next();
                }
                if (e.getKeyCode() == 37) {
                    TiffViewerFrame.this.previous();
                }
            }
        });
        this.previous.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                System.out.println("previous " + e.getKeyCode());
                if (e.getKeyCode() == 39) {
                    TiffViewerFrame.this.next();
                }
                if (e.getKeyCode() == 37) {
                    TiffViewerFrame.this.previous();
                }
            }
        });
        this.reject.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                System.out.println("reject " + e.getKeyCode());
                if (e.getKeyCode() == 39) {
                    TiffViewerFrame.this.next();
                }
                if (e.getKeyCode() == 37) {
                    TiffViewerFrame.this.previous();
                }
            }
        });
        this.respline.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                System.out.println("reject " + e.getKeyCode());
                if (e.getKeyCode() == 39) {
                    TiffViewerFrame.this.next();
                }
                if (e.getKeyCode() == 37) {
                    TiffViewerFrame.this.previous();
                }
            }
        });
        this.magnificationComboBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                System.out.println("reject " + e.getKeyCode());
                if (e.getKeyCode() == 39) {
                    TiffViewerFrame.this.next();
                }
                if (e.getKeyCode() == 37) {
                    TiffViewerFrame.this.previous();
                }
            }
        });
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                TiffViewerFrame.this.firePropertyChange("Changed individuals", TiffViewerFrame.this.allIndividuals[TiffViewerFrame.this.current], null);
            }
        });
    }

    private boolean next() {
        Individual currentInd = this.allIndividuals[this.current];
        Individual nextInd = this.allIndividuals[++this.current];
        try {
            if (nextInd.getProcessingStatus() >= 5) {
                this.setIndividual(currentInd, nextInd);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        return true;
    }

    private boolean previous() {
        Individual currentInd = this.allIndividuals[this.current];
        Individual nextInd = this.allIndividuals[--this.current];
        try {
            if (nextInd.getProcessingStatus() >= 5) {
                this.setIndividual(currentInd, nextInd);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        return true;
    }

    public void setIndividual(Individual oldIndividual, Individual newIndividual) {
        this.ip = null;
        this.firePropertyChange("Changed individuals", oldIndividual, newIndividual);
        this.originalImage.setImageData(newIndividual.getRawImageData());
        this.originalImage.setText(newIndividual.ID);
        this.splineImage.setImageData(newIndividual.getRawImageData());
        if (newIndividual.hasSplineGroup()) {
            this.splineImage.setSplineGroup(newIndividual.getSplineGroup(), true);
            this.splineImage.setText("");
        } else {
            this.splineImage.setText("Not yet splined");
        }
        this.nameLabel.setText("    Viewing " + newIndividual.ID);
        this.validate();
    }

    public void rescaleImages(float magnification) {
        this.originalImage.setMagnification(magnification);
        this.splineImage.setMagnification(magnification);
        this.validate();
    }

    public void update(String propertyName, int newValue) {
        System.out.println("(Tiffviewer) Property name: " + propertyName);
        if (this.ip == null) {
            this.ip = new ImageProcessing(this.allIndividuals[this.current]);
        }
        int x = 0;
        if (this.allIndividuals[this.current].hasSplineGroup()) {
            if (this.allIndividuals[this.current].ready) {
                this.allIndividuals[this.current].debugged = true;
            }
            if ("openRadius".equals(propertyName)) {
                this.allIndividuals[this.current].splineParameters.openRadius = newValue;
                x = 1;
            } else if ("structElementHeight".equals(propertyName)) {
                this.allIndividuals[this.current].splineParameters.structElementHeight = newValue;
                x = 1;
            } else if ("threshold".equals(propertyName)) {
                this.allIndividuals[this.current].splineParameters.threshold = newValue;
                x = 2;
            } else if ("fillSize".equals(propertyName)) {
                this.allIndividuals[this.current].splineParameters.fillSize = newValue;
                x = 3;
            } else if ("shortCleanSegment".equals(propertyName)) {
                this.allIndividuals[this.current].splineParameters.shortCleanSegment = newValue;
                x = 5;
            } else if ("longCleanSegment".equals(propertyName)) {
                this.allIndividuals[this.current].splineParameters.longCleanSegment = newValue;
                x = 6;
            }
            this.splineImage.setSplineGroup(this.ip.process(x, this.allIndividuals[this.current]), true);
            this.splineImage.setText("");
            this.splineImage.update();
        }
    }

    public void update() {
        this.splineImage.setSplineGroup(this.allIndividuals[this.current].getSplineGroup(), true);
        this.splineImage.update();
    }

    public Individual getCurrentIndividual() {
        return this.allIndividuals[this.current];
    }
}

