/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.images;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.Stack;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import kim.bin.bio.wings.GlobalVariables;
import kim.bin.bio.wings.images.DisplayImage;
import kim.bin.bio.wings.images.LMCircle;
import kim.bin.bio.wings.individual.Individual;
import kim.bin.bio.wings.landmark.LandMarkDefinition;
import kim.bin.bio.wings.landmark.LandMarkLocation;
import kim.bin.bio.wings.spline.Spline;
import kim.bin.bio.wings.spline.SplineGroup;

public class EditableImage
extends DisplayImage {
    private static final long serialVersionUID = 1L;
    private int[] splinePointLocation = null;
    private long timeStamp = System.currentTimeMillis();
    private double[][] data = null;
    private Individual individual = null;
    private Stack<SplineGroup> splineGroupStack = new Stack();
    private JPopupMenu popup = new JPopupMenu();
    private JMenuItem addControlPointItem = new JMenuItem("Add control point");
    private JMenuItem removeControlPointItem = new JMenuItem("Remove control point");
    private int splineNo = -1;
    private double x;
    private double y;
    public boolean modelModified = false;

    public EditableImage() {
        this.setMultiColor(true);
        this.setEditMode(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                System.out.println(e);
                System.out.println(e.getKeyCode());
                if (e.getKeyCode() == 90) {
                    EditableImage.this.firePropertyChange("undoLMEdit", 0, 90);
                }
                if (e.getKeyCode() == 39) {
                    EditableImage.this.firePropertyChange("nextLMEdit", 0, 39);
                }
                if (e.getKeyCode() == 37) {
                    EditableImage.this.firePropertyChange("previousLMEdit", 0, 37);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                EditableImage.this.x = (float)(e.getX() - EditableImage.this.borderWidth) / EditableImage.this.magnification;
                EditableImage.this.y = (float)(e.getY() - EditableImage.this.borderWidth) / EditableImage.this.magnification;
                if (EditableImage.this.splinePointLocation != null) {
                    EditableImage.this.splinePoints[EditableImage.this.splinePointLocation[0]][EditableImage.this.splinePointLocation[1]].setCenter(EditableImage.this.x, EditableImage.this.y);
                    EditableImage.this.splines.getSpline(EditableImage.this.splinePointLocation[0]).setEntry(EditableImage.this.splinePointLocation[1], 0, EditableImage.this.x);
                    EditableImage.this.splines.getSpline(EditableImage.this.splinePointLocation[0]).setEntry(EditableImage.this.splinePointLocation[1], 1, EditableImage.this.y);
                    EditableImage.this.repaint();
                }
            }
        });
        this.addControlPointItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableImage.this.splines.getSpline(EditableImage.this.splineNo).insertControlPoint(EditableImage.this.x, EditableImage.this.y);
                EditableImage.this.setEditableSplineGroup(EditableImage.this.splines);
                EditableImage.this.modelModified = true;
                EditableImage.this.repaint();
            }
        });
        this.removeControlPointItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("What the heck is going on?");
                System.out.println("splinePointLocation[0]: " + EditableImage.this.splinePointLocation[0]);
                System.out.println("splinePointLocation[1]: " + EditableImage.this.splinePointLocation[1]);
                System.out.println("splineNo: " + EditableImage.this.splineNo);
                EditableImage.this.splines.getSpline(EditableImage.this.splineNo).removeControlPoint(EditableImage.this.splinePointLocation[1]);
                EditableImage.this.setEditableSplineGroup(EditableImage.this.splines);
                EditableImage.this.modelModified = true;
                EditableImage.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                EditableImage.this.popup.removeAll();
                EditableImage.access$202(EditableImage.this, null);
                EditableImage.this.x = (float)(e.getX() - EditableImage.this.borderWidth) / EditableImage.this.magnification;
                EditableImage.this.y = (float)(e.getY() - EditableImage.this.borderWidth) / EditableImage.this.magnification;
                block0: for (int i = 0; i < EditableImage.this.splinePoints.length; ++i) {
                    for (int j = 0; j < EditableImage.this.splinePoints[i].length; ++j) {
                        System.out.println("processing splinepoint (" + i + "," + j + "): " + EditableImage.this.splinePoints[i][j]);
                        if (!EditableImage.this.splinePoints[i][j].contains(EditableImage.this.x, EditableImage.this.y)) continue;
                        EditableImage.access$202(EditableImage.this, new int[2]);
                        ((EditableImage)EditableImage.this).splinePointLocation[0] = i;
                        ((EditableImage)EditableImage.this).splinePointLocation[1] = j;
                        System.out.println("(LMEdit.pressed) splinePoint(" + EditableImage.this.splinePointLocation[0] + ", " + EditableImage.this.splinePointLocation[1] + ")");
                        break block0;
                    }
                }
                if (e.getModifiersEx() == 4096 || e.isPopupTrigger()) {
                    if (EditableImage.this.splinePointLocation == null) {
                        EditableImage.this.splineNo = EditableImage.this.splines.findClosestSpline(EditableImage.this.x, EditableImage.this.y);
                        EditableImage.this.splines.getSpline(EditableImage.this.splineNo);
                        EditableImage.this.popup.add(EditableImage.this.addControlPointItem);
                        EditableImage.this.addControlPointItem.setIcon(EditableImage.this.makeImageIcon(EditableImage.this.splineNo));
                        EditableImage.this.popup.show(e.getComponent(), e.getX() + 10, e.getY() + 10);
                    } else {
                        EditableImage.this.popup.add(EditableImage.this.removeControlPointItem);
                        EditableImage.this.splineNo = EditableImage.this.splinePointLocation[0];
                        EditableImage.this.removeControlPointItem.setIcon(EditableImage.this.makeImageIcon(EditableImage.this.splinePointLocation[0]));
                        EditableImage.this.popup.show(e.getComponent(), e.getX() + 10, e.getY() + 10);
                    }
                } else if (EditableImage.this.splinePointLocation != null) {
                    EditableImage.this.setCursor(new Cursor(1));
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                System.out.println(e);
                EditableImage.this.x = (float)(e.getX() - EditableImage.this.borderWidth) / EditableImage.this.magnification;
                EditableImage.this.y = (float)(e.getY() - EditableImage.this.borderWidth) / EditableImage.this.magnification;
                if (EditableImage.this.splinePointLocation != null) {
                    ((EditableImage)EditableImage.this).individual.modified = true;
                    System.out.println("Modified for " + ((EditableImage)EditableImage.this).individual.ID + " set to: " + ((EditableImage)EditableImage.this).individual.modified);
                    EditableImage.this.splinePoints[EditableImage.this.splinePointLocation[0]][EditableImage.this.splinePointLocation[1]].setCenter(EditableImage.this.x, EditableImage.this.y);
                    EditableImage.this.splines.getSpline(EditableImage.this.splinePointLocation[0]).setEntry(EditableImage.this.splinePointLocation[1], 0, EditableImage.this.x);
                    EditableImage.this.splines.getSpline(EditableImage.this.splinePointLocation[0]).setEntry(EditableImage.this.splinePointLocation[1], 1, EditableImage.this.y);
                    EditableImage.this.estimateLMs();
                    EditableImage.this.repaint();
                    EditableImage.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
    }

    private ImageIcon makeImageIcon(int splineNo) {
        BufferedImage iconImage = new BufferedImage(10, 10, 1);
        Graphics2D g = (Graphics2D)iconImage.getGraphics();
        g.fillRect(0, 0, 10, 10);
        g.setColor(GlobalVariables.colors[splineNo]);
        g.fillOval(1, 1, 8, 8);
        return new ImageIcon(iconImage);
    }

    public void stackSplines() {
        this.splineGroupStack.push(this.individual.getSplineGroup().splineGroupCopy());
    }

    public void reset() {
        SplineGroup s = null;
        if (!this.splineGroupStack.empty()) {
            while (!this.splineGroupStack.empty()) {
                s = this.splineGroupStack.pop();
            }
            this.individual.setSplineGroup(s);
            this.splinePoints = null;
            this.setEditableSplineGroup(this.individual.getSplineGroup());
            this.repaint();
        }
    }

    public void undo() {
        if (!this.splineGroupStack.empty()) {
            this.individual.setSplineGroup(this.splineGroupStack.pop());
            this.setEditableSplineGroup(this.individual.getSplineGroup());
            this.repaint();
        }
    }

    protected void estimateLMs() {
        LandMarkDefinition LMDef = this.individual.getLandMarkDefinition();
        LandMarkLocation LMLoc = null;
        int splineNo = -1;
        int spline2No = -1;
        int points = LMDef.getNoLandMarks(false);
        for (int x = 0; x < points; ++x) {
            double[] b1;
            LMLoc = LMDef.getLandMarkLocation(x, false);
            splineNo = LMLoc.getBeginLocationSplineNo();
            if (splineNo != -1) {
                b1 = this.splines.getSpline(splineNo).getBeginPoint();
                spline2No = LMLoc.getMatchingSplineNo(splineNo);
                if (spline2No != -1) {
                    double[] b2 = this.splines.getSpline(spline2No).getBSplineMath().findClosestPoint(b1).getCoordinates();
                    this.splinePoints[splineNo][0].setCenter(b2[0], b2[1]);
                    this.splines.getSpline(splineNo).setEntry(0, 0, b2[0]);
                    this.splines.getSpline(splineNo).setEntry(0, 1, b2[1]);
                }
                spline2No = -1;
                continue;
            }
            splineNo = LMLoc.getEndLocationSplineNo();
            if (splineNo == -1) continue;
            b1 = this.splines.getSpline(splineNo).getEndPoint();
            int nooooooo = this.splines.getSpline(splineNo).getEndPointNo();
            spline2No = LMLoc.getMatchingSplineNo(splineNo);
            if (spline2No != -1) {
                double[] b2 = this.splines.getSpline(LMLoc.getMatchingSplineNo(splineNo)).getBSplineMath().findClosestPoint(b1).getCoordinates();
                this.splinePoints[splineNo][nooooooo].setCenter(b2[0], b2[1]);
                this.splines.getSpline(splineNo).setEntry(nooooooo, 0, b2[0]);
                this.splines.getSpline(splineNo).setEntry(nooooooo, 1, b2[1]);
            }
            spline2No = -1;
        }
    }

    public void setEditableSplineGroup(SplineGroup splineGroup) {
        this.splines = splineGroup;
        this.modelModified = false;
        Spline spline = null;
        int noSplines = splineGroup.getNoSplines();
        this.splinePoints = new LMCircle[noSplines][];
        for (int x = 0; x < noSplines; ++x) {
            spline = splineGroup.getSpline(x);
            System.out.println(spline);
            int noPoints = spline.getRowDimension();
            this.splinePoints[x] = new LMCircle[noPoints];
            this.data = spline.getData();
            for (int y = 0; y < noPoints; ++y) {
                this.splinePoints[x][y] = new LMCircle(this.data[y][0], this.data[y][1], 8.0);
            }
        }
    }

    public boolean setIndividual(Individual individual) {
        this.modelModified = false;
        this.individual = individual;
        System.out.println(this.individual);
        this.splineGroupStack.removeAllElements();
        System.out.println("LMEdit: " + this.individual.getProcessingStatus());
        this.setImageData(individual.getRawImageData());
        if (this.individual.hasSplineGroup()) {
            this.setEditableSplineGroup(this.individual.getSplineGroup());
            this.repaint();
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "" + this.individual.ID + " " + super.toString();
    }

    static /* synthetic */ int[] access$202(EditableImage x0, int[] x1) {
        x0.splinePointLocation = x1;
        return x1;
    }
}

