/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.images;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import kim.bin.bio.wings.WingsInternalFrame;
import kim.bin.bio.wings.fileTypes.CPXFile;
import kim.bin.bio.wings.images.EditableImage;
import kim.bin.bio.wings.individual.Individual;
import kim.bin.bio.wings.splining.ImageProcessing;
import kim.util.JGridBag;

public class EditFrame
extends WingsInternalFrame {
    private static final long serialVersionUID = 1L;
    private EditableImage edit = null;
    private JScrollPane editPane = new JScrollPane();
    private JButton next = new JButton(">");
    private JButton previous = new JButton("<");
    private JButton exit = new JButton("Continue with outliers");
    private boolean done = false;
    private JButton reset = new JButton("reset");
    private JButton undo = new JButton("undo");
    private JButton respline = new JButton("respline");
    private JButton reject = new JButton("reject");
    private String[] magnifications = new String[]{"100%", "125%", "150%", "175%", "200%", "225%", "250%", "275%", "300%", "325%", "350%", "375%", "400%", "425%", "450%", "475%", "500%"};
    private JComboBox scaling = new JComboBox<String>(this.magnifications);
    private JLabel scalingL = new JLabel("Magnification:");
    private JLabel name = new JLabel("Name goes here.");
    private Individual[] goods = null;
    private Individual[] outliers = null;
    private Individual[] processing = null;
    private int current = 0;
    private int total = 0;
    private ImageProcessing ip = null;

    public EditFrame(Individual[] goodIndividuals, Individual[] outlierIndividuals) {
        super("Spline Editor (v. 2.0)");
        this.setClosable(false);
        this.goods = goodIndividuals;
        this.outliers = outlierIndividuals;
        this.edit = new EditableImage();
        if (goodIndividuals != null) {
            JOptionPane.showMessageDialog(this, "The first batch are 10 good individuals, do NOT edit!");
            this.init(this.goods);
        } else {
            this.init(this.outliers);
            this.done = true;
            this.exit.setText("Finished");
        }
        this.scaling.setSelectedItem("250%");
        this.setMagnification(2.5f);
        this.setDefaultCloseOperation(2);
        this.editPane.setViewportView(this.edit);
        this.getContentPane().setLayout(new GridBagLayout());
        JGridBag.add(this, (Component)this.name, 0, 0, 8, 1);
        JGridBag.add(this, (Component)this.editPane, 0, 1, 8, 1);
        JGridBag.add(this, (Component)this.reject, 0, 2, 1, 1);
        JGridBag.add(this, (Component)this.respline, 1, 2, 1, 1);
        JGridBag.add(this, (Component)this.scalingL, 2, 2, 1, 1);
        JGridBag.add(this, (Component)this.scaling, 3, 2, 1, 1);
        JGridBag.add(this, (Component)this.previous, 5, 2, 1, 1);
        JGridBag.add(this, (Component)this.next, 6, 2, 1, 1);
        JGridBag.add(this, (Component)this.undo, 7, 2, 1, 1);
        JGridBag.add(this, (Component)this.reset, 8, 2, 1, 1);
        JGridBag.add(this, (Component)this.exit, 9, 2, 1, 1);
        this.next.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                EditFrame.this.next();
            }
        });
        this.previous.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                EditFrame.this.previous();
            }
        });
        this.undo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                EditFrame.this.undo();
            }
        });
        this.reset.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                EditFrame.this.reset();
            }
        });
        this.scaling.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String f = (String)EditFrame.this.scaling.getSelectedItem();
                f = f.substring(0, f.length() - 1);
                EditFrame.this.setMagnification(Float.parseFloat(f) / 100.0f);
            }
        });
        this.respline.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                EditFrame.this.firePropertyChange("SplineIndividual", null, EditFrame.this.processing[EditFrame.this.current]);
            }
        });
        this.exit.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                EditFrame.this.nextOrEnd();
            }
        });
        this.edit.addPropertyChangeListener("undoLMEdit", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                EditFrame.this.undo();
            }
        });
        this.edit.addPropertyChangeListener("nextLMEdit", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                EditFrame.this.next();
            }
        });
        this.edit.addPropertyChangeListener("previousLMEdit", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                EditFrame.this.previous();
            }
        });
        this.reject.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                EditFrame.this.processing[EditFrame.this.current].setRejected(true);
                EditFrame.this.next();
            }
        });
        this.setLocation(150, 0);
        this.setSize(500, 500);
        this.validate();
        this.pack();
    }

    private void nextOrEnd() {
        if (this.edit.modelModified) {
            this.saveSplineModel(this.processing[this.current]);
        }
        if (this.done) {
            this.setVisible(false);
            this.firePropertyChange("Finished Editing", this.processing[this.current], null);
        } else {
            this.done = true;
            this.init(this.outliers);
            this.exit.setText("Finished");
        }
    }

    private void next() {
        Individual ind = this.processing[this.current];
        if (this.edit.modelModified) {
            this.saveSplineModel(ind);
        }
        if (this.current < this.processing.length - 1) {
            this.changeUp(ind, this.processing[++this.current]);
        }
    }

    private void previous() {
        Individual ind = this.processing[this.current];
        if (this.edit.modelModified) {
            this.saveSplineModel(ind);
        }
        if (this.current > 0) {
            this.changeDown(ind, this.processing[--this.current]);
        }
    }

    private void changeUp(Individual oldIndividual, Individual newIndividual) {
        if (!this.change(oldIndividual, newIndividual) && this.current < this.processing.length - 1) {
            this.changeUp(oldIndividual, this.processing[++this.current]);
        }
    }

    private void changeDown(Individual oldIndividual, Individual newIndividual) {
        if (!this.change(oldIndividual, newIndividual) && this.current > 0) {
            this.changeDown(oldIndividual, this.processing[--this.current]);
        }
    }

    private boolean change(Individual oldIndividual, Individual newIndividual) {
        if (this.edit.setIndividual(newIndividual)) {
            this.ip = null;
            oldIndividual.saveData(false);
            this.firePropertyChange("Changed individuals", oldIndividual, newIndividual);
            this.name.setText((this.done ? "Outlier" : "Good") + " individuals (1/" + this.total + ") " + this.processing[0].getOutlierMessage());
            return true;
        }
        return false;
    }

    private void reset() {
        this.edit.reset();
    }

    private void undo() {
        this.edit.undo();
    }

    private void setMagnification(float magnification) {
        System.out.println("Magnification set to: " + magnification);
        this.edit.setMagnification(magnification);
        this.validate();
        this.pack();
    }

    private void init(Individual[] batch) {
        this.processing = batch;
        this.total = this.processing.length;
        this.current = 0;
        this.firePropertyChange("Changed individuals", null, this.processing[this.current]);
        this.name.setText((this.done ? "Outlier" : "Good") + " individuals (1/" + this.total + ") " + this.processing[0].getOutlierMessage());
        this.edit.setIndividual(this.processing[this.current]);
    }

    public void update() {
        this.edit.setEditableSplineGroup(this.processing[this.current].getSplineGroup());
        this.edit.update();
    }

    public void update(String propertyName, int newValue) {
        System.out.println("(Edit Frame) Property name: " + propertyName);
        if (this.ip == null) {
            this.ip = new ImageProcessing(this.processing[this.current]);
        }
        int x = 0;
        this.processing[this.current].debugged = true;
        if ("openRadius".equals(propertyName)) {
            this.processing[this.current].splineParameters.openRadius = newValue;
            x = 1;
        } else if ("structElementHeight".equals(propertyName)) {
            this.processing[this.current].splineParameters.structElementHeight = newValue;
            x = 1;
        } else if ("threshold".equals(propertyName)) {
            this.processing[this.current].splineParameters.threshold = newValue;
            x = 2;
        } else if ("fillSize".equals(propertyName)) {
            this.processing[this.current].splineParameters.fillSize = newValue;
            x = 3;
        } else if ("shortCleanSegment".equals(propertyName)) {
            this.processing[this.current].splineParameters.shortCleanSegment = newValue;
            x = 5;
        } else if ("longCleanSegment".equals(propertyName)) {
            this.processing[this.current].splineParameters.longCleanSegment = newValue;
            x = 6;
        }
        this.edit.setEditableSplineGroup(this.ip.process(x, this.processing[this.current]));
        this.edit.update();
    }

    private void saveSplineModel(Individual ind) {
        int action = JOptionPane.showConfirmDialog(this, "The spline model was altered by inserting or \nremoving controlpoints. Would you like to save it?", "Save new spline model?", 0, 3);
        if (action == 0) {
            CPXFile.saveModelFile(ind.getSplineGroup());
        }
    }
}

