/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.fileTypes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileNameExtensionFilter;
import kim.bin.bio.wings.landmark.LandMarkDefinition;
import kim.bin.bio.wings.landmark.LandMarkLocation;
import kim.bin.bio.wings.landmark.LandMarkSubset;
import kim.bin.bio.wings.spline.SplineLocationConstants;
import kim.io.file.ReadDataFile;

public class LandMarkDefinitionFile
implements SplineLocationConstants {
    private LandMarkDefinitionFile() {
    }

    public static LandMarkDefinition load(File f) throws FileNotFoundException, IOException {
        String data = ReadDataFile.getData(f);
        StringTokenizer lines = new StringTokenizer(data, "\n\r");
        String line = null;
        LandMarkDefinition LMDef = null;
        LandMarkSubset LMSubset = null;
        int location = 0;
        int count = -1;
        String dump = "";
        while (lines.hasMoreTokens()) {
            LandMarkLocation LMLoc;
            StringTokenizer cells;
            line = lines.nextToken();
            if (line.indexOf(35) != -1) continue;
            if (line.indexOf("fullset.count") != -1) {
                LMDef = new LandMarkDefinition(Integer.parseInt(line.substring(line.lastIndexOf(61) + 1)));
                continue;
            }
            if (line.indexOf("fullset.name") != -1) {
                LMDef.setName(line.substring(line.lastIndexOf(61) + 1));
                continue;
            }
            if (line.indexOf("fullset:") != -1) {
                ++count;
                cells = new StringTokenizer(line, ":;, \t");
                dump = cells.nextToken();
                location = Integer.parseInt(cells.nextToken());
                LMLoc = new LandMarkLocation(location);
                if (cells.countTokens() == 2) {
                    LMLoc.setLocation(LandMarkDefinitionFile.getInt(cells.nextToken()), LandMarkDefinitionFile.getInt(cells.nextToken()));
                } else if (cells.countTokens() == 4) {
                    LMLoc.setLocation(LandMarkDefinitionFile.getInt(cells.nextToken()), LandMarkDefinitionFile.getInt(cells.nextToken()), LandMarkDefinitionFile.getInt(cells.nextToken()), LandMarkDefinitionFile.getInt(cells.nextToken()));
                } else {
                    throw new IOException("Incorrect input");
                }
                LMDef.setLMLocation(location, LMLoc, false);
                continue;
            }
            if (line.indexOf("subset.points") != -1) {
                LMSubset = new LandMarkSubset("Subset");
                LMSubset.setPoints(line.substring(line.lastIndexOf(61) + 1));
                LMDef.setSubset(LMSubset);
                continue;
            }
            if (line.indexOf("user.set") == -1) continue;
            int noUserMarks = Integer.parseInt(line.substring(line.lastIndexOf(61) + 1));
            for (int x = 0; x < noUserMarks; ++x) {
                cells = new StringTokenizer(lines.nextToken(), ":;, \t");
                dump = cells.nextToken();
                location = Integer.parseInt(cells.nextToken());
                LMLoc = new LandMarkLocation(location);
                LMLoc.setLocation(LandMarkDefinitionFile.getInt(cells.nextToken()), LandMarkDefinitionFile.getInt(cells.nextToken()));
                LMDef.setUserMarkLocation(x, LMLoc);
            }
        }
        return LMDef;
    }

    private static int getInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            if (s.equalsIgnoreCase("BEGIN")) {
                return 0;
            }
            if (s.equalsIgnoreCase("END")) {
                return 1;
            }
            if (s.equalsIgnoreCase("NULL")) {
                return -1;
            }
            if (s.equalsIgnoreCase("EMPTY")) {
                return -1;
            }
            if (s.equalsIgnoreCase("INTERNAL")) {
                return 2;
            }
            if (s.equalsIgnoreCase("CONTROL")) {
                return 3;
            }
            if (s.equalsIgnoreCase("UNDEFINED")) {
                return 4;
            }
            return -1;
        }
    }

    public static FileNameExtensionFilter getFilter() {
        return new FileNameExtensionFilter("LandMark definition files (*.definition)", "definition");
    }
}

