/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.fileTypes;

import commonSense.math.linear.PointXD;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileNameExtensionFilter;
import kim.bin.bio.wings.GlobalVariables;
import kim.bin.bio.wings.dataImport.DataCheck;
import kim.bin.bio.wings.dataImport.DataException;
import kim.bin.bio.wings.individual.Individual;
import kim.bin.bio.wings.individual.IndividualStatus;
import kim.bin.bio.wings.landmark.LandMarkDefinition;
import kim.bin.bio.wings.spline.Spline;
import kim.bin.bio.wings.spline.SplineGroup;
import kim.bio.Sex;
import kim.io.file.ReadDataFile;

public class CPFile
implements IndividualStatus {
    public static Individual read(File f, LandMarkDefinition LMDefinition, int dim) throws FileNotFoundException, IOException, DataException {
        Individual ind = new Individual(LMDefinition, dim);
        return CPFile.add(f, ind, false);
    }

    public static Individual add(File f, Individual ind) throws FileNotFoundException, IOException, DataException {
        return CPFile.add(f, ind, true);
    }

    public static Individual replace(File f, Individual ind) throws FileNotFoundException, IOException, DataException {
        return CPFile.add(f, ind, false);
    }

    private static Individual add(File f, Individual ind, boolean increment) throws FileNotFoundException, IOException, DataException {
        int x;
        StringTokenizer cells;
        String data = ReadDataFile.getData(f);
        GlobalVariables.workDirectory = f.getParentFile();
        StringTokenizer lines = new StringTokenizer(data, "\n\r");
        String currentLine = lines.nextToken();
        if (!currentLine.startsWith("#")) {
            System.out.println("(CPFile.read) Cannot process file!");
            return null;
        }
        int noSplines = 0;
        ind.setWingCode(f.getName());
        if (currentLine.equalsIgnoreCase("# CPversion: 2.0")) {
            String key = "";
            do {
                if ((key = (cells = new StringTokenizer(currentLine, "#: \t")).nextToken()).equalsIgnoreCase("Image")) {
                    ind.ID = cells.nextToken();
                    ind.setImageFile(ind.ID);
                    continue;
                }
                if (key.equalsIgnoreCase("UserCoordinates")) {
                    ind.setUserMarkCoordinates(new PointXD(DataCheck.checkDouble(cells.nextToken()), DataCheck.checkDouble(cells.nextToken())), new PointXD(DataCheck.checkDouble(cells.nextToken()), DataCheck.checkDouble(cells.nextToken())));
                    continue;
                }
                if (key.equalsIgnoreCase("Imager") || key.equalsIgnoreCase("ImagedBy")) {
                    ind.imagedBy = cells.nextToken();
                    continue;
                }
                if (key.equalsIgnoreCase("Date")) {
                    ind.date = DataCheck.checkDate(cells.nextToken());
                    continue;
                }
                if (key.equalsIgnoreCase("Time")) {
                    ind.time = DataCheck.checkTime(cells.nextToken());
                    continue;
                }
                if (key.equalsIgnoreCase("ID") || key.equalsIgnoreCase("StrainID")) {
                    ind.strainID = cells.nextToken();
                    continue;
                }
                if (key.equalsIgnoreCase("Sex")) {
                    ind.sex = DataCheck.checkSex(cells.nextToken());
                    continue;
                }
                if (key.equalsIgnoreCase("Spliner") || key.equalsIgnoreCase("SplinedBy")) {
                    ind.splinedBy = cells.nextToken();
                    continue;
                }
                if (key.equalsIgnoreCase("ScaleFactor")) {
                    ind.pixelToMmScaling = DataCheck.checkDouble(cells.nextToken());
                    continue;
                }
                if (key.equalsIgnoreCase("OpenRadius")) {
                    System.out.println(ind.splineParameters.toString());
                    ind.splineParameters.openRadius = DataCheck.checkInt(cells.nextToken());
                    continue;
                }
                if (key.equalsIgnoreCase("StructuralElementHeight")) {
                    ind.splineParameters.structElementHeight = DataCheck.checkInt(cells.nextToken());
                    continue;
                }
                if (key.equalsIgnoreCase("Threshold")) {
                    ind.splineParameters.threshold = DataCheck.checkInt(cells.nextToken());
                    continue;
                }
                if (key.equalsIgnoreCase("FillSize")) {
                    ind.splineParameters.fillSize = DataCheck.checkInt(cells.nextToken());
                    continue;
                }
                if (key.equalsIgnoreCase("ShortCleanSegment")) {
                    ind.splineParameters.shortCleanSegment = DataCheck.checkInt(cells.nextToken());
                    continue;
                }
                if (key.equalsIgnoreCase("LongCleanSegment")) {
                    ind.splineParameters.longCleanSegment = DataCheck.checkInt(cells.nextToken());
                    continue;
                }
                if (!key.equalsIgnoreCase("Status") || !cells.nextToken().equalsIgnoreCase("REJECTED")) continue;
                ind.setRejected(true);
                return ind;
            } while ((currentLine = lines.nextToken()).startsWith("#"));
        } else {
            ind.setComment(currentLine);
            cells = new StringTokenizer(currentLine, " \t");
            cells.nextToken();
            cells.nextToken();
            ind.ID = cells.nextToken();
            ind.setImageFile(ind.ID);
            ind.setUserMarkCoordinates(new PointXD(DataCheck.checkDouble(cells.nextToken()), DataCheck.checkDouble(cells.nextToken())), new PointXD(DataCheck.checkDouble(cells.nextToken()), DataCheck.checkDouble(cells.nextToken())));
            ind.imagedBy = cells.nextToken();
            ind.date = DataCheck.checkDate(cells.nextToken());
            ind.time = DataCheck.checkTime(cells.nextToken());
            ind.strainID = cells.nextToken();
            ind.sex = DataCheck.checkSex(cells.nextToken());
            ind.pixelToMmScaling = DataCheck.checkDouble(cells.nextToken());
            String comment = "";
            String dump = "";
            double temp = 0.0;
            if (cells.hasMoreTokens()) {
                for (x = 0; x < GlobalVariables.dimensions; ++x) {
                    try {
                        dump = cells.nextToken();
                        temp = DataCheck.checkDouble(dump);
                        if (temp > 0.9 || temp < 1.1) {
                            ind.distortions[x] = temp;
                            continue;
                        }
                        comment = comment + temp + " ";
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        comment = comment + dump + " ";
                    }
                }
            } else {
                ind.distortions[0] = 1.0;
                ind.distortions[1] = 0.986;
                for (x = 2; x < GlobalVariables.dimensions; ++x) {
                    ind.distortions[x] = 1.0;
                }
            }
            while (cells.hasMoreTokens()) {
                comment = comment + cells.nextToken();
            }
            ind.setComment(comment);
            comment = "";
            currentLine = lines.nextToken();
        }
        if (!ind.isRejected()) {
            noSplines = Integer.parseInt(currentLine);
            SplineGroup splines = new SplineGroup(noSplines);
            int points = 0;
            double[][] values = null;
            double[] dis = ind.getDistortions();
            for (x = 0; x < noSplines; ++x) {
                points = DataCheck.checkInt(lines.nextToken());
                values = new double[points][ind.dim];
                for (int y = 0; y < points; ++y) {
                    cells = new StringTokenizer(lines.nextToken());
                    for (int z = 0; z < ind.dim; ++z) {
                        values[y][z] = DataCheck.checkDouble(cells.nextToken());
                    }
                }
                splines.setSpline(x, new Spline(values, dis));
            }
            if (increment) {
                ind.setSplineGroup(splines);
                ++ind.splineVersion;
            } else {
                ind.replaceSplineGroup(splines);
            }
        }
        return ind;
    }

    public static void save(File f, Individual ind) throws IOException {
        System.out.println("(CPFile.save) " + f);
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
        out.println("# CPversion: 2.0");
        out.println("# Image: " + ind.getImageFileName());
        out.println("# UserCoordinates: " + ind.getManualCoordinates(false, false));
        out.println("# ImagedBy: " + ind.imagedBy);
        out.println("# Date: " + ind.date);
        out.println("# Time: " + ind.time);
        out.println("# StrainID: " + ind.strainID);
        out.println("# Sex: " + Sex.names[ind.sex]);
        out.println("# ScaleFactor: " + ind.getPixelToMmScaling(false));
        out.println("# SplinedBy: " + GlobalVariables.spliner);
        out.println("# OpenRadius: " + ind.splineParameters.openRadius);
        out.println("# StructuralElementHeight: " + ind.splineParameters.structElementHeight);
        out.println("# Threshold: " + ind.splineParameters.threshold);
        out.println("# FillSize: " + ind.splineParameters.fillSize);
        out.println("# ShortCleanSegment: " + ind.splineParameters.shortCleanSegment);
        out.println("# LongCleanSegment: " + ind.splineParameters.longCleanSegment);
        out.flush();
        if (ind.isRejected()) {
            out.println("# Status: REJECTED");
        } else {
            SplineGroup sg = ind.getSplineGroup();
            int noSplines = sg.getNoSplines();
            out.println(noSplines);
            int no = -1;
            for (int x = 0; x < noSplines; ++x) {
                out.println(sg.getSpline(x).getDataString(" ", true, true));
                out.flush();
            }
        }
        out.close();
    }

    public static FileNameExtensionFilter getFilter() {
        return new FileNameExtensionFilter("CP files (*.cp)", "cp");
    }
}

