/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.fileTypes;

import commonSense.math.linear.PointXD;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import kim.bin.bio.wings.GlobalVariables;
import kim.bin.bio.wings.LogFrame;
import kim.bin.bio.wings.dataImport.DataCheck;
import kim.bin.bio.wings.individual.IndGroup;
import kim.bin.bio.wings.individual.Individual;
import kim.bin.bio.wings.individual.IndividualStatus;
import kim.io.file.ReadDataFile;

public class ASCFile
implements IndividualStatus {
    private ASCFile() {
    }

    public static IndGroup read(File f) throws FileNotFoundException, IOException {
        GlobalVariables.workDirectory = f.getParentFile();
        String data = ReadDataFile.getData(f);
        StringTokenizer lines = new StringTokenizer(data, "\n\r");
        int noLines = lines.countTokens();
        IndGroup individuals = new IndGroup(noLines, GlobalVariables.LMDefinition, 2, "" + f.getName());
        String comment = "";
        String dump = "";
        String line = "";
        double temp = 0.0;
        double yMax = 0.0;
        try {
            while (lines.hasMoreTokens()) {
                int x;
                line = lines.nextToken();
                StringTokenizer cells = new StringTokenizer(line, " \t");
                if (cells.countTokens() < 11) continue;
                Individual ind = new Individual(GlobalVariables.LMDefinition, GlobalVariables.dimensions);
                String name = cells.nextToken();
                if (!ind.setImageFile(name)) {
                    LogFrame.log("MISSING IMAGE FILE: " + name);
                    ind.setProcessingStatus(2);
                } else {
                    ind.setProcessingStatus(3);
                }
                ind.ID = name;
                double x1 = DataCheck.checkDouble(cells.nextToken());
                double y1 = DataCheck.checkDouble(cells.nextToken());
                double x2 = DataCheck.checkDouble(cells.nextToken());
                double y2 = DataCheck.checkDouble(cells.nextToken());
                yMax = y1 > yMax ? y1 : yMax;
                yMax = y2 > yMax ? y2 : yMax;
                ind.setUserMarkCoordinates(new PointXD(x1, y1), new PointXD(x2, y2));
                ind.imagedBy = cells.nextToken();
                ind.date = DataCheck.checkDate(cells.nextToken());
                ind.time = cells.nextToken();
                ind.strainID = cells.nextToken();
                ind.sex = DataCheck.checkSex(cells.nextToken());
                ind.setPixelToMmScaling(DataCheck.checkDouble(cells.nextToken()));
                if (cells.hasMoreTokens()) {
                    for (x = 0; x < GlobalVariables.dimensions; ++x) {
                        try {
                            dump = cells.nextToken();
                            temp = DataCheck.checkDouble(dump);
                            if (temp > 0.9 || temp < 1.1) {
                                ind.distortions[x] = temp;
                                continue;
                            }
                            comment = comment + temp + " ";
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            comment = comment + dump + " ";
                        }
                    }
                } else {
                    ind.distortions[0] = 1.0;
                    ind.distortions[1] = 0.986;
                    for (x = 2; x < GlobalVariables.dimensions; ++x) {
                        ind.distortions[x] = 1.0;
                    }
                }
                while (cells.hasMoreTokens()) {
                    comment = comment + cells.nextToken();
                }
                ind.setComment(comment);
                comment = "";
                individuals.put(ind.ID, ind);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new Frame(), "Error in ASC file at line: " + line + "\n" + e.getMessage());
            return null;
        }
        return individuals;
    }

    public static void save(IndGroup individuals, File file, boolean reScale, boolean included) throws FileNotFoundException, IOException {
        System.out.println("ASCFile: file to be saved " + file);
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        Iterator<Individual> i = individuals.values().iterator();
        while (i.hasNext()) {
            Individual ind;
            if (included) {
                do {
                    if ((ind = i.next()).getProcessingStatus() != 0) continue;
                    ind = null;
                } while (ind == null && i.hasNext());
            } else {
                ind = i.next();
            }
            if (ind != null) {
                out.print(ind.getImageFileName() + " ");
                out.print(ind.getManualCoordinates(reScale, false) + " ");
                out.print(ind.imagedBy + " ");
                out.print(ind.date + " ");
                out.print(ind.time + " ");
                out.print(ind.strainID + " ");
                out.print(ind.sex + " ");
                out.println(ind.getPixelToMmScaling(reScale) + " ");
            }
            out.flush();
        }
        out.close();
    }

    public static FileNameExtensionFilter getFilter() {
        return new FileNameExtensionFilter("ASC files (*.asc, *.ascii)", "asc", "ascii");
    }
}

