/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.debug;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import kim.bin.bio.wings.images.DisplayImage;
import kim.bin.bio.wings.individual.Individual;
import kim.bin.bio.wings.splining.EnergyField;
import kim.bin.bio.wings.splining.ImageProcessing;
import kim.image.advanced.convolutionkernels.KernelSizeException;
import kim.util.JGridBag;

public class DebugImageProcessing
extends ImageProcessing {
    private DisplayImage originalDisplay = new DisplayImage();
    private DisplayImage invertedDisplay = new DisplayImage();
    private DisplayImage smoothedDisplay = new DisplayImage();
    private DisplayImage openedDisplay = new DisplayImage();
    private DisplayImage thresholdDisplay = new DisplayImage();
    private DisplayImage filledDisplay = new DisplayImage();
    private DisplayImage skeletonDisplay = new DisplayImage();
    private DisplayImage removeShortSegmentDisplay = new DisplayImage();
    private DisplayImage removeLongSegmentDisplay = new DisplayImage();
    private DisplayImage jointsDisplay = new DisplayImage();
    private DisplayImage bestFeatureDisplay = new DisplayImage();
    private DisplayImage overlayDisplay = new DisplayImage();
    private DisplayImage registeredDisplay = new DisplayImage();
    private DisplayImage energyDisplay = new DisplayImage();
    private DisplayImage finalDisplay = new DisplayImage();
    private GridBagLayout gb = new GridBagLayout();
    private Font text = new Font("SansSerif", 1, 16);
    private JPanel images = new JPanel(this.gb);
    private Individual ind = null;

    public DebugImageProcessing() {
        this.originalDisplay.setText("Original");
        this.invertedDisplay.setText("Inverted");
        this.smoothedDisplay.setText("Median filter applied");
        this.openedDisplay.setText("Opened");
        this.thresholdDisplay.setText("Threshold applied");
        this.filledDisplay.setText("Filled holes");
        this.skeletonDisplay.setText("Skeletonized");
        this.removeShortSegmentDisplay.setText("Removed small fragments");
        this.removeLongSegmentDisplay.setText("Removed larger fragments");
        this.jointsDisplay.setText("Joint locations");
        this.overlayDisplay.setText("Raw model + targets");
        this.bestFeatureDisplay.setText("Best feature locations");
        this.registeredDisplay.setText("Registred model");
        this.energyDisplay.setText("Energy field");
        this.finalDisplay.setText("Fitted model");
        JGridBag.add(this.images, (Component)this.originalDisplay, 0, 0, 1, 1);
        JGridBag.add(this.images, (Component)this.invertedDisplay, 1, 0, 1, 1);
        JGridBag.add(this.images, (Component)this.smoothedDisplay, 2, 0, 1, 1);
        JGridBag.add(this.images, (Component)this.openedDisplay, 3, 0, 1, 1);
        JGridBag.add(this.images, (Component)this.thresholdDisplay, 0, 1, 1, 1);
        JGridBag.add(this.images, (Component)this.filledDisplay, 1, 1, 1, 1);
        JGridBag.add(this.images, (Component)this.skeletonDisplay, 2, 1, 1, 1);
        JGridBag.add(this.images, (Component)this.removeShortSegmentDisplay, 3, 1, 1, 1);
        JGridBag.add(this.images, (Component)this.removeLongSegmentDisplay, 0, 2, 1, 1);
        JGridBag.add(this.images, (Component)this.jointsDisplay, 1, 2, 1, 1);
        JGridBag.add(this.images, (Component)this.overlayDisplay, 2, 2, 1, 1);
        JGridBag.add(this.images, (Component)this.bestFeatureDisplay, 3, 2, 1, 1);
        JGridBag.add(this.images, (Component)this.registeredDisplay, 0, 3, 1, 1);
        JGridBag.add(this.images, (Component)this.energyDisplay, 1, 3, 1, 1);
        JGridBag.add(this.images, (Component)this.finalDisplay, 2, 3, 1, 1);
    }

    public void update(String propertyName, int newValue) {
        System.out.println("update with: " + propertyName);
        if (this.ind != null) {
            if ("openRadius".equals(propertyName)) {
                this.ind.splineParameters.openRadius = newValue;
                this.makeDisplays(1);
            } else if ("structElementHeight".equals(propertyName)) {
                this.ind.splineParameters.structElementHeight = newValue;
                this.makeDisplays(1);
            } else if ("threshold".equals(propertyName)) {
                this.ind.splineParameters.threshold = newValue;
                this.makeDisplays(2);
            } else if ("fillSize".equals(propertyName)) {
                this.ind.splineParameters.fillSize = newValue;
                this.makeDisplays(3);
            } else if ("shortCleanSegment".equals(propertyName)) {
                this.ind.splineParameters.shortCleanSegment = newValue;
                this.makeDisplays(5);
            } else if ("longCleanSegment".equals(propertyName)) {
                this.ind.splineParameters.longCleanSegment = newValue;
                this.makeDisplays(6);
            }
        }
    }

    public void setIndividual(Individual individual) {
        this.ind = individual;
        this.rawData = individual.getRawImageData();
        this.makeDisplays(0);
        this.originalDisplay.setImageData(this.rawData);
    }

    public JPanel getPanel() {
        return this.images;
    }

    private void makeDisplays(int start) {
        System.out.println("Make displays invoked with value: " + start);
        this.process(start, this.ind);
        switch (start) {
            case 0: {
                this.invertedDisplay.setImageData(this.invertedData);
                this.invertedDisplay.repaint();
                this.smoothedDisplay.setImageData(this.smoothedData);
                this.smoothedDisplay.repaint();
            }
            case 1: {
                this.openedDisplay.setImageData(this.openedData);
                this.openedDisplay.repaint();
            }
            case 2: {
                this.thresholdDisplay.setImageData(this.thresholdData);
                this.openedDisplay.repaint();
            }
            case 3: {
                this.filledDisplay.setImageData(this.filledData);
                this.thresholdDisplay.repaint();
            }
            case 4: {
                this.skeletonDisplay.setImageData(this.skeletonData);
                this.skeletonDisplay.repaint();
            }
            case 5: {
                this.removeShortSegmentDisplay.setImageData(this.removeShortSegmentData);
                this.removeShortSegmentDisplay.repaint();
            }
            case 6: {
                this.removeLongSegmentDisplay.setImageData(this.removeLongSegmentData);
                this.removeLongSegmentDisplay.repaint();
            }
            case 7: {
                this.jointsDisplay.setImageData(this.removeLongSegmentData);
                this.jointsDisplay.setJoints(this.rsm.getJoints());
                this.jointsDisplay.repaint();
                this.overlayDisplay.setImageData(this.removeLongSegmentData);
                this.overlayDisplay.setSplineGroup(this.rsm.getRawSplineGroup(), false);
                this.overlayDisplay.setUserMarks(this.ind.getUserMarkCoordinateValues(false, false));
                this.overlayDisplay.setFeatures(this.rsm.getFeaturePoints());
                this.overlayDisplay.repaint();
                this.bestFeatureDisplay.setImageData(this.removeLongSegmentData);
                this.bestFeatureDisplay.setUserMarks(this.ind.getUserMarkCoordinateValues(false, false));
                this.bestFeatureDisplay.setFeatures(this.rsm.getBestFeaturePoints());
                this.bestFeatureDisplay.repaint();
                this.registeredDisplay.setImageData(this.removeLongSegmentData);
                this.registeredDisplay.setSplineGroup(this.rsm.getRegisteredSplineGroup(), false);
                this.registeredDisplay.setUserMarks(this.ind.getUserMarkCoordinateValues(false, false));
                this.registeredDisplay.repaint();
                try {
                    this.energyDisplay.setImageData(new EnergyField(this.openedData).getEnergyDataInt());
                }
                catch (KernelSizeException ex) {
                    this.ind.setProcessingStatus(7);
                }
                this.energyDisplay.repaint();
                this.finalDisplay.setImageData(this.rawData);
                this.finalDisplay.setSplineGroup(this.fs.getFitSplineGroup(), false);
                this.finalDisplay.setUserMarks(this.ind.getUserMarkCoordinateValues(false, false));
                this.finalDisplay.repaint();
            }
        }
    }
}

