/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.dataImport;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import kim.bin.bio.wings.dataImport.DataException;
import kim.bio.Sex;

public class DataCheck
implements Sex {
    private int type;
    public static final int INT = 0;
    public static final int DOUBLE = 1;
    public static final int SEX = 2;
    public static final int DATE = 3;
    public static final int TIME = 4;
    public static final int STRING = 100;

    public DataCheck(int type) {
        this.type = type;
    }

    public Object check(String value) {
        try {
            switch (this.type) {
                case 0: {
                    return DataCheck.checkInt(value);
                }
                case 1: {
                    return DataCheck.checkDouble(value);
                }
                case 2: {
                    return DataCheck.checkSex(value);
                }
                case 3: {
                    return DataCheck.checkDate(value);
                }
                case 4: {
                    return DataCheck.checkTime(value);
                }
            }
            return value.getClass().isInstance(String.class);
        }
        catch (DataException ex) {
            return null;
        }
    }

    public static int checkInt(String value) throws DataException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new DataException("String value '" + value + "' is not a integer");
        }
    }

    public static double checkDouble(String value) throws DataException {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new DataException("String value '" + value + "' is not a double");
        }
    }

    public static int checkSex(String value) throws DataException {
        if ((value = value.trim()).equalsIgnoreCase("F")) {
            return 2;
        }
        if (value.equalsIgnoreCase("Female")) {
            return 2;
        }
        if (value.equalsIgnoreCase("M")) {
            return 1;
        }
        if (value.equalsIgnoreCase("Male")) {
            return 1;
        }
        if (value.equalsIgnoreCase("PM")) {
            return 3;
        }
        if (value.equalsIgnoreCase("PseudoMale")) {
            return 3;
        }
        if (value.equalsIgnoreCase("PF")) {
            return 4;
        }
        if (value.equalsIgnoreCase("PseudoFemale")) {
            return 4;
        }
        if (value.equalsIgnoreCase("IS")) {
            return 5;
        }
        if (value.equalsIgnoreCase("Intersex")) {
            return 5;
        }
        throw new DataException("String value '" + value + "' is not a sex indicator");
    }

    public static String checkDate(String value) throws DataException {
        int day = -1;
        int month = -1;
        int year = -1;
        try {
            DateFormat date = DateFormat.getDateInstance();
            date.parse(value);
            return value;
        }
        catch (ParseException ex) {
            String testValue;
            StringTokenizer cells = new StringTokenizer(value, "-\\/_. ");
            if (cells.countTokens() == 1) {
                try {
                    day = Integer.parseInt(value.substring(0, 1));
                    month = Integer.parseInt(value.substring(2, 3));
                    year = Integer.parseInt(value.substring(4));
                    return value;
                }
                catch (Exception e) {
                    throw new DataException("Input value '" + value + "' is an invalid date format");
                }
            }
            try {
                day = Integer.parseInt(cells.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataException("Input value '" + value + "' is an invalid date format");
            }
            try {
                testValue = cells.nextToken();
            }
            catch (NoSuchElementException e) {
                throw new DataException("Input value '" + value + "' is an invalid date format");
            }
            try {
                month = Integer.parseInt(testValue);
            }
            catch (NumberFormatException nfe) {
                testValue = testValue.toLowerCase();
                if (testValue.startsWith("jan")) {
                    month = 1;
                } else if (testValue.startsWith("feb")) {
                    month = 2;
                } else if (testValue.startsWith("mar")) {
                    month = 3;
                } else if (testValue.startsWith("apr")) {
                    month = 4;
                } else if (testValue.startsWith("may")) {
                    month = 5;
                } else if (testValue.startsWith("jun")) {
                    month = 6;
                } else if (testValue.startsWith("jul")) {
                    month = 7;
                } else if (testValue.startsWith("aug")) {
                    month = 8;
                } else if (testValue.startsWith("sep")) {
                    month = 9;
                } else if (testValue.startsWith("oct")) {
                    month = 10;
                } else if (testValue.startsWith("nov")) {
                    month = 11;
                } else if (testValue.startsWith("dec")) {
                    month = 12;
                }
                throw new DataException("Input value '" + value + "' is an invalid date format");
            }
            try {
                year = Integer.parseInt(cells.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataException("Input value '" + value + "' is an invalid date format");
            }
            catch (NoSuchElementException e) {
                throw new DataException("Input value '" + value + "' is an invalid date format");
            }
            Calendar c = Calendar.getInstance();
            c.setLenient(false);
            try {
                c.set(year, month, day);
                return value;
            }
            catch (Exception e) {
                throw new DataException("Input value '" + value + "' is an invalid date format");
            }
        }
    }

    public static String checkTime(String value) throws DataException {
        return value;
    }
}

