/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.NumberFormatter;
import kim.awt.button.JFileChooserButton;
import kim.bin.bio.wings.GlobalVariables;
import kim.bin.bio.wings.LogFrame;
import kim.bin.bio.wings.MasterControlFrame;
import kim.bin.bio.wings.Preferences;
import kim.bin.bio.wings.ProcessStatus;
import kim.bin.bio.wings.WingsStatus;
import kim.bin.bio.wings.dataImport.ImportSplineDir;
import kim.bin.bio.wings.debug.DebugFrame;
import kim.bin.bio.wings.fileTypes.CPFilter;
import kim.bin.bio.wings.fileTypes.LandMarkDefinitionFile;
import kim.bin.bio.wings.fileTypes.OverlayFilter;
import kim.bin.bio.wings.fileTypes.WingsTiffFilter;
import kim.bin.bio.wings.images.EditFrame;
import kim.bin.bio.wings.images.ImageLoader;
import kim.bin.bio.wings.images.TiffViewerFrame;
import kim.bin.bio.wings.individual.IndGroup;
import kim.bin.bio.wings.individual.Individual;
import kim.bin.bio.wings.individual.IndividualFrame;
import kim.bin.bio.wings.individual.IndividualStatus;
import kim.bin.bio.wings.outliers.Outliers;
import kim.bin.bio.wings.spline.SplinePropertiesFrame;
import kim.bin.bio.wings.splining.ImageProcessing;
import kim.bin.bio.wings.splining.SpliningParameterFrame;
import kim.bin.bio.wings.util.AboutWings;
import kim.bin.bio.wings.util.HTMLFrame;
import kim.bin.bio.wings.util.Mail;
import kim.image.advanced.convolutionkernels.KernelSizeException;
import kim.util.JAbout;
import kim.util.JGridBag;

public class Wings
extends JFrame
implements IndividualStatus,
WingsStatus,
ProcessStatus {
    private static String version = "4.00 Beta 2.8";
    private JDesktopPane desktop = new JDesktopPane();
    private MasterControlFrame masterControlFrame = new MasterControlFrame();
    private LogFrame logFrame = new LogFrame();
    private static SpliningParameterFrame spliningParameterFrame = null;
    private TiffViewerFrame tiffViewerFrame = null;
    private DebugFrame debugFrame = new DebugFrame();
    private SplinePropertiesFrame splinePropertiesFrame = null;
    private IndividualFrame individualFrame = null;
    private EditFrame editFrame = null;
    private static final long serialVersionUID = 1L;
    private AboutWings aboutWings = new AboutWings();
    private JAbout about = new JAbout(this, "About Wings", true, this.aboutWings);
    private GridBagLayout gb = new GridBagLayout();
    private JPanel dirsPanel = new JPanel(this.gb);
    private JPanel processingPanel = new JPanel(this.gb);
    private JLabel workDirL = new JLabel("Current working directory:");
    private JLabel ascFileL = new JLabel("ASC file:");
    private JLabel splineFractionL = new JLabel("Fraction to be splined:");
    private JLabel progressBarL = new JLabel("Spline progress:");
    private JLabel workDirLocation = new JLabel("");
    public static JLabel ascFileName = new JLabel("");
    JFileChooserButton workDirSelector = new JFileChooserButton("Select working directory", "WorkDir", GlobalVariables.workDirectory, null, 1, false);
    private JFormattedTextField rescaling;
    private JFormattedTextField YCorrection;
    private JFormattedTextField XCorrection;
    private String[] fractions = new String[]{"0.05", "0.1", "0.2", "0.3", "0.4", "0.5", "0.75"};
    private JComboBox splineFraction = new JComboBox<String>(this.fractions);
    private String[] toBeSplinesOptions = new String[]{"All", "Unsplined", "Selected", "Outliers", "Fraction"};
    private JComboBox toBeSplined = new JComboBox<String>(this.toBeSplinesOptions);
    private JButton spline = new JButton("Spline");
    private JButton cancelSplining = new JButton("Cancel");
    private ImageProcessing ip = null;
    private JPanel splinePanel = new JPanel(this.gb);
    private JButton editWings = new JButton("Determine outliers");
    public static JProgressBar progressBar = new JProgressBar();
    public int validIndividuals = -1;
    private int iteration = 0;
    public Outliers outliers = null;
    public boolean finishedSplining = false;
    private int processStatus = 0;
    public String[] debugRequestNames = new String[]{"None", "Individual Frame", "Tiff Viewer Frame", "Edit Frame"};
    public static int debugRequest = 0;
    private boolean startEnabled = false;
    private boolean editWingsEnabled = false;
    private boolean ascFileEnabled = false;
    private boolean logFileEnabled = false;
    private boolean ntsFileEnabled = false;
    private Individual currentIndividual = null;
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu("File");
    private JMenuItem exitMI = new JMenuItem("Exit", 81);
    private JMenuItem preferencesMI = new JMenuItem("Preferences");
    private JMenu individualMenu = new JMenu("Individuals");
    private JMenu splineMenu = new JMenu("Splines");
    private JMenuItem masterSplineMI = new JMenuItem("Generate Master Spline Model");
    private JMenu windowsMenu = new JMenu("Windows");
    private JMenuItem logMI = new JMenuItem("Logging");
    private JMenuItem tiffViewerMI = new JMenuItem("Tiff Viewer");
    private JMenuItem splineParametersMI = new JMenuItem("Spline parameters");
    private JMenu helpMenu = new JMenu("Help");
    private JMenuItem helpMI = new JMenuItem("Help: webpage");
    private JMenuItem emailMI = new JMenuItem("E-mail");
    private JMenuItem aboutMI = new JMenuItem("About");

    public Wings(String title) throws FileNotFoundException, IOException {
        super(title);
        spliningParameterFrame = new SpliningParameterFrame();
        this.setDefaultCloseOperation(0);
        GlobalVariables.props = System.getProperties();
        try {
            System.out.println(System.getProperty("user.dir"));
            GlobalVariables.workDirectory = new File(System.getProperty("user.dir"));
            GlobalVariables.props.load(new BufferedInputStream(new FileInputStream(new File(System.getProperty("user.dir"), "wings.properties"))));
            this.propertiesCheck();
        }
        catch (FileNotFoundException fnfe) {
            new Preferences(this);
        }
        catch (IOException ioe) {
            new Preferences(this);
        }
        System.setProperties(GlobalVariables.props);
        GlobalVariables.LMDefinition = LandMarkDefinitionFile.load(new File(GlobalVariables.props.getProperty("landmark.definition")));
        if (GlobalVariables.props.getProperty("working.dir") != null) {
            this.setDir(new File(GlobalVariables.props.getProperty("working.dir")));
        }
        ascFileName.setText("*.asc");
        this.setJMenuBar(this.makeMenuBar());
        this.setVisible(true);
        LogFrame.log("Starting Wings!");
        NumberFormat doubleNumberFormat = NumberFormat.getNumberInstance();
        doubleNumberFormat.setGroupingUsed(false);
        NumberFormatter doubleFormatter = new NumberFormatter(doubleNumberFormat);
        doubleFormatter.setMinimum(new Double(-100.0));
        doubleFormatter.setMaximum(new Double(100.0));
        this.rescaling = new JFormattedTextField(doubleNumberFormat);
        this.rescaling.setValue(new Double(2.0));
        this.rescaling.setColumns(5);
        this.YCorrection = new JFormattedTextField(doubleNumberFormat);
        this.YCorrection.setValue(new Double(0.986));
        this.YCorrection.setColumns(5);
        this.XCorrection = new JFormattedTextField(doubleNumberFormat);
        this.XCorrection.setValue(new Double(1.0));
        this.XCorrection.setColumns(5);
        this.setButtonsAccess(1);
        progressBar.setBorder(BorderFactory.createLineBorder(Color.darkGray, 1));
        progressBar.setBorderPainted(true);
        progressBar.setStringPainted(true);
        Font largeFont = new Font(this.getFont().getFontName(), 1, 16);
        this.workDirLocation.setText(GlobalVariables.workDirectory.toString());
        this.workDirL.setLabelFor(this.workDirLocation);
        this.ascFileL.setLabelFor(ascFileName);
        this.splineFractionL.setLabelFor(this.splineFraction);
        this.progressBarL.setLabelFor(progressBar);
        JGridBag.add(this.dirsPanel, (Component)this.workDirSelector, 0, 0, 1, 1);
        JGridBag.add(this.dirsPanel, (Component)this.workDirL, 0, 1, 1, 1, 10, 0, 0, 0);
        JGridBag.add(this.dirsPanel, (Component)this.workDirLocation, 1, 1, 1, 1, 10, 10, 0, 0);
        JGridBag.add(this.dirsPanel, (Component)this.ascFileL, 0, 2, 1, 1, 10, 0, 0, 0);
        JGridBag.add(this.dirsPanel, (Component)ascFileName, 1, 2, 3, 1, 10, 10, 0, 0);
        JGridBag.add(this.splinePanel, (Component)this.spline, 0, 0, 1, 1, 10, 0, 0, 0);
        JGridBag.add(this.splinePanel, (Component)this.toBeSplined, 1, 0, 1, 1, 10, 10, 0, 0);
        JGridBag.add(this.splinePanel, (Component)this.splineFraction, 2, 0, 1, 1, 10, 10, 0, 0);
        JGridBag.add(this.processingPanel, (Component)this.progressBarL, 0, 0, 1, 1, 10, 0, 0, 0);
        JGridBag.add(this.processingPanel, (Component)progressBar, 1, 0, 1, 1, 10, 10, 0, 0);
        JGridBag.add(this.processingPanel, (Component)this.cancelSplining, 2, 0, 1, 1, 10, 10, 0, 0);
        JGridBag.add(this.processingPanel, (Component)this.editWings, 0, 3, 2, 1, 10, 0, 0, 0);
        JGridBag.add(this.masterControlFrame, (Component)this.dirsPanel, 0, 0, 1, 1, 15, 15, 0, 15);
        JGridBag.add(this.masterControlFrame, (Component)this.splinePanel, 0, 1, 1, 1, 0, 15, 0, 15);
        JGridBag.add(this.masterControlFrame, (Component)this.processingPanel, 0, 2, 1, 1, 0, 15, 15, 15);
        System.out.println("dirsPanel.getWidth()" + this.dirsPanel.getWidth());
        System.out.println("rightPanel.getWidth()" + this.processingPanel.getWidth());
        this.cancelSplining.setVisible(false);
        this.splineFraction.setVisible(false);
        this.masterControlFrame.pack();
        this.masterControlFrame.setVisible(true);
        this.desktop.add(this.masterControlFrame);
        this.desktop.add(this.logFrame);
        this.desktop.add(spliningParameterFrame);
        this.desktop.add(this.debugFrame);
        this.setContentPane(this.desktop);
        System.out.println("" + this.getPreferredSize());
        this.validate();
        this.pack();
        this.workDirSelector.requestFocus();
        GlobalVariables.spliner = JOptionPane.showInputDialog("Please enter your name");
        if (GlobalVariables.spliner == null || GlobalVariables.spliner.equals("")) {
            System.exit(1);
        }
        this.spline.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (Wings.this.spline.isEnabled()) {
                    try {
                        if (GlobalVariables.wingsStatus >= 8) {
                            if (0 == JOptionPane.showConfirmDialog(Wings.this, "This operation will remove all edited data! Do you want to continue?", "Warning!!!!", 0, 2)) {
                                Wings.this.individualFrame.updateAllIndividuals(Wings.this.splineAll());
                            }
                        } else {
                            Wings.this.individualFrame.updateAllIndividuals(Wings.this.splineAll());
                        }
                    }
                    catch (KernelSizeException ex) {
                        Logger.getLogger(Wings.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        this.cancelSplining.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                GlobalVariables.processing = false;
                Wings.this.ip.cancel(true);
            }
        });
        this.toBeSplined.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                if (((String)cb.getSelectedItem()).equalsIgnoreCase("Fraction")) {
                    Wings.this.splineFraction.setVisible(true);
                    Wings.this.masterControlFrame.pack();
                } else {
                    Wings.this.splineFraction.setVisible(false);
                    Wings.this.masterControlFrame.pack();
                }
            }
        });
        this.editWings.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (Wings.this.tiffViewerFrame != null) {
                    Wings.this.tiffViewerFrame.setVisible(false);
                    Wings.this.validate();
                    Wings.this.tiffViewerFrame = null;
                }
                if (GlobalVariables.wingsStatus >= 5) {
                    Wings.this.iteration++;
                    Individual[] outliersArray = Outliers.findOutliers(GlobalVariables.individuals, Wings.this.iteration, false);
                    GlobalVariables.wingsStatus = 7;
                    if (outliersArray != null) {
                        Wings.this.setButtonsAccess(1);
                        LogFrame.log("EditWings: Number of outliers: " + outliersArray.length);
                        Wings.this.showEdit(Wings.this.goodIndividualArray(), outliersArray);
                        GlobalVariables.wingsStatus = 8;
                    } else {
                        JOptionPane.showMessageDialog(Wings.this, "Nothing to do automatic, please use manual outlier edit dialog");
                        Wings.this.setButtonsAccess(GlobalVariables.wingsStatus);
                    }
                    Wings.this.individualFrame.updateAllIndividuals(GlobalVariables.individuals);
                }
            }
        });
        this.workDirSelector.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Wings.this.newWorkDirectorySelected();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Wings.this.exit();
            }
        });
        spliningParameterFrame.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                System.out.println("Processing event from splining Parameters window: " + evt.getPropertyName());
                if (evt.getPropertyName().equals("cp0Changed")) {
                    Wings.this.splinePropertiesFrame.setVisible(false);
                    Wings.this.splinePropertiesFrame.dispose();
                    Wings.this.splinePropertiesFrame = new SplinePropertiesFrame(GlobalVariables.masterSplineGroup);
                    Wings.this.desktop.add(Wings.this.splinePropertiesFrame);
                } else if (evt.getPropertyName().equals("IndividualSet")) {
                    Wings.this.currentIndividual = (Individual)evt.getNewValue();
                } else {
                    System.out.println("" + evt.getPropertyName() + " was changed to " + evt.getNewValue());
                    if (evt.getNewValue() instanceof Integer) {
                        if (Wings.this.debugFrame.isVisible()) {
                            Wings.this.debugFrame.update(evt.getPropertyName(), (Integer)evt.getNewValue());
                        } else if (Wings.this.tiffViewerFrame != null) {
                            Wings.this.tiffViewerFrame.update(evt.getPropertyName(), (Integer)evt.getNewValue());
                        } else if (Wings.this.editFrame != null) {
                            Wings.this.editFrame.update(evt.getPropertyName(), (Integer)evt.getNewValue());
                        }
                    }
                }
            }
        });
        this.debugFrame.addPropertyChangeListener("DebugFrameClosed", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Wings.this.processIndividualChangeEvent(evt);
                System.out.println("Debug request was made by: " + Wings.this.debugRequestNames[debugRequest]);
                if (debugRequest == 2) {
                    System.out.println("Update escalated to Tiff Viewer Frame");
                    Wings.this.tiffViewerFrame.update();
                } else if (debugRequest == 3) {
                    System.out.println("Update escalated to Edit Frame");
                    Wings.this.editFrame.update();
                }
            }
        });
    }

    private IndGroup splineAll() throws KernelSizeException {
        try {
            if (this.spline.isEnabled()) {
                this.setButtonsAccess(1);
                System.out.println("Wings(start): " + GlobalVariables.cpMasterFile);
                String warningText = "Please select first ";
                boolean goahead = true;
                if (GlobalVariables.workDirectory == null) {
                    goahead = false;
                    warningText = warningText + "a working directory; ";
                }
                if (Wings.spliningParameterFrame.cp0List.getSelectedIndex() < 1) {
                    goahead = false;
                    warningText = warningText + "a *.cp# file; ";
                }
                if (goahead) {
                    this.clearIndividuals();
                    LogFrame.log("Start: ASC file: " + ascFileName.getText());
                    if (((String)this.toBeSplined.getSelectedItem()).equalsIgnoreCase("All")) {
                        LogFrame.log("Splining all images, overriding all.");
                        GlobalVariables.wingsStatus = 5;
                        this.procesIndividuals(GlobalVariables.individuals, true);
                    } else if (((String)this.toBeSplined.getSelectedItem()).equalsIgnoreCase("Outliers")) {
                        LogFrame.log("Splining all outliers, overriding the outliers.");
                        IndGroup outliersTemp = GlobalVariables.individuals.getOutliers();
                        if (outliersTemp.size() > 0) {
                            this.procesIndividuals(outliersTemp, true);
                        } else {
                            this.setButtonsAccess(GlobalVariables.wingsStatus);
                        }
                    } else if (((String)this.toBeSplined.getSelectedItem()).equalsIgnoreCase("Selected")) {
                        LogFrame.log("Splining selected images, overriding those selected.");
                        this.procesIndividuals(this.individualFrame.getSelectedIndividuals(), true);
                    } else if (((String)this.toBeSplined.getSelectedItem()).equalsIgnoreCase("Unsplined")) {
                        LogFrame.log("Splining all unsplined images, no overriding.");
                        GlobalVariables.wingsStatus = 5;
                        this.procesIndividuals(GlobalVariables.individuals, false);
                    } else if (((String)this.toBeSplined.getSelectedItem()).equalsIgnoreCase("Fraction")) {
                        LogFrame.log("Spline a random fraction of the images.");
                        GlobalVariables.wingsStatus = 4;
                        this.procesIndividuals(GlobalVariables.individuals.getFraction(Double.parseDouble((String)this.splineFraction.getSelectedItem())), true);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, warningText + " !");
                    this.setButtonsAccess(2);
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            LogFrame.log("Start: " + fnfe);
            Logger.getLogger(Wings.class.getName()).log(Level.SEVERE, null, fnfe);
        }
        catch (IOException ioe) {
            LogFrame.log("Start: " + ioe);
            Logger.getLogger(Wings.class.getName()).log(Level.SEVERE, null, ioe);
        }
        return GlobalVariables.individuals;
    }

    public void procesIndividuals(final IndGroup individuals, boolean override) throws KernelSizeException, IOException {
        progressBar.setMinimum(-1);
        progressBar.setMaximum(individuals.size() - 1);
        this.setButtonsAccess(0);
        this.storeSpliningParameters();
        this.ip = new ImageProcessing(individuals, override);
        this.cancelSplining.setVisible(true);
        this.masterControlFrame.pack();
        GlobalVariables.processing = true;
        this.ip.execute();
        this.ip.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("Updated".equalsIgnoreCase(evt.getPropertyName())) {
                    try {
                        progressBar.setValue((Integer)evt.getOldValue());
                        Wings.this.individualFrame.updateIndividual((Individual)evt.getNewValue());
                        if (Wings.this.tiffViewerFrame == null) {
                            Wings.this.showTiffViewer(individuals);
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Wings.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else if (SwingWorker.StateValue.DONE.equals((Object)((SwingWorker.StateValue)((Object)evt.getNewValue())))) {
                    if (individuals.size() > 0) {
                        Wings.this.tiffViewerFrame.setClosable(true);
                    }
                    Wings.this.setButtonsAccess(GlobalVariables.wingsStatus);
                    Wings.this.cancelSplining.setVisible(false);
                    GlobalVariables.processing = false;
                }
            }
        });
    }

    private void setButtonsAccess(int wingsStatus) {
        this.spline.setEnabled(false);
        this.editWings.setEnabled(false);
        System.out.println("Current wing status: " + wingStatusNames[wingsStatus]);
        switch (wingsStatus) {
            case 5: 
            case 8: {
                this.editWings.setEnabled(true);
            }
            case 2: 
            case 4: {
                this.spline.setEnabled(true);
            }
            case 1: {
                this.workDirSelector.setEnabled(true);
            }
        }
    }

    private void showTiffViewer(IndGroup showIndividuals) throws IOException {
        this.tiffViewerFrame = null;
        this.tiffViewerFrame = new TiffViewerFrame(showIndividuals);
        GlobalVariables.tiffViewerLock = true;
        GlobalVariables.editLock = true;
        GlobalVariables.debugLock = true;
        this.tiffViewerFrame.setClosable(false);
        this.tiffViewerFrame.setDefaultCloseOperation(2);
        this.tiffViewerFrame.addPropertyChangeListener("SplineIndividual", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                debugRequest = 2;
                GlobalVariables.debugLock = false;
                Wings.this.showDebug(evt);
                GlobalVariables.debugLock = true;
            }
        });
        this.tiffViewerFrame.addPropertyChangeListener("Changed individuals", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Wings.this.processIndividualChangeEvent(evt);
            }
        });
        this.tiffViewerFrame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
                Wings.this.tiffViewerFrame = null;
            }
        });
        this.desktop.add(this.tiffViewerFrame);
        this.tiffViewerFrame.setLocation(550, 0);
        this.tiffViewerFrame.toFront();
        spliningParameterFrame.setIndividual(this.tiffViewerFrame.getCurrentIndividual());
    }

    private void showEdit(Individual ind) {
        Individual[] singleInd = new Individual[]{ind};
        this.prepareIndividual(ind);
        this.showEdit(null, singleInd);
    }

    private void showEdit(Individual[] goodArray, Individual[] outliersArray) {
        this.editFrame = new EditFrame(goodArray, outliersArray);
        GlobalVariables.editLock = true;
        GlobalVariables.tiffViewerLock = true;
        GlobalVariables.debugLock = true;
        this.editFrame.addPropertyChangeListener("SplineIndividual", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                debugRequest = 3;
                GlobalVariables.debugLock = false;
                Wings.this.showDebug(evt);
                GlobalVariables.debugLock = true;
            }
        });
        this.editFrame.addPropertyChangeListener("Finished Editing", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Wings.this.processIndividualChangeEvent(evt);
                Wings.this.setButtonsAccess(8);
            }
        });
        this.editFrame.addPropertyChangeListener("Changed individuals", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Wings.this.processIndividualChangeEvent(evt);
            }
        });
        this.desktop.add(this.editFrame);
        this.editFrame.setVisible(true);
    }

    private void processIndividualChangeEvent(PropertyChangeEvent evt) {
        if (evt.getOldValue() != null) {
            this.individualFrame.updateIndividual((Individual)evt.getOldValue());
        }
        if (evt.getNewValue() != null) {
            this.prepareIndividual((Individual)evt.getNewValue());
        }
    }

    public void setDir(File dir) {
        GlobalVariables.workDirectory = dir;
        this.workDirLocation.setText(dir.toString());
        this.workDirSelector.setRootDir(dir);
        Wings.spliningParameterFrame.cp0FileSelector.setRootDir(dir);
    }

    public void newWorkDirectorySelected() {
        File selected = this.workDirSelector.getSelectedFile();
        System.out.println("Changes working directory to: " + selected);
        if (selected != null) {
            this.setDir(selected);
            this.loadDirectory();
        }
        GlobalVariables.workDirectoryLoaded = true;
        spliningParameterFrame.loadMasterSpline();
        if (this.splinePropertiesFrame == null) {
            this.splinePropertiesFrame = new SplinePropertiesFrame(GlobalVariables.masterSplineGroup);
            this.desktop.add(this.splinePropertiesFrame);
        } else {
            this.splinePropertiesFrame.setSplineGroup(GlobalVariables.masterSplineGroup);
        }
        this.splinePropertiesFrame.pack();
    }

    private void loadDirectory() {
        this.clear();
        this.processStatus(ImportSplineDir.doIt(GlobalVariables.workDirectory));
        this.masterControlFrame.pack();
        if (GlobalVariables.individuals != null) {
            GlobalVariables.individualLock = false;
            this.individualFrame = new IndividualFrame(GlobalVariables.individuals);
            GlobalVariables.individualLock = true;
            GlobalVariables.debugLock = true;
            GlobalVariables.tiffViewerLock = true;
            GlobalVariables.editLock = true;
            this.processStatus = 1;
            this.individualFrame.addPropertyChangeListener("DebugIndividual", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    debugRequest = 1;
                    GlobalVariables.debugLock = false;
                    Wings.this.showDebug(evt);
                    GlobalVariables.debugLock = true;
                }
            });
            this.individualFrame.addPropertyChangeListener("EditIndividual", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    GlobalVariables.editLock = false;
                    Wings.this.showEdit((Individual)evt.getNewValue());
                    GlobalVariables.editLock = true;
                }
            });
            this.desktop.add(this.individualFrame);
            ImageLoader imageLoader = new ImageLoader(GlobalVariables.individuals);
            imageLoader.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("Image loaded".equalsIgnoreCase(evt.getPropertyName())) {
                        Wings.this.individualFrame.updateIndividual((Individual)evt.getNewValue());
                    }
                }
            });
        }
    }

    private void showDebug(PropertyChangeEvent evt) {
        if (!this.debugFrame.isVisible()) {
            Individual ind = (Individual)evt.getNewValue();
            this.prepareIndividual(ind);
            this.debugFrame.setIndividual(ind);
            this.debugFrame.setVisible(true);
        }
    }

    private void processStatus(int status) {
        this.setButtonsAccess(status);
        this.workDirLocation.setText("" + GlobalVariables.workDirectory);
        this.workDirSelector.setRootDir(GlobalVariables.workDirectory);
        Wings.spliningParameterFrame.cp0FileSelector.setRootDir(GlobalVariables.workDirectory);
        GlobalVariables.wingsStatus = status;
        System.out.println("Status: " + status);
        switch (status) {
            case 8: {
                System.out.println("EDITED: 8");
            }
            case 5: {
                System.out.println("ALL_SPLINED: 5");
            }
            case 4: {
                System.out.println("PARTIAL_SPLINED: 4");
            }
            case 2: {
                System.out.println("WORKING_DIR: 2");
            }
        }
    }

    private JMenuBar makeMenuBar() {
        this.preferencesMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences p = new Preferences(Wings.this);
            }
        });
        this.fileMenu.add(this.preferencesMI);
        this.exitMI.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.exitMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Wings.this.exit();
            }
        });
        this.fileMenu.add(this.exitMI);
        this.masterSplineMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.splineMenu.add(this.masterSplineMI);
        this.splineParametersMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(e);
                spliningParameterFrame.setVisible(!spliningParameterFrame.isVisible());
            }
        });
        this.windowsMenu.add(this.splineParametersMI);
        this.logMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(e);
                Wings.this.logFrame.setVisible(!Wings.this.logFrame.isVisible());
            }
        });
        this.windowsMenu.add(this.logMI);
        this.tiffViewerMI.setEnabled(false);
        this.tiffViewerMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(e);
                try {
                    Wings.this.showTiffViewer(GlobalVariables.individuals);
                }
                catch (IOException ex) {
                    Logger.getLogger(Wings.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.windowsMenu.add(this.tiffViewerMI);
        this.helpMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HTMLFrame html = new HTMLFrame(Wings.this);
            }
        });
        this.helpMenu.add(this.helpMI);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.emailMI);
        this.emailMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Mail.mailKim();
            }
        });
        this.helpMenu.add(this.aboutMI);
        this.aboutMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Wings.this.about.setResizable(false);
                Wings.this.about.setVisible(true);
            }
        });
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.individualMenu);
        this.menuBar.add(this.splineMenu);
        this.menuBar.add(this.windowsMenu);
        this.menuBar.add(this.helpMenu);
        return this.menuBar;
    }

    public void addMenuItem(Menu parent, String name) {
        MenuItem mi = new MenuItem(name);
        mi.setActionCommand(name);
        parent.add(mi);
    }

    public void addMenuItem(Menu parent, String name, int shortCut) {
        MenuItem mi = new MenuItem(name, new MenuShortcut(shortCut));
        mi.setActionCommand(name);
        parent.add(mi);
    }

    private void exit() {
        Object[] options = new Object[]{"Yes", "No"};
        int back = JOptionPane.showOptionDialog(this, "End Wings session?", "Confirmation requested", 0, 3, null, options, options[1]);
        if (back == 0) {
            this.saveAll();
            this.saveProperties();
            System.exit(0);
        }
    }

    private void saveAll() {
        if (GlobalVariables.individuals != null) {
            GlobalVariables.individuals.saveAll();
        }
    }

    public Individual[] goodIndividualArray() {
        Individual[] goodArray = new Individual[10];
        Iterator<Individual> i = GlobalVariables.individuals.values().iterator();
        int x = 0;
        while (i.hasNext()) {
            goodArray[x] = i.next();
            if (goodArray[x].getProcessingStatus() >= 8 && !goodArray[x].isOutlier()) {
                ++x;
            }
            if (x != 10) continue;
            break;
        }
        return goodArray;
    }

    private boolean saveProperties() {
        System.out.println("Saving properties from wings proper");
        GlobalVariables.props = new Properties();
        GlobalVariables.props.setProperty("properties.dir", System.getProperty("user.dir") + File.separator + "wings.properties");
        GlobalVariables.props.setProperty("landmark.definition", System.getProperty("landmark.definition"));
        GlobalVariables.props.setProperty("overlay.store", System.getProperty("overlay.store"));
        GlobalVariables.props.setProperty("overlay.size", System.getProperty("overlay.size"));
        GlobalVariables.props.setProperty("overlay.fileType", System.getProperty("overlay.fileType"));
        GlobalVariables.props.setProperty("working.dir", GlobalVariables.workDirectory.toString());
        try {
            GlobalVariables.props.store(new FileOutputStream(new File(System.getProperty("user.dir"), "wings.properties")), "Properties for wings");
            return true;
        }
        catch (FileNotFoundException fnfe) {
            Logger.getLogger(Wings.class.getName()).log(Level.SEVERE, null, fnfe);
            return false;
        }
        catch (IOException ioe) {
            Logger.getLogger(Wings.class.getName()).log(Level.SEVERE, null, ioe);
            return false;
        }
    }

    private void propertiesCheck() throws FileNotFoundException, IOException {
        this.propertyCheck("properties.dir", "wings.properties");
        this.propertyCheck("landmark.definition", "*.definition");
    }

    private void propertyCheck(String key, String value) throws FileNotFoundException, IOException {
        this.propertyCheck(key, value, "");
    }

    private void propertyCheck(String key, String value, String value2) throws FileNotFoundException, IOException {
        if (GlobalVariables.props.getProperty(key) == null) {
            throw new IOException("wings.properties lacks entry for " + key);
        }
        String propValue = GlobalVariables.props.getProperty(key);
        File f = new File(propValue);
        if (f.exists()) {
            if (value.toLowerCase().indexOf("*.") != -1) {
                if (!propValue.substring(propValue.lastIndexOf(46)).equalsIgnoreCase(value.substring(value.lastIndexOf(46)))) {
                    throw new FileNotFoundException("Not a file with extenstion: " + value);
                }
            } else if (!f.getName().equalsIgnoreCase(value) && !f.getName().equalsIgnoreCase(value2)) {
                throw new FileNotFoundException("Incorrect file found: " + propValue + " instead of " + value + " or " + value2);
            }
        } else {
            throw new FileNotFoundException(f + " not found");
        }
    }

    public void clear() {
        this.iteration = 0;
        SpliningParameterFrame.cp0ListModel.removeAllElements();
        Wings.spliningParameterFrame.cp0List.insertItemAt("Please select working directory", 0);
        Wings.spliningParameterFrame.cp0List.setSelectedIndex(0);
        GlobalVariables.logFileSet = 0;
        GlobalVariables.ntsFileSet = 0;
        GlobalVariables.individuals = null;
        if (this.individualFrame != null) {
            this.individualFrame.dispose();
        }
    }

    private void clearIndividuals() {
        int x;
        FileFilter fnf = new CPFilter(false);
        File[] files = GlobalVariables.workDirectory.listFiles((FilenameFilter)((Object)fnf));
        try {
            for (x = 0; x < files.length; ++x) {
                files[x].delete();
            }
        }
        catch (Exception e) {
            Logger.getLogger(Wings.class.getName()).log(Level.SEVERE, null, e);
        }
        fnf = new WingsTiffFilter(false);
        files = GlobalVariables.workDirectory.listFiles((FilenameFilter)((Object)fnf));
        try {
            for (x = 0; x < files.length; ++x) {
                files[x].delete();
            }
        }
        catch (Exception e) {
            Logger.getLogger(Wings.class.getName()).log(Level.SEVERE, null, e);
        }
        fnf = new OverlayFilter(false);
        files = GlobalVariables.workDirectory.listFiles((FilenameFilter)((Object)fnf));
        try {
            for (int x2 = 0; x2 < files.length; ++x2) {
                files[x2].delete();
            }
        }
        catch (Exception e) {
            Logger.getLogger(Wings.class.getName()).log(Level.SEVERE, null, e);
        }
        GlobalVariables.individuals.reset();
    }

    public static void reworkCpXList() {
        Wings.spliningParameterFrame.cp0List.removeAllItems();
        Wings.spliningParameterFrame.cp0List.insertItemAt("Select CP# file for splining", 0);
    }

    public static void setCPXFile(int i, String string) {
        Wings.spliningParameterFrame.cp0List.insertItemAt(string, i);
        if (Wings.spliningParameterFrame.cp0List.getItemCount() > 2) {
            Wings.spliningParameterFrame.cp0List.setSelectedIndex(0);
        } else {
            Wings.spliningParameterFrame.cp0List.setSelectedIndex(1);
        }
    }

    public void prepareIndividual(Individual ind) {
        spliningParameterFrame.setIndividual(ind);
    }

    private static void createAndShowGUI() throws FileNotFoundException, IOException {
        System.out.println("Starting Wings");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int inset = 50;
        GlobalVariables.width = screenSize.width - inset * 2;
        GlobalVariables.height = (int)((double)screenSize.height - (double)inset * 2.5);
        Wings f = new Wings("Wings (version " + version + ") for the analysis of wing data");
        f.setBounds(inset, inset, GlobalVariables.width, GlobalVariables.height);
        f.setVisible(true);
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Wings.createAndShowGUI();
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(Wings.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(Wings.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    private void storeSpliningParameters() {
        GlobalVariables.spliningParameters = spliningParameterFrame.getSpliningParameterSet();
    }
}

