/*
 * Decompiled with CFR 0.152.
 */
package kim.math.sort;

public class HeapSortAlgorithm {
    private HeapSortAlgorithm() {
    }

    public static double[] sort(double[] a) throws Exception {
        HeapSortAlgorithm.Heapify(a);
        for (int i = a.length - 1; i >= 0; --i) {
            HeapSortAlgorithm.DeleteMax(i, a);
        }
        return a;
    }

    public static int[] sort(int[] a) throws Exception {
        HeapSortAlgorithm.Heapify(a);
        for (int i = a.length - 1; i >= 0; --i) {
            HeapSortAlgorithm.DeleteMax(i, a);
        }
        return a;
    }

    public static void Heapify(double[] a) throws Exception {
        for (int i = a.length / 2; i >= 0; --i) {
            HeapSortAlgorithm.BubbleDown(i, a, a.length - 1);
        }
    }

    public static void Heapify(int[] a) throws Exception {
        for (int i = a.length / 2; i >= 0; --i) {
            HeapSortAlgorithm.BubbleDown(i, a, a.length - 1);
        }
    }

    private static void BubbleDown(int i, double[] a, int size) throws Exception {
        double top = a[i];
        int root = i;
        while (root * 2 + 1 <= size) {
            if (root * 2 + 1 == size || a[root * 2 + 1] > a[root * 2 + 2]) {
                if (a[root * 2 + 1] < top) break;
                a[root] = a[root * 2 + 1];
                root = root * 2 + 1;
                continue;
            }
            if (a[root * 2 + 2] < top) break;
            a[root] = a[root * 2 + 2];
            root = root * 2 + 2;
        }
        a[root] = top;
    }

    private static void BubbleDown(int i, int[] a, int size) throws Exception {
        int top = a[i];
        int root = i;
        while (root * 2 + 1 <= size) {
            if (root * 2 + 1 == size || a[root * 2 + 1] > a[root * 2 + 2]) {
                if (a[root * 2 + 1] < top) break;
                a[root] = a[root * 2 + 1];
                root = root * 2 + 1;
                continue;
            }
            if (a[root * 2 + 2] < top) break;
            a[root] = a[root * 2 + 2];
            root = root * 2 + 2;
        }
        a[root] = top;
    }

    public static void DeleteMax(int i, double[] a) throws Exception {
        HeapSortAlgorithm.swap(0, i, a);
        HeapSortAlgorithm.BubbleDown(0, a, i - 1);
    }

    private static void swap(int i, int j, double[] a) throws Exception {
        double temp = a[i];
        a[i] = a[j];
        a[j] = temp;
    }

    public static void DeleteMax(int i, int[] a) throws Exception {
        HeapSortAlgorithm.swap(0, i, a);
        HeapSortAlgorithm.BubbleDown(0, a, i - 1);
    }

    private static void swap(int i, int j, int[] a) throws Exception {
        int temp = a[i];
        a[i] = a[j];
        a[j] = temp;
    }
}

