/*
 * Decompiled with CFR 0.152.
 */
package kim.math;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import kim.io.file.ReadDataFile;

public class Transpose
extends Frame {
    String data;
    int[][] values;
    String[] samples;

    public Transpose(String fileName) {
        System.out.println("Read data");
        try {
            this.data = ReadDataFile.getData(fileName);
            System.out.println("Start filling matrix");
            StringTokenizer lines = new StringTokenizer(this.data, "\n", false);
            StringTokenizer names = new StringTokenizer(lines.nextToken(), "\t");
            int sampleCounter = 0;
            int sampleCount = names.countTokens();
            this.samples = new String[sampleCount];
            System.out.println("Number of samples: " + sampleCount);
            int bandCounter = 0;
            int bandCount = lines.countTokens();
            this.values = new int[bandCount][sampleCount];
            System.out.println("Number of bands: " + bandCount);
            while (names.hasMoreTokens()) {
                this.samples[sampleCounter] = names.nextToken();
                ++sampleCounter;
            }
            bandCounter = 0;
            while (lines.hasMoreTokens()) {
                StringTokenizer cells = new StringTokenizer(lines.nextToken(), "\t");
                sampleCounter = 0;
                while (cells.hasMoreTokens()) {
                    this.values[bandCounter][sampleCounter] = new Integer(cells.nextToken());
                    ++sampleCounter;
                }
                ++bandCounter;
            }
            System.out.println("Writing TreeCon file");
            PrintStream uitvoer = new PrintStream(new FileOutputStream(fileName.substring(0, fileName.lastIndexOf(".")) + ".tc"));
            uitvoer.println(bandCount);
            int binary = 0;
            for (int x = 0; x < sampleCount; ++x) {
                uitvoer.println(this.samples[x]);
                for (int y = 0; y < bandCount; ++y) {
                    binary = this.values[y][x] == 0 ? 0 : 1;
                    uitvoer.print(binary);
                }
                uitvoer.println("");
            }
            uitvoer.close();
            System.exit(0);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe);
            System.exit(1);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        System.out.println("Starting App");
        if (args.length == 1) {
            Transpose p = new Transpose(args[0]);
        } else {
            Frame f = new Frame();
            FileDialog fd = new FileDialog(f, "Open file for Transposer!");
            fd.show();
            if (fd.getFile() == null) {
                System.exit(2);
            }
            String fileName = fd.getDirectory() + fd.getFile();
            Transpose p = new Transpose(fileName);
        }
    }
}

