/*
 * Decompiled with CFR 0.152.
 */
package kim.io.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;

public class FileCopy {
    private FileCopy() {
    }

    public static File plain(File oldLocation, File newLocation) {
        System.out.println("FileCopy.plain: " + oldLocation + " -> " + newLocation);
        try {
            String nextLine;
            BufferedReader in = new BufferedReader(new FileReader(oldLocation));
            PrintWriter out = new PrintWriter((Writer)new BufferedWriter(new FileWriter(newLocation)), true);
            while ((nextLine = in.readLine()) != null) {
                out.println(nextLine);
            }
            in.close();
            out.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        return newLocation;
    }

    public static void generic(File oldLocation, File newLocation) throws IOException {
        FileCopy.generic(oldLocation, newLocation, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generic(File oldLocation, File newLocation, boolean overwriteOk) throws IOException {
        System.out.println("FileCopy.generic: " + oldLocation + " -> " + newLocation);
        if (!oldLocation.exists()) {
            throw new IOException("FileCopy: no such source file: " + oldLocation);
        }
        if (!oldLocation.isFile()) {
            throw new IOException("FileCopy: can't copy directory: " + oldLocation);
        }
        if (!oldLocation.canRead()) {
            throw new IOException("FileCopy: source file is unreadable: " + oldLocation);
        }
        if (newLocation.isDirectory()) {
            newLocation = new File(newLocation, oldLocation.getName());
        }
        if (newLocation.exists()) {
            if (!newLocation.canWrite()) {
                throw new IOException("FileCopy: destination file is unwriteable: " + newLocation);
            }
            if (!overwriteOk) {
                System.out.print("Overwrite existing file " + newLocation + "? (Y/N): ");
                System.out.flush();
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                String response = in.readLine();
                if (!response.equalsIgnoreCase("Y")) {
                    throw new IOException("FileCopy: existing file was not overwritten.");
                }
            }
        } else {
            File dir;
            String parent = newLocation.getParent();
            if (parent == null) {
                parent = System.getProperty("user.dir");
            }
            if (!(dir = new File(parent)).exists()) {
                throw new IOException("FileCopy: destination directory doesn't exist: " + parent);
            }
            if (dir.isFile()) {
                throw new IOException("FileCopy: destination is not a directory: " + parent);
            }
            if (!dir.canWrite()) {
                throw new IOException("FileCopy: destination directory is unwriteable: " + parent);
            }
        }
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytes_read;
            from = new FileInputStream(oldLocation);
            to = new FileOutputStream(newLocation);
            byte[] buffer = new byte[4096];
            while ((bytes_read = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytes_read);
            }
        }
        finally {
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException e) {}
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static void abort(String msg) throws IOException {
        throw new IOException(msg);
    }

    public static void main(String[] args) {
        try {
            File kim = new File("D:\\wings\\copytest\\from\\kim.tif");
            FileCopy.generic(new File("D:\\wings\\copytest\\from\\ind1037.tif"), kim);
        }
        catch (Exception e) {
            System.out.println("ERROR");
            e.printStackTrace();
        }
    }
}

