/*
 * Decompiled with CFR 0.152.
 */
package kim.image.advanced.convolutionkernels;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import kim.image.advanced.convolutionkernels.KernelSizeException;
import kim.math.sort.HeapSortAlgorithm;

public class SpatialFilters {
    public static BufferedImage medianSmoothing(BufferedImage image, int kernelSize) throws KernelSizeException {
        if (kernelSize % 2 != 1) {
            throw new KernelSizeException();
        }
        int N = (kernelSize * kernelSize - 1) / 2;
        return SpatialFilters.NthOrderSmoothing(image, kernelSize, N);
    }

    public static BufferedImage NthOrderSmoothing(BufferedImage image, int kernelSize, int N) throws KernelSizeException {
        if (kernelSize % 2 != 1) {
            throw new KernelSizeException("Even number of pixels");
        }
        if (N > kernelSize * kernelSize) {
            throw new KernelSizeException("N out of range of squared kernel size");
        }
        int edge = (kernelSize - 1) / 2;
        ColorModel cm = image.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster ras = image.copyData(null);
        DataBufferByte db = (DataBufferByte)ras.getDataBuffer();
        byte[] data = db.getData();
        int width = image.getWidth();
        int height = image.getHeight();
        int[] values = new int[kernelSize * kernelSize];
        int[] sortedValues = new int[kernelSize * kernelSize];
        for (int j = edge; j < height - edge; ++j) {
            for (int i = edge; i < width - edge; ++i) {
                int count = 0;
                for (int x = j - edge; x <= j + edge; ++x) {
                    int y = i - edge;
                    while (y <= i + edge) {
                        values[count] = data[x * width + y] & 0xFF;
                        ++y;
                        ++count;
                    }
                }
                try {
                    sortedValues = HeapSortAlgorithm.sort(values);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                db.setElem(j * width + i, (byte)sortedValues[N]);
            }
        }
        return new BufferedImage(cm, ras, isAlphaPremultiplied, null);
    }

    public static int[][] medianSmoothing(int[][] data, int kernelSize) throws KernelSizeException {
        if (kernelSize % 2 != 1) {
            throw new KernelSizeException();
        }
        int N = (kernelSize * kernelSize - 1) / 2;
        return SpatialFilters.NthOrderSmoothing(data, kernelSize, N);
    }

    public static int[][] NthOrderSmoothing(int[][] data, int kernelSize, int N) throws KernelSizeException {
        if (kernelSize % 2 != 1) {
            throw new KernelSizeException("Even number of pixels");
        }
        if (N > kernelSize * kernelSize) {
            throw new KernelSizeException("N out of range of squared kernel size");
        }
        int edge = (kernelSize - 1) / 2;
        int width = data.length - edge;
        int height = data[0].length - edge;
        int[][] smoothedData = new int[data.length][data[0].length];
        int[] values = new int[kernelSize * kernelSize];
        for (int i = edge; i < width; ++i) {
            for (int j = edge; j < height; ++j) {
                int count = 0;
                for (int x = i - edge; x <= i + edge; ++x) {
                    int y = j - edge;
                    while (y <= j + edge) {
                        values[count] = data[x][y];
                        ++y;
                        ++count;
                    }
                }
                try {
                    HeapSortAlgorithm.sort(values);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                smoothedData[i][j] = values[N];
            }
        }
        return smoothedData;
    }

    public static double[][] averageSmoothing(double[][] data, int kernelSize) throws KernelSizeException {
        if (kernelSize % 2 != 1) {
            throw new KernelSizeException();
        }
        int edge = (kernelSize - 1) / 2;
        int kernelPixels = kernelSize * kernelSize;
        int columns = data.length - edge;
        int rows = data[0].length - edge;
        double[][] smoothedData = new double[data[0].length][data.length];
        double sum = 0.0;
        for (int j = edge; j < rows; ++j) {
            for (int i = edge; i < columns; ++i) {
                for (int x = j - edge; x <= j + edge; ++x) {
                    for (int y = i - edge; y <= i + edge; ++y) {
                        sum += data[x][y];
                    }
                }
                smoothedData[j][i] = sum / (double)kernelPixels;
            }
        }
        return smoothedData;
    }

    public static double[][] averageSmoothing(int[][] data, int kernelSize) throws KernelSizeException {
        if (kernelSize % 2 != 1) {
            throw new KernelSizeException();
        }
        int edge = (kernelSize - 1) / 2;
        int kernelPixels = kernelSize * kernelSize;
        int columns = data.length - edge;
        int rows = data[0].length - edge;
        double[][] smoothedData = new double[data[0].length][data.length];
        double sum = 0.0;
        for (int j = edge; j < rows; ++j) {
            for (int i = edge; i < columns; ++i) {
                for (int x = j - edge; x <= j + edge; ++x) {
                    for (int y = i - edge; y <= i + edge; ++y) {
                        sum += (double)data[x][y];
                    }
                }
                smoothedData[j][i] = sum / (double)kernelPixels;
            }
        }
        return smoothedData;
    }
}

