/*
 * Decompiled with CFR 0.152.
 */
package kim.image.advanced.convolutionkernels;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import kim.image.advanced.convolutionkernels.KernelSizeException;

public class GrayscaleMorphology {
    public static BufferedImage erosion(BufferedImage image, int kernelSize) throws KernelSizeException {
        if (kernelSize % 2 != 1) {
            throw new KernelSizeException();
        }
        int edge = (kernelSize - 1) / 2;
        ColorModel cm = image.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster ras = image.copyData(null);
        WritableRaster rasNew = image.copyData(null);
        DataBufferByte db = (DataBufferByte)ras.getDataBuffer();
        DataBufferByte dbNew = (DataBufferByte)rasNew.getDataBuffer();
        byte[] data = db.getData();
        int width = image.getWidth();
        int height = image.getHeight();
        int newVal = 1000;
        for (int j = edge; j < height - edge; ++j) {
            for (int i = edge; i < width - edge; ++i) {
                newVal = 1000;
                for (int x = j - edge; x <= j + edge; ++x) {
                    for (int y = i - edge; y <= i + edge; ++y) {
                        newVal = Math.min(newVal, data[x * width + y] & 0xFF);
                    }
                }
                dbNew.setElem(j * width + i, (byte)newVal);
            }
        }
        return new BufferedImage(cm, rasNew, isAlphaPremultiplied, null);
    }

    public static int[][] erosion(int[][] data, int kernelSize) throws KernelSizeException {
        if (kernelSize % 2 != 1) {
            throw new KernelSizeException();
        }
        int edge = (kernelSize - 1) / 2;
        int columns = data.length;
        int rows = data[0].length;
        int[][] greyData = new int[rows][columns];
        int newVal = 1000;
        for (int j = edge; j < rows - edge; ++j) {
            for (int i = edge; i < columns - edge; ++i) {
                newVal = 1000;
                for (int x = j - edge; x <= j + edge; ++x) {
                    for (int y = i - edge; y <= i + edge; ++y) {
                        newVal = Math.min(newVal, data[x][y]);
                    }
                }
                greyData[j][i] = newVal;
            }
        }
        return greyData;
    }

    public static BufferedImage dilation(BufferedImage image, int kernelSize) throws KernelSizeException {
        if (kernelSize % 2 != 1) {
            throw new KernelSizeException();
        }
        int edge = (kernelSize - 1) / 2;
        ColorModel cm = image.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster ras = image.copyData(null);
        WritableRaster rasNew = image.copyData(null);
        DataBufferByte db = (DataBufferByte)ras.getDataBuffer();
        DataBufferByte dbNew = (DataBufferByte)rasNew.getDataBuffer();
        byte[] data = db.getData();
        int width = image.getWidth();
        int height = image.getHeight();
        int newVal = 0;
        for (int j = edge; j < height - edge; ++j) {
            for (int i = edge; i < width - edge; ++i) {
                newVal = -1000;
                for (int x = j - edge; x <= j + edge; ++x) {
                    for (int y = i - edge; y <= i + edge; ++y) {
                        newVal = Math.max(newVal, data[x * width + y] & 0xFF);
                    }
                }
                dbNew.setElem(j * width + i, (byte)newVal);
            }
        }
        return new BufferedImage(cm, rasNew, isAlphaPremultiplied, null);
    }

    public static int[][] dilation(int[][] data, int kernelSize) throws KernelSizeException {
        if (kernelSize % 2 != 1) {
            throw new KernelSizeException();
        }
        int edge = (kernelSize - 1) / 2;
        int columns = data.length;
        int rows = data[0].length;
        int[][] greyData = new int[rows][columns];
        int newVal = -1000;
        for (int j = edge; j < rows - edge; ++j) {
            for (int i = edge; i < columns - edge; ++i) {
                newVal = -1000;
                for (int x = j - edge; x <= j + edge; ++x) {
                    for (int y = i - edge; y <= i + edge; ++y) {
                        newVal = Math.max(newVal, data[x][y]);
                    }
                }
                greyData[j][i] = newVal;
            }
        }
        return greyData;
    }
}

