/*
 * Decompiled with CFR 0.152.
 */
package kim.image;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.util.ImagingException;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.media.jai.JAI;
import javax.media.jai.NullOpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;

public class JPGTest {
    public static PlanarImage load2(File fileLocation, String opname) throws IOException {
        ParameterBlock pb = new ParameterBlock().add(fileLocation.toString());
        RenderedOp src = JAI.create((String)"fileload", (ParameterBlock)pb);
        return src;
    }

    public static PlanarImage load(SeekableStream inputStream, String opname) throws IOException {
        ImageDecoder dec = ImageCodec.createImageDecoder(opname, inputStream, null);
        RenderedImage im = null;
        im = dec.decodeAsRenderedImage();
        NullOpImage image = null;
        if (im != null) {
            image = new NullOpImage(im, null, null, 2);
        }
        return image;
    }

    public static void save2(PlanarImage image, File fileLocation, String opname) throws IOException {
        JAI.create((String)"filestore", (RenderedImage)image, (Object)fileLocation.toString(), (Object)"JPEG", null);
    }

    public static void save(PlanarImage image, File fileLocation, String opname) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(fileLocation);
        try {
            JPEGEncodeParam param = new JPEGEncodeParam();
            ImageEncoder enc = ImageCodec.createImageEncoder(opname, outputStream, param);
            enc.encode((RenderedImage)image);
        }
        catch (ImagingException ie) {
            System.out.println(ie.getRootCause());
            System.out.println(ie.getCause());
        }
        outputStream.close();
    }

    public static void main(String[] args) {
        File oldFile = new File("D:\\wings\\copytest\\from\\ind1037.jpg");
        File create = new File("D:\\wings\\copytest\\from\\create.jpg");
        File streams = new File("D:\\wings\\copytest\\from\\streams.jpg");
        File fileStore = new File("D:\\wings\\copytest\\from\\fileStore.jpg");
        try {
            System.out.println("(1) Load with filenames and JAI.create():");
            PlanarImage in = JPGTest.load2(oldFile, "JPEG");
            System.out.println("Loaded original file (" + oldFile.length() + "):" + in);
            System.out.println("Save file with encode.");
            JPGTest.save(in, create, "JPEG");
            PlanarImage in3 = JPGTest.load2(create, "JPEG");
            System.out.println("Loaded saved file (" + create.length() + "):" + in3);
            System.out.println("\n(2) Load with decode and streams:");
            FileSeekableStream oldFileInputStream = new FileSeekableStream(oldFile);
            PlanarImage in1 = JPGTest.load(oldFileInputStream, "JPEG");
            System.out.println("Loaded original file (same as before) stream open (" + oldFile.length() + "): " + in1);
            ((InputStream)oldFileInputStream).close();
            System.out.println("Loaded original file (same as before) stream closed (" + oldFile.length() + "): " + in1);
            System.out.println("\nSave file with JAI.create(\"filestore\".");
            JPGTest.save2(in1, fileStore, "JPEG");
            FileSeekableStream newFileInputStream2 = new FileSeekableStream(fileStore);
            PlanarImage in4 = JPGTest.load(newFileInputStream2, "JPEG");
            System.out.println("Loaded saved file; stream open (" + fileStore.length() + "): " + in4);
            ((InputStream)newFileInputStream2).close();
            System.out.println("Loaded saved file; stream closed (" + fileStore.length() + "): " + in4);
            System.out.println("/nSave file with encode.");
            JPGTest.save(in1, streams, "JPEG");
            FileSeekableStream newFileInputStream = new FileSeekableStream(streams);
            PlanarImage in2 = JPGTest.load(newFileInputStream, "JPEG");
            System.out.println("Loaded saved file; stream open (" + streams.length() + "): " + in2);
            ((InputStream)newFileInputStream).close();
            System.out.println("Loaded saved file; stream closed (" + streams.length() + "): " + in2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

