/*
 * Decompiled with CFR 0.152.
 */
package kim.image;

import com.sun.media.jai.codec.SeekableStream;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class ImageFile {
    public static BufferedImage load(SeekableStream inputStream, String opname) throws IIOException, IOException {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(opname);
        ImageReader reader = readers.next();
        ImageInputStream iis = ImageIO.createImageInputStream(inputStream);
        reader.setInput(iis, true);
        return reader.read(0);
    }

    public static BufferedImage load(File f) throws IIOException, IOException {
        return ImageIO.read(f);
    }

    public static BufferedImage load(File f, String opname) throws IIOException, IOException {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(opname);
        ImageReader reader = readers.next();
        ImageInputStream iis = ImageIO.createImageInputStream(f);
        reader.setInput(iis, true);
        BufferedImage image = reader.read(0);
        iis.close();
        return image;
    }

    public static BufferedImage load(FileImageInputStream fileStream, String opname) throws IIOException, IOException {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(opname);
        ImageReader reader = readers.next();
        System.out.println(reader);
        reader.setInput(fileStream, true);
        return reader.read(0);
    }

    public static void save(BufferedImage image, File fileLocation, String opname) throws IIOException, IOException {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(opname);
        ImageWriter writer = writers.next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(fileLocation);
        writer.setOutput(ios);
        writer.write(image);
        ios.close();
    }

    public static void save(BufferedImage image, FileImageOutputStream fileStream, String opname) throws IIOException, IOException {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(opname);
        ImageWriter writer = writers.next();
        writer.setOutput(fileStream);
        writer.write(image);
    }

    public static void save(RenderedImage image, FileImageOutputStream fileStream, String opname) throws IIOException, IOException {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(opname);
        ImageWriter writer = writers.next();
        writer.setOutput(fileStream);
        writer.write(image);
    }

    public static void save(RenderedImage image, File fileStream, String opname) throws IIOException, IOException {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(opname);
        ImageWriter writer = writers.next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(fileStream);
        writer.setOutput(ios);
        writer.write(image);
    }

    public static void main(String[] args) {
        File oldFile = new File("C:\\wings\\java\\original.tif");
        File create = new File("C:\\wings\\java\\create.tif");
        File jpgFile = new File("C:\\wings\\java\\create.tif");
    }
}

