/*
 * Decompiled with CFR 0.152.
 */
package kim.awt.graphics;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public abstract class VerticalGraphics
extends Graphics {
    private Canvas c = new Canvas();

    protected VerticalGraphics() {
    }

    public Image drawVerticalString(String s, Color backGround) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int h = fm.getHeight();
        int w = fm.stringWidth(s) + 4;
        Image i = this.c.createImage(w, h);
        Graphics iGC = i.getGraphics();
        iGC.setColor(backGround);
        iGC.fillRect(0, 0, w, h);
        iGC.setColor(Color.black);
        iGC.drawString(s, 3, h - 4);
        int[] pixels = new int[w * h + 1];
        PixelGrabber pg = new PixelGrabber(i, 0, 0, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("Interrupted waiting for pixels!");
            return null;
        }
        if ((pg.status() & 0x80) != 0) {
            System.err.println("Image fetch aborted or errored!");
            return i;
        }
        int[] pixelsnew = new int[h * w + 1];
        int a = 0;
        for (int j = w; j > 0; --j) {
            for (int k = 0; k < h; ++k) {
                pixelsnew[a] = pixels[j + k * w];
                if (pixelsnew[a] != -3618616 && pixelsnew[a] != -16777216) {
                    pixelsnew[a] = -3618616;
                }
                ++a;
            }
        }
        Image i2 = this.c.createImage(new MemoryImageSource(h, w, pixelsnew, 0, h));
        return i2;
    }
}

