/*
 * Decompiled with CFR 0.152.
 */
package kim.awt.dialog;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Hashtable;

public class JavaFileDialog
extends Dialog {
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    private Choice searchIn = new Choice();
    private Choice fileTypes = new Choice();
    private TextField fileName = new TextField(25);
    private List fileList = new List(10);
    private Label searchInL = new Label("Seach in:");
    private Label fileNameL = new Label("File name:");
    private Label fileTypesL = new Label("File type:");
    private Button open = new Button("Open");
    private Button save = new Button("Save");
    private Button up = new Button("Up");
    private Button cancel = new Button("Cancel");
    private int mode = 0;
    private Panel bottom = new Panel();
    private Panel bottomRight = new Panel();
    private Panel bottomLeft = new Panel();
    private Panel bottomCenter = new Panel();
    private Panel top = new Panel();
    private File current = new File(".");
    private String[] files;
    private File selectedFile;
    private File selectedDir;
    private Hashtable connections = new Hashtable();
    private String filterText = "";

    public JavaFileDialog(Frame parent, String title, int mode, boolean multiFile) {
        super(parent, title, true);
        this.setResizable(false);
        this.fileList.setMultipleMode(multiFile);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JavaFileDialog.this.setVisible(false);
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaFileDialog.this.dispose();
            }
        });
        this.up.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("One directory up");
            }
        });
        this.fileName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = JavaFileDialog.this.fileName.getText();
                System.out.println(s + "; " + e);
                JavaFileDialog.this.filterText = s;
                JavaFileDialog.this.getFiles();
            }
        });
        this.open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = JavaFileDialog.this.fileList.getSelectedItem();
                if (s == null) {
                    s = "";
                }
                if (new File(JavaFileDialog.this.current, s).isDirectory()) {
                    JavaFileDialog.this.current = new File(JavaFileDialog.this.current, s);
                    JavaFileDialog.this.getFiles();
                } else {
                    JavaFileDialog.this.selectedFile = new File(s);
                    JavaFileDialog.this.selectedDir = JavaFileDialog.this.current;
                    JavaFileDialog.this.dispose();
                }
            }
        });
        this.fileList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String[] s = JavaFileDialog.this.fileList.getSelectedItems();
                String singleFileText = "";
                String multiFileText = "";
                int numberOfFiles = 0;
                if (s.length > 0) {
                    for (int x = 0; x < s.length; ++x) {
                        File tempFile = new File(s[x]);
                        if (tempFile.isDirectory()) continue;
                        singleFileText = s[x];
                        multiFileText = ++numberOfFiles == 1 ? "\"" + singleFileText + "\"" : multiFileText + ", \"" + s[x] + "\"";
                    }
                    if (numberOfFiles == 1) {
                        JavaFileDialog.this.fileName.setText(singleFileText);
                    } else {
                        JavaFileDialog.this.fileName.setText(multiFileText);
                    }
                } else {
                    JavaFileDialog.this.fileName.setText("");
                }
            }
        });
        this.fileList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File tempFile = new File(JavaFileDialog.this.current, e.getActionCommand());
                if (tempFile.isDirectory()) {
                    JavaFileDialog.this.current = tempFile;
                    JavaFileDialog.this.getFiles();
                } else {
                    JavaFileDialog.this.selectedFile = new File(e.getActionCommand());
                    JavaFileDialog.this.selectedDir = JavaFileDialog.this.current;
                    JavaFileDialog.this.dispose();
                }
            }
        });
        this.fileTypes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JavaFileDialog.this.filterText = (String)JavaFileDialog.this.connections.get(JavaFileDialog.this.fileTypes.getSelectedItem());
                JavaFileDialog.this.getFiles();
            }
        });
        this.setSize(400, 300);
        this.setLayout(new BorderLayout(15, 15));
        this.bottomLeft.setLayout(new BorderLayout(5, 5));
        this.bottomLeft.add("North", this.fileNameL);
        this.bottomLeft.add("Center", this.fileTypesL);
        this.bottomCenter.setLayout(new BorderLayout(5, 5));
        this.bottomCenter.add("North", this.fileName);
        this.bottomCenter.add("Center", this.fileTypes);
        this.bottomRight.setLayout(new BorderLayout(5, 5));
        if (mode == 0) {
            this.bottomRight.add("North", this.open);
        } else {
            this.bottomRight.add("North", this.save);
        }
        this.bottomRight.add("Center", this.cancel);
        this.bottom.add(this.bottomLeft);
        this.bottom.add(this.bottomCenter);
        this.bottom.add(this.bottomRight);
        this.top.add(this.searchInL);
        this.top.add(this.searchIn);
        this.top.add(this.up);
        this.add("South", this.bottom);
        this.add("Center", this.fileList);
        this.setFilenameFilter("All Files", ".*");
        this.getFiles();
    }

    public JavaFileDialog(Frame parent) {
        this(parent, "", 0, false);
    }

    public JavaFileDialog(Frame parent, String title) {
        this(parent, title, 0, false);
    }

    public JavaFileDialog(Frame parent, String title, boolean multiFile) {
        this(parent, title, 0, multiFile);
    }

    public void setFilenameFilter(String fileDescription, String filter) {
        String s = fileDescription + " (*" + filter + ")";
        this.fileTypes.add(s);
        this.filterText = filter;
    }

    void getFiles() {
        this.fileList.removeAll();
        if (this.filterText.equals(".*")) {
            this.filterText = "";
        }
        this.filterText = this.filterText.replace('*', ' ').trim();
        this.files = this.current.list(new FilenameFilter(){

            @Override
            public boolean accept(File f, String s) {
                if (s.endsWith(JavaFileDialog.this.filterText) || new File(JavaFileDialog.this.current, s).isDirectory()) {
                    return true;
                }
                System.out.println(f + "\\" + s);
                return false;
            }
        });
        this.fileList.add(".");
        this.fileList.add("..");
        for (int x = 0; x < this.files.length; ++x) {
            this.fileList.add(this.files[x]);
        }
        this.fileList.add("(A:\\)");
        for (char letter = 'C'; letter <= 'Z'; letter = (char)(letter + '\u0001')) {
            File disk = new File("(" + letter + ":\\)");
            if (!disk.exists()) continue;
            this.fileList.add("" + letter + ":\\");
        }
    }

    public File getFile() {
        return this.selectedFile;
    }

    public File getDirectory() {
        return this.selectedDir;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(450, 350);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(450, 350);
    }
}

