/*
 * Decompiled with CFR 0.152.
 */
package kim.awt.composite;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;
import kim.util.JGridBag;

public class JSliderPanel
extends JPanel
implements ChangeListener,
ActionListener {
    private JSlider s;
    private JFormattedTextField ftf;
    public final int INTEGER = 1;
    private NumberFormat numberFormat;

    public JSliderPanel(int min, int max, int start, int major, int minor, int type) {
        this.setLayout(new GridBagLayout());
        this.s = new JSlider(min, max, start);
        this.numberFormat = type == 1 ? NumberFormat.getIntegerInstance() : NumberFormat.getNumberInstance();
        NumberFormatter formatter = new NumberFormatter(this.numberFormat);
        formatter.setMinimum(new Integer(min));
        formatter.setMaximum(new Integer(max));
        this.ftf = new JFormattedTextField(formatter);
        this.ftf.setValue(new Integer(start));
        this.ftf.setColumns(5);
        this.s.setMajorTickSpacing(major);
        this.s.setMinorTickSpacing(minor);
        this.s.setPaintTicks(true);
        this.s.setPaintLabels(true);
        JGridBag.add(this, (Component)this.ftf, 0, 0, 1, 1);
        JGridBag.add(this, (Component)this.s, 1, 0, 1, 1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.ftf.isEditValid()) {
            Toolkit.getDefaultToolkit().beep();
            this.ftf.selectAll();
        } else {
            try {
                this.ftf.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        int fps = source.getValue();
        if (!source.getValueIsAdjusting()) {
            this.ftf.setValue(new Integer(fps));
        } else {
            this.ftf.setText(String.valueOf(fps));
        }
    }
}

