/*
 * Decompiled with CFR 0.152.
 */
package kim.awt.composite;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;
import kim.util.JGridBag;

public class JSliderIntegerPanel
extends JPanel
implements ActionListener,
ChangeListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private JSlider s;
    private JFormattedTextField ftf;
    private NumberFormat numberFormat;
    private int currentValue = 0;
    private int start = 0;
    protected ChangeEvent changeEvent = null;

    public JSliderIntegerPanel(int min, int max, int start, int major, int minor) {
        this.setLayout(new GridBagLayout());
        this.start = start;
        if (this.start > max) {
            this.start = max;
        }
        if (this.start < min) {
            this.start = min;
        }
        this.currentValue = this.start;
        this.s = new JSlider(min, max, this.start);
        this.numberFormat = NumberFormat.getIntegerInstance();
        NumberFormatter formatter = new NumberFormatter(this.numberFormat);
        formatter.setMinimum(new Integer(min));
        formatter.setMaximum(new Integer(max));
        this.ftf = new JFormattedTextField(formatter);
        this.ftf.setValue(new Integer(this.start));
        this.ftf.setColumns(5);
        this.s.setMajorTickSpacing(major);
        this.s.setMinorTickSpacing(minor);
        this.s.setPaintTicks(true);
        this.s.setPaintLabels(true);
        JGridBag.add(this, (Component)this.ftf, 0, 0, 1, 1);
        JGridBag.add(this, (Component)this.s, 1, 0, 1, 1);
        this.ftf.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("value".equals(e.getPropertyName())) {
                    Number value = (Number)e.getNewValue();
                    if (JSliderIntegerPanel.this.s != null && value != null) {
                        JSliderIntegerPanel.this.currentValue = value.intValue();
                        JSliderIntegerPanel.this.s.setValue(JSliderIntegerPanel.this.currentValue);
                    }
                    JSliderIntegerPanel.this.fireStateChanged();
                }
            }
        });
        this.s.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                int fps = source.getValue();
                if (!source.getValueIsAdjusting()) {
                    JSliderIntegerPanel.this.ftf.setValue(new Integer(fps));
                } else {
                    JSliderIntegerPanel.this.ftf.setText(String.valueOf(fps));
                }
                JSliderIntegerPanel.this.fireStateChanged();
            }
        });
    }

    public int getValue() {
        return this.currentValue;
    }

    public void setValue(int newValue) {
        this.s.setValue(newValue);
    }

    public void reset() {
        this.currentValue = this.start;
        this.s.setValue(this.currentValue);
        this.ftf.setText("" + this.currentValue);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        System.out.println("Action perfornmed");
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireStateChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireStateChanged();
    }
}

