/*
 * Decompiled with CFR 0.152.
 */
package kim.awt.button;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class JFileChooserButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private File dir;
    private FileFilter ff;
    private int type;
    private static boolean multiple;
    private File selectedFile;
    private File[] selectedFiles;
    private String name;

    public JFileChooserButton(String name, String CurrentDirectory, FileFilter ff, int type, boolean multiple) {
        this("...", name, new File(CurrentDirectory), ff, type, multiple);
    }

    public JFileChooserButton(String buttonText, String name, String CurrentDirectory, FileFilter ff, int type, boolean multiple) {
        this(buttonText, name, new File(CurrentDirectory), ff, type, multiple);
    }

    public JFileChooserButton(String name, File CurrentDirectory, FileFilter ff, int type, boolean multiple) {
        this("...", name, CurrentDirectory, ff, type, multiple);
    }

    public JFileChooserButton(String buttonText, String name, File CurrentDirectory, FileFilter ff, int type, boolean multiple) {
        super(buttonText);
        this.name = name;
        this.dir = CurrentDirectory;
        this.ff = ff;
        this.type = type;
        JFileChooserButton.multiple = multiple;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                JFileChooserButton.this.selectFile();
            }
        });
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public File[] getSelectedFiles() {
        return this.selectedFiles;
    }

    public void selectFile() {
        JFileChooser fc = new JFileChooser(this.dir);
        if (this.ff != null) {
            fc.setFileFilter(this.ff);
        }
        fc.setFileSelectionMode(this.type);
        fc.setApproveButtonText("Select");
        fc.setMultiSelectionEnabled(multiple);
        fc.setDialogTitle("Open file");
        fc.showOpenDialog(this);
        if (multiple && fc.getSelectedFiles() != null) {
            this.selectedFiles = fc.getSelectedFiles();
            this.dir = this.selectedFiles[0];
        } else if (!multiple && fc.getSelectedFile() != null) {
            this.dir = this.selectedFile = fc.getSelectedFile();
        } else {
            this.selectedFiles = null;
            this.selectedFile = null;
        }
        super.firePropertyChange(this.name, false, true);
    }

    public void setRootDir(File dir) {
        this.dir = dir;
    }
}

