/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.internal.toolkit.builders;

import com.javafx.tools.doclets.internal.toolkit.AnnotationTypeWriter;
import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.LayoutParser;
import com.javafx.tools.doclets.internal.toolkit.builders.XMLNode;
import com.javafx.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.PackageDoc;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;

public class AnnotationTypeBuilder
extends AbstractBuilder {
    public static final String ROOT = "AnnotationTypeDoc";
    private AnnotationTypeDoc annotationTypeDoc;
    private AnnotationTypeWriter writer;
    private Content contentTree;

    private AnnotationTypeBuilder(Configuration configuration) {
        super(configuration);
    }

    public static AnnotationTypeBuilder getInstance(Configuration configuration, AnnotationTypeDoc annotationTypeDoc, AnnotationTypeWriter writer) throws Exception {
        AnnotationTypeBuilder builder = new AnnotationTypeBuilder(configuration);
        builder.configuration = configuration;
        builder.annotationTypeDoc = annotationTypeDoc;
        builder.writer = writer;
        if (containingPackagesSeen == null) {
            containingPackagesSeen = new HashSet();
        }
        return builder;
    }

    public void build() throws IOException {
        this.build(LayoutParser.getInstance(this.configuration).parseXML(ROOT), this.contentTree);
    }

    public String getName() {
        return ROOT;
    }

    public void buildAnnotationTypeDoc(XMLNode node, Content contentTree) throws Exception {
        contentTree = this.writer.getHeader(this.configuration.getText("doclet.AnnotationType") + " " + this.annotationTypeDoc.name());
        Content annotationContentTree = this.writer.getAnnotationContentHeader();
        this.buildChildren(node, annotationContentTree);
        contentTree.addContent(annotationContentTree);
        this.writer.addFooter(contentTree);
        this.writer.printDocument(contentTree);
        this.writer.close();
        this.copyDocFiles();
    }

    private void copyDocFiles() {
        PackageDoc containingPackage = this.annotationTypeDoc.containingPackage();
        if (!(this.configuration.packages != null && Arrays.binarySearch(this.configuration.packages, containingPackage) >= 0 || containingPackagesSeen.contains(containingPackage.name()))) {
            Util.copyDocFiles(this.configuration, Util.getPackageSourcePath(this.configuration, this.annotationTypeDoc.containingPackage()) + DirectoryManager.getDirectoryPath(this.annotationTypeDoc.containingPackage()) + File.separator, "doc-files", true);
            containingPackagesSeen.add(containingPackage.name());
        }
    }

    public void buildAnnotationTypeInfo(XMLNode node, Content annotationContentTree) {
        Content annotationInfoTree = this.writer.getAnnotationInfoTreeHeader();
        this.buildChildren(node, annotationInfoTree);
        annotationContentTree.addContent(this.writer.getAnnotationInfo(annotationInfoTree));
    }

    public void buildDeprecationInfo(XMLNode node, Content annotationInfoTree) {
        this.writer.addAnnotationTypeDeprecationInfo(annotationInfoTree);
    }

    public void buildAnnotationTypeSignature(XMLNode node, Content annotationInfoTree) {
        StringBuffer modifiers = new StringBuffer(this.annotationTypeDoc.modifiers() + " ");
        this.writer.addAnnotationTypeSignature(Util.replaceText(modifiers.toString(), "interface", "@interface"), annotationInfoTree);
    }

    public void buildAnnotationTypeDescription(XMLNode node, Content annotationInfoTree) {
        this.writer.addAnnotationTypeDescription(annotationInfoTree);
    }

    public void buildAnnotationTypeTagInfo(XMLNode node, Content annotationInfoTree) {
        this.writer.addAnnotationTypeTagInfo(annotationInfoTree);
    }

    public void buildMemberSummary(XMLNode node, Content annotationContentTree) throws Exception {
        Content memberSummaryTree = this.writer.getMemberTreeHeader();
        this.configuration.getBuilderFactory().getMemberSummaryBuilder(this.writer).buildChildren(node, memberSummaryTree);
        annotationContentTree.addContent(this.writer.getMemberSummaryTree(memberSummaryTree));
    }

    public void buildAnnotationTypeMemberDetails(XMLNode node, Content annotationContentTree) {
        Content memberDetailsTree = this.writer.getMemberTreeHeader();
        this.buildChildren(node, memberDetailsTree);
        if (memberDetailsTree.isValid()) {
            Content memberDetails = this.writer.getMemberTreeHeader();
            this.writer.addAnnotationDetailsMarker(memberDetails);
            memberDetails.addContent(this.writer.getMemberTree(memberDetailsTree));
            annotationContentTree.addContent(this.writer.getMemberDetailsTree(memberDetails));
        }
    }

    public void buildAnnotationTypeOptionalMemberDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getAnnotationTypeOptionalMemberBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }

    public void buildAnnotationTypeRequiredMemberDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getAnnotationTypeRequiredMemberBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }
}

