/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html.markup;

import com.javafx.tools.doclets.formats.html.markup.HtmlAttr;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.RawHtml;
import com.javafx.tools.doclets.formats.html.markup.StringContent;
import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.util.DocletConstants;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class HtmlWriter
extends PrintWriter {
    protected final String htmlFilename;
    protected String winTitle;
    public static final String fileseparator = "/";
    protected Configuration configuration;
    protected boolean memberDetailsListPrinted;
    protected final String[] packageTableHeader;
    protected final String useTableSummary;
    protected final String modifierTypeHeader;
    public final Content overviewLabel;
    public final Content defaultPackageLabel;
    public final Content packageLabel;
    public final Content useLabel;
    public final Content prevLabel;
    public final Content nextLabel;
    public final Content prevclassLabel;
    public final Content nextclassLabel;
    public final Content summaryLabel;
    public final Content detailLabel;
    public final Content framesLabel;
    public final Content noframesLabel;
    public final Content treeLabel;
    public final Content classLabel;
    public final Content deprecatedLabel;
    public final Content deprecatedPhrase;
    public final Content allclassesLabel;
    public final Content indexLabel;
    public final Content helpLabel;
    public final Content seeLabel;
    public final Content descriptionLabel;
    public final Content prevpackageLabel;
    public final Content nextpackageLabel;
    public final Content packagesLabel;
    public final Content methodDetailsLabel;
    public final Content annotationTypeDetailsLabel;
    public final Content fieldDetailsLabel;
    public final Content propertyDetailsLabel;
    public final Content constructorDetailsLabel;
    public final Content enumConstantsDetailsLabel;
    public final Content specifiedByLabel;
    public final Content overridesLabel;
    public final Content descfrmClassLabel;
    public final Content descfrmInterfaceLabel;

    public HtmlWriter(Configuration configuration, String path, String filename, String docencoding) throws IOException, UnsupportedEncodingException {
        super(Util.genWriter(configuration, path, filename, docencoding));
        this.configuration = configuration;
        this.htmlFilename = filename;
        this.memberDetailsListPrinted = false;
        this.packageTableHeader = new String[]{configuration.getText("doclet.Package"), configuration.getText("doclet.Description")};
        this.useTableSummary = configuration.getText("doclet.Use_Table_Summary", configuration.getText("doclet.packages"));
        this.modifierTypeHeader = configuration.getText("doclet.0_and_1", configuration.getText("doclet.Modifier"), configuration.getText("doclet.Type"));
        this.overviewLabel = this.getResource("doclet.Overview");
        this.defaultPackageLabel = new RawHtml("&lt;Unnamed&gt;");
        this.packageLabel = this.getResource("doclet.Package");
        this.useLabel = this.getResource("doclet.navClassUse");
        this.prevLabel = this.getResource("doclet.Prev");
        this.nextLabel = this.getResource("doclet.Next");
        this.prevclassLabel = this.getResource("doclet.Prev_Class");
        this.nextclassLabel = this.getResource("doclet.Next_Class");
        this.summaryLabel = this.getResource("doclet.Summary");
        this.detailLabel = this.getResource("doclet.Detail");
        this.framesLabel = this.getResource("doclet.Frames");
        this.noframesLabel = this.getResource("doclet.No_Frames");
        this.treeLabel = this.getResource("doclet.Tree");
        this.classLabel = this.getResource("doclet.Class");
        this.deprecatedLabel = this.getResource("doclet.navDeprecated");
        this.deprecatedPhrase = this.getResource("doclet.Deprecated");
        this.allclassesLabel = this.getResource("doclet.All_Classes");
        this.indexLabel = this.getResource("doclet.Index");
        this.helpLabel = this.getResource("doclet.Help");
        this.seeLabel = this.getResource("doclet.See");
        this.descriptionLabel = this.getResource("doclet.Description");
        this.prevpackageLabel = this.getResource("doclet.Prev_Package");
        this.nextpackageLabel = this.getResource("doclet.Next_Package");
        this.packagesLabel = this.getResource("doclet.Packages");
        this.methodDetailsLabel = this.getResource("doclet.Method_Detail");
        this.annotationTypeDetailsLabel = this.getResource("doclet.Annotation_Type_Member_Detail");
        this.fieldDetailsLabel = this.getResource("doclet.Field_Detail");
        this.propertyDetailsLabel = this.getResource("doclet.Property_Detail");
        this.constructorDetailsLabel = this.getResource("doclet.Constructor_Detail");
        this.enumConstantsDetailsLabel = this.getResource("doclet.Enum_Constant_Detail");
        this.specifiedByLabel = this.getResource("doclet.Specified_By");
        this.overridesLabel = this.getResource("doclet.Overrides");
        this.descfrmClassLabel = this.getResource("doclet.Description_From_Class");
        this.descfrmInterfaceLabel = this.getResource("doclet.Description_From_Interface");
    }

    public Content getResource(String key) {
        return new StringContent(this.configuration.getText(key));
    }

    public Content getResource(String key, String a1) {
        return new RawHtml(this.configuration.getText(key, a1));
    }

    public Content getResource(String key, String a1, String a2) {
        return new RawHtml(this.configuration.getText(key, a1, a2));
    }

    public void html() {
        this.println("<HTML lang=\"" + this.configuration.getLocale().getLanguage() + "\">");
    }

    public void htmlEnd() {
        this.println("</HTML>");
    }

    protected void printWinTitleScript(String winTitle) {
        if (winTitle != null && winTitle.length() > 0) {
            this.script();
            this.println("function windowTitle()");
            this.println("{");
            this.println("    if (location.href.indexOf('is-external=true') == -1) {");
            this.println("        parent.document.title=\"" + winTitle + "\";");
            this.println("    }");
            this.println("}");
            this.scriptEnd();
            this.noScript();
            this.noScriptEnd();
        }
    }

    protected HtmlTree getWinTitleScript() {
        HtmlTree script = new HtmlTree(HtmlTag.SCRIPT);
        if (this.winTitle != null && this.winTitle.length() > 0) {
            script.addAttr(HtmlAttr.TYPE, "text/javascript");
            String scriptCode = "<!--" + DocletConstants.NL + "    if (location.href.indexOf('is-external=true') == -1) {" + DocletConstants.NL + "        parent.document.title=\"" + this.winTitle + "\";" + DocletConstants.NL + "    }" + DocletConstants.NL + "//-->" + DocletConstants.NL;
            RawHtml scriptContent = new RawHtml(scriptCode);
            script.addContent(scriptContent);
        }
        return script;
    }

    protected Content getFramesetJavaScript() {
        HtmlTree script = new HtmlTree(HtmlTag.SCRIPT);
        script.addAttr(HtmlAttr.TYPE, "text/javascript");
        String scriptCode = DocletConstants.NL + "    targetPage = \"\" + window.location.search;" + DocletConstants.NL + "    if (targetPage != \"\" && targetPage != \"undefined\")" + DocletConstants.NL + "        targetPage = targetPage.substring(1);" + DocletConstants.NL + "    if (targetPage.indexOf(\":\") != -1 || (targetPage != \"\" && !validURL(targetPage)))" + DocletConstants.NL + "        targetPage = \"undefined\";" + DocletConstants.NL + "    function validURL(url) {" + DocletConstants.NL + "        var pos = url.indexOf(\".html\");" + DocletConstants.NL + "        if (pos == -1 || pos != url.length - 5)" + DocletConstants.NL + "            return false;" + DocletConstants.NL + "        var allowNumber = false;" + DocletConstants.NL + "        var allowSep = false;" + DocletConstants.NL + "        var seenDot = false;" + DocletConstants.NL + "        for (var i = 0; i < url.length - 5; i++) {" + DocletConstants.NL + "            var ch = url.charAt(i);" + DocletConstants.NL + "            if ('a' <= ch && ch <= 'z' ||" + DocletConstants.NL + "                    'A' <= ch && ch <= 'Z' ||" + DocletConstants.NL + "                    ch == '$' ||" + DocletConstants.NL + "                    ch == '_') {" + DocletConstants.NL + "                allowNumber = true;" + DocletConstants.NL + "                allowSep = true;" + DocletConstants.NL + "            } else if ('0' <= ch && ch <= '9'" + DocletConstants.NL + "                    || ch == '-') {" + DocletConstants.NL + "                if (!allowNumber)" + DocletConstants.NL + "                     return false;" + DocletConstants.NL + "            } else if (ch == '/' || ch == '.') {" + DocletConstants.NL + "                if (!allowSep)" + DocletConstants.NL + "                    return false;" + DocletConstants.NL + "                allowNumber = false;" + DocletConstants.NL + "                allowSep = false;" + DocletConstants.NL + "                if (ch == '.')" + DocletConstants.NL + "                     seenDot = true;" + DocletConstants.NL + "                if (ch == '/' && seenDot)" + DocletConstants.NL + "                     return false;" + DocletConstants.NL + "            } else {" + DocletConstants.NL + "                return false;" + DocletConstants.NL + "            }" + DocletConstants.NL + "        }" + DocletConstants.NL + "        return true;" + DocletConstants.NL + "    }" + DocletConstants.NL + "    function loadFrames() {" + DocletConstants.NL + "        if (targetPage != \"\" && targetPage != \"undefined\")" + DocletConstants.NL + "             top.classFrame.location = top.targetPage;" + DocletConstants.NL + "    }" + DocletConstants.NL;
        RawHtml scriptContent = new RawHtml(scriptCode);
        script.addContent(scriptContent);
        return script;
    }

    public void script() {
        this.println("<SCRIPT type=\"text/javascript\">");
    }

    public void scriptEnd() {
        this.println("</SCRIPT>");
    }

    public void noScript() {
        this.println("<NOSCRIPT>");
    }

    public void noScriptEnd() {
        this.println("</NOSCRIPT>");
    }

    protected String getWindowTitleOnload() {
        if (this.winTitle != null && this.winTitle.length() > 0) {
            return " onload=\"windowTitle();\"";
        }
        return "";
    }

    public void body(String bgcolor, boolean includeScript) {
        this.print("<BODY BGCOLOR=\"" + bgcolor + "\"");
        if (includeScript) {
            this.print(this.getWindowTitleOnload());
        }
        this.println(">");
    }

    public HtmlTree getBody(boolean includeScript, String title) {
        HtmlTree body = new HtmlTree(HtmlTag.BODY);
        this.winTitle = title;
        if (includeScript) {
            body.addContent(this.getWinTitleScript());
            HtmlTree noScript = HtmlTree.NOSCRIPT(HtmlTree.DIV(this.getResource("doclet.No_Script_Message")));
            body.addContent(noScript);
        }
        return body;
    }

    public void bodyEnd() {
        this.println("</BODY>");
    }

    public void title() {
        this.println("<TITLE>");
    }

    public void title(String winTitle) {
        this.winTitle = winTitle;
        this.title();
    }

    public HtmlTree getTitle() {
        HtmlTree title = HtmlTree.TITLE(new StringContent(this.winTitle));
        return title;
    }

    public void titleEnd() {
        this.println("</TITLE>");
    }

    public void ul() {
        this.println("<UL>");
    }

    public void ulEnd() {
        this.println("</UL>");
    }

    public void li() {
        this.print("<LI>");
    }

    public void li(String type) {
        this.print("<LI TYPE=\"" + type + "\">");
    }

    public void h1() {
        this.println("<H1>");
    }

    public void h1End() {
        this.println("</H1>");
    }

    public void h1(String text) {
        this.h1();
        this.println(text);
        this.h1End();
    }

    public void h2() {
        this.println("<H2>");
    }

    public void h2(String text) {
        this.h2();
        this.println(text);
        this.h2End();
    }

    public void h2End() {
        this.println("</H2>");
    }

    public void h3() {
        this.println("<H3>");
    }

    public void h3(String text) {
        this.h3();
        this.println(text);
        this.h3End();
    }

    public void h3End() {
        this.println("</H3>");
    }

    public void h4() {
        this.println("<H4>");
    }

    public void h4End() {
        this.println("</H4>");
    }

    public void h4(String text) {
        this.h4();
        this.println(text);
        this.h4End();
    }

    public void h5() {
        this.println("<H5>");
    }

    public void h5End() {
        this.println("</H5>");
    }

    public void img(String imggif, String imgname, int width, int height) {
        this.println("<IMG SRC=\"images/" + imggif + ".gif\"" + " WIDTH=\"" + width + "\" HEIGHT=\"" + height + "\" ALT=\"" + imgname + "\">");
    }

    public void menu() {
        this.println("<MENU>");
    }

    public void menuEnd() {
        this.println("</MENU>");
    }

    public void pre() {
        this.println("<PRE>");
    }

    public void preNoNewLine() {
        this.print("<PRE>");
    }

    public void preEnd() {
        this.println("</PRE>");
    }

    public void hr() {
        this.println("<HR>");
    }

    public void hr(int size, int widthPercent) {
        this.println("<HR SIZE=\"" + size + "\" WIDTH=\"" + widthPercent + "%\">");
    }

    public void hr(int size, String noshade) {
        this.println("<HR SIZE=\"" + size + "\" NOSHADE>");
    }

    public String getStrong() {
        return "<STRONG>";
    }

    public String getStrongEnd() {
        return "</STRONG>";
    }

    public void strong() {
        this.print("<STRONG>");
    }

    public void strongEnd() {
        this.print("</STRONG>");
    }

    public void strong(String text) {
        this.strong();
        this.print(text);
        this.strongEnd();
    }

    public void italics(String text) {
        this.print("<I>");
        this.print(text);
        this.println("</I>");
    }

    public String italicsText(String text) {
        return "<i>" + text + "</i>";
    }

    public String codeText(String text) {
        return "<code>" + text + "</code>";
    }

    public void space() {
        this.print("&nbsp;");
    }

    public Content getSpace() {
        return RawHtml.nbsp;
    }

    public void dl() {
        this.println("<DL>");
    }

    public void dlEnd() {
        this.println("</DL>");
    }

    public void dt() {
        this.print("<DT>");
    }

    public void dtEnd() {
        this.print("</DT>");
    }

    public void dd() {
        this.print("<DD>");
    }

    public void ddEnd() {
        this.println("</DD>");
    }

    public void sup() {
        this.println("<SUP>");
    }

    public void supEnd() {
        this.println("</SUP>");
    }

    public void font(String size) {
        this.println("<FONT SIZE=\"" + size + "\">");
    }

    public void fontNoNewLine(String size) {
        this.print("<FONT SIZE=\"" + size + "\">");
    }

    public void fontStyle(String stylename) {
        this.print("<FONT CLASS=\"" + stylename + "\">");
    }

    public void fontSizeStyle(String size, String stylename) {
        this.println("<FONT size=\"" + size + "\" CLASS=\"" + stylename + "\">");
    }

    public void fontEnd() {
        this.print("</FONT>");
    }

    public String getFontColor(String color) {
        return "<FONT COLOR=\"" + color + "\">";
    }

    public String getFontEnd() {
        return "</FONT>";
    }

    public void center() {
        this.println("<CENTER>");
    }

    public void centerEnd() {
        this.println("</CENTER>");
    }

    public void aName(String name) {
        this.print("<A NAME=\"" + name + "\">");
    }

    public void aEnd() {
        this.print("</A>");
    }

    public void italic() {
        this.print("<I>");
    }

    public void italicEnd() {
        this.print("</I>");
    }

    public void anchor(String name, String content) {
        this.aName(name);
        this.print(content);
        this.aEnd();
    }

    public void anchor(String name) {
        this.anchor(name, "<!-- -->");
    }

    public void p() {
        this.println();
        this.println("<P>");
    }

    public void pEnd() {
        this.println();
        this.println("</P>");
    }

    public void br() {
        this.println();
        this.println("<BR>");
    }

    public void address() {
        this.println("<ADDRESS>");
    }

    public void addressEnd() {
        this.println("</ADDRESS>");
    }

    public void head() {
        this.println("<HEAD>");
    }

    public void headEnd() {
        this.println("</HEAD>");
    }

    public void code() {
        this.print("<CODE>");
    }

    public void codeEnd() {
        this.print("</CODE>");
    }

    public void em() {
        this.println("<EM>");
    }

    public void emEnd() {
        this.println("</EM>");
    }

    public void table(int border, String width, int cellpadding, int cellspacing) {
        this.println(DocletConstants.NL + "<TABLE BORDER=\"" + border + "\" WIDTH=\"" + width + "\" CELLPADDING=\"" + cellpadding + "\" CELLSPACING=\"" + cellspacing + "\" SUMMARY=\"\">");
    }

    public void table(int border, String width, int cellpadding, int cellspacing, String summary) {
        this.println(DocletConstants.NL + "<TABLE BORDER=\"" + border + "\" WIDTH=\"" + width + "\" CELLPADDING=\"" + cellpadding + "\" CELLSPACING=\"" + cellspacing + "\" SUMMARY=\"" + summary + "\">");
    }

    public void table(int border, int cellpadding, int cellspacing) {
        this.println(DocletConstants.NL + "<TABLE BORDER=\"" + border + "\" CELLPADDING=\"" + cellpadding + "\" CELLSPACING=\"" + cellspacing + "\" SUMMARY=\"\">");
    }

    public void table(int border, int cellpadding, int cellspacing, String summary) {
        this.println(DocletConstants.NL + "<TABLE BORDER=\"" + border + "\" CELLPADDING=\"" + cellpadding + "\" CELLSPACING=\"" + cellspacing + "\" SUMMARY=\"" + summary + "\">");
    }

    public void table(int border, String width) {
        this.println(DocletConstants.NL + "<TABLE BORDER=\"" + border + "\" WIDTH=\"" + width + "\" SUMMARY=\"\">");
    }

    public void table() {
        this.table(0, "100%");
    }

    public void tableEnd() {
        this.println("</TABLE>");
    }

    public void tr() {
        this.println("<TR>");
    }

    public void trEnd() {
        this.println("</TR>");
    }

    public void td() {
        this.print("<TD>");
    }

    public void tdNowrap() {
        this.print("<TD NOWRAP>");
    }

    public void tdWidth(String width) {
        this.print("<TD WIDTH=\"" + width + "\">");
    }

    public void tdEnd() {
        this.println("</TD>");
    }

    public void link(String str) {
        this.println("<LINK " + str + ">");
    }

    public void commentStart() {
        this.print("<!-- ");
    }

    public void commentEnd() {
        this.println("-->");
    }

    public void captionStyle(String stylename) {
        this.println("<CAPTION CLASS=\"" + stylename + "\">");
    }

    public void captionEnd() {
        this.println("</CAPTION>");
    }

    public void trBgcolorStyle(String color, String stylename) {
        this.println("<TR BGCOLOR=\"" + color + "\" CLASS=\"" + stylename + "\">");
    }

    public void trBgcolor(String color) {
        this.println("<TR BGCOLOR=\"" + color + "\">");
    }

    public void trAlignVAlign(String align, String valign) {
        this.println("<TR ALIGN=\"" + align + "\" VALIGN=\"" + valign + "\">");
    }

    public void thAlign(String align) {
        this.print("<TH ALIGN=\"" + align + "\">");
    }

    public void thScopeNoWrap(String stylename, String scope) {
        this.print("<TH CLASS=\"" + stylename + "\" SCOPE=\"" + scope + "\" NOWRAP>");
    }

    public String getModifierTypeHeader() {
        return this.modifierTypeHeader;
    }

    public void thAlignColspan(String align, int i) {
        this.print("<TH ALIGN=\"" + align + "\" COLSPAN=\"" + i + "\">");
    }

    public void thAlignNowrap(String align) {
        this.print("<TH ALIGN=\"" + align + "\" NOWRAP>");
    }

    public void thEnd() {
        this.println("</TH>");
    }

    public void tdColspan(int i) {
        this.print("<TD COLSPAN=" + i + ">");
    }

    public void tdBgcolorStyle(String color, String stylename) {
        this.print("<TD BGCOLOR=\"" + color + "\" CLASS=\"" + stylename + "\">");
    }

    public void tdColspanBgcolorStyle(int i, String color, String stylename) {
        this.print("<TD COLSPAN=" + i + " BGCOLOR=\"" + color + "\" CLASS=\"" + stylename + "\">");
    }

    public void tdAlign(String align) {
        this.print("<TD ALIGN=\"" + align + "\">");
    }

    public void tdVAlignClass(String align, String stylename) {
        this.print("<TD VALIGN=\"" + align + "\" CLASS=\"" + stylename + "\">");
    }

    public void tdVAlign(String valign) {
        this.print("<TD VALIGN=\"" + valign + "\">");
    }

    public void tdAlignVAlign(String align, String valign) {
        this.print("<TD ALIGN=\"" + align + "\" VALIGN=\"" + valign + "\">");
    }

    public void tdAlignRowspan(String align, int rowspan) {
        this.print("<TD ALIGN=\"" + align + "\" ROWSPAN=" + rowspan + ">");
    }

    public void tdAlignVAlignRowspan(String align, String valign, int rowspan) {
        this.print("<TD ALIGN=\"" + align + "\" VALIGN=\"" + valign + "\" ROWSPAN=" + rowspan + ">");
    }

    public void blockquote() {
        this.println("<BLOCKQUOTE>");
    }

    public void blockquoteEnd() {
        this.println("</BLOCKQUOTE>");
    }

    public String getCode() {
        return "<code>";
    }

    public String getCodeEnd() {
        return "</code>";
    }

    public void noFrames() {
        this.println("<NOFRAMES>");
    }

    public void noFramesEnd() {
        this.println("</NOFRAMES>");
    }
}

