/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.AbstractIndexWriter;
import com.javafx.tools.doclets.formats.html.ConfigurationImpl;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.StringContent;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.javafx.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.javafx.tools.doclets.internal.toolkit.util.IndexBuilder;
import java.io.IOException;

public class SplitIndexWriter
extends AbstractIndexWriter {
    protected int prev;
    protected int next;

    public SplitIndexWriter(ConfigurationImpl configuration, String path, String filename, String relpath, IndexBuilder indexbuilder, int prev, int next) throws IOException {
        super(configuration, path, filename, relpath, indexbuilder);
        this.prev = prev;
        this.next = next;
    }

    public static void generate(ConfigurationImpl configuration, IndexBuilder indexbuilder) {
        String filename = "";
        String path = DirectoryManager.getPath("index-files");
        String relpath = DirectoryManager.getRelativePath("index-files");
        try {
            for (int i = 0; i < indexbuilder.elements().length; ++i) {
                int j = i + 1;
                int prev = j == 1 ? -1 : i;
                int next = j == indexbuilder.elements().length ? -1 : j + 1;
                filename = "index-" + j + ".html";
                SplitIndexWriter indexgen = new SplitIndexWriter(configuration, path, filename, relpath, indexbuilder, prev, next);
                indexgen.generateIndexFile((Character)indexbuilder.elements()[i]);
                indexgen.close();
            }
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateIndexFile(Character unicode) throws IOException {
        String title = this.configuration.getText("doclet.Window_Split_Index", unicode.toString());
        HtmlTree body = this.getBody(true, this.getWindowTitle(title));
        this.addTop(body);
        this.addNavLinks(true, body);
        HtmlTree divTree = new HtmlTree(HtmlTag.DIV);
        divTree.addStyle(HtmlStyle.contentContainer);
        this.addLinksForIndexes(divTree);
        this.addContents(unicode, this.indexbuilder.getMemberList(unicode), divTree);
        this.addLinksForIndexes(divTree);
        ((Content)body).addContent(divTree);
        this.addNavLinks(false, body);
        this.addBottom(body);
        this.printHtmlDocument(null, true, body);
    }

    protected void addLinksForIndexes(Content contentTree) {
        Object[] unicodeChars = this.indexbuilder.elements();
        for (int i = 0; i < unicodeChars.length; ++i) {
            int j = i + 1;
            contentTree.addContent(this.getHyperLink("index-" + j + ".html", new StringContent(unicodeChars[i].toString())));
            contentTree.addContent(this.getSpace());
        }
    }

    public Content getNavLinkPrevious() {
        Content prevletterLabel = this.getResource("doclet.Prev_Letter");
        if (this.prev == -1) {
            return HtmlTree.LI(prevletterLabel);
        }
        Content prevLink = this.getHyperLink("index-" + this.prev + ".html", "", prevletterLabel);
        return HtmlTree.LI(prevLink);
    }

    public Content getNavLinkNext() {
        Content nextletterLabel = this.getResource("doclet.Next_Letter");
        if (this.next == -1) {
            return HtmlTree.LI(nextletterLabel);
        }
        Content nextLink = this.getHyperLink("index-" + this.next + ".html", "", nextletterLabel);
        return HtmlTree.LI(nextLink);
    }
}

