/*
 * Decompiled with CFR 0.152.
 */
package kim.math.alignment.util;

import commonSense.math.linear.Matrix;

public class AlignmentMatrices {
    public static Matrix[] createSpecimenMatrices(Matrix m) {
        return AlignmentMatrices.createSpecimenMatrices(m.getData());
    }

    public static Matrix[] createSpecimenMatrices(double[][] values) {
        int N = values.length;
        int LM = values[0].length / 2;
        Matrix[] m = new Matrix[N];
        for (int x = 0; x < N; ++x) {
            m[x] = new Matrix(LM, 2);
            for (int y = 0; y < LM; ++y) {
                m[x].setEntry(y, 0, values[x][y * 2]);
                m[x].setEntry(y, 1, values[x][y * 2 + 1]);
            }
        }
        return m;
    }

    public static Matrix combineSpecimenMatrices(Matrix[] m) {
        int N = m.length;
        int LM = m[0].getRowDimension();
        double[][] values = new double[N][LM * 2];
        for (int x = 0; x < N; ++x) {
            for (int y = 0; y < LM; ++y) {
                values[x][y * 2] = m[x].getEntry(y, 0);
                values[x][y * 2 + 1] = m[x].getEntry(y, 1);
            }
        }
        return new Matrix(values);
    }

    public static Matrix[] createLMMatrices(Matrix m) {
        return AlignmentMatrices.createLMMatrices(m.getData());
    }

    public static Matrix[] createLMMatrices(double[][] values) {
        int x;
        int N = values.length;
        int LM = values[0].length / 2;
        Matrix[] m = new Matrix[LM];
        for (x = 0; x < LM; ++x) {
            m[x] = new Matrix(N, 2);
        }
        for (x = 0; x < N; ++x) {
            for (int y = 0; y < LM; ++y) {
                m[y].setEntry(x, 0, values[x][y * 2]);
                m[y].setEntry(x, 1, values[x][y * 2 + 1]);
            }
        }
        return m;
    }

    public static Matrix combineLMMatrices(Matrix[] m) {
        int LM = m.length;
        int N = m[0].getRowDimension();
        double[][] values = new double[N][LM * 2];
        for (int x = 0; x < N; ++x) {
            for (int y = 0; y < LM; ++y) {
                values[x][y * 2] = m[y].getEntry(x, 0);
                values[x][y * 2 + 1] = m[y].getEntry(x, 1);
            }
        }
        return new Matrix(values);
    }
}

