/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.splining;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import kim.awt.button.JFileChooserButton;
import kim.awt.composite.JSliderIntegerPanel;
import kim.bin.bio.wings.GlobalVariables;
import kim.bin.bio.wings.LogFrame;
import kim.bin.bio.wings.WingsInternalFrame;
import kim.bin.bio.wings.fileTypes.CPXFile;
import kim.bin.bio.wings.individual.Individual;
import kim.bin.bio.wings.splining.SpliningParameterSet;
import kim.io.file.FileCopy;
import kim.util.JGridBag;

public class SpliningParameterFrame
extends WingsInternalFrame {
    private static final long serialVersionUID = 1L;
    private JLabel thresholdL = new JLabel("Threshold:");
    private JLabel openRadiusL = new JLabel("Open radius:");
    private JLabel strucElementL = new JLabel("Structural element height:");
    private JLabel fillSizeL = new JLabel("Fill size:");
    private JLabel shortCleanSegmentL = new JLabel("Short clean segment length:");
    private JLabel longCleanSegmentL = new JLabel("Long clean segment length:");
    private JSliderIntegerPanel openRadiusSlider = new JSliderIntegerPanel(0, 10, GlobalVariables.getInt("parameters.openRadius", 3), 5, 1);
    private JSliderIntegerPanel strucElementSlider = new JSliderIntegerPanel(0, 40, GlobalVariables.getInt("parameters.structElementHeight", 15), 10, 1);
    private JSliderIntegerPanel thresholdSlider = new JSliderIntegerPanel(0, 40, GlobalVariables.getInt("parameters.threshold", 7), 10, 1);
    private JSliderIntegerPanel fillSizeSlider = new JSliderIntegerPanel(0, 300, GlobalVariables.getInt("parameters.fillSize", 80), 100, 10);
    private JSliderIntegerPanel shortCleanSegmentSlider = new JSliderIntegerPanel(0, 40, GlobalVariables.getInt("parameters.shortClean", 5), 10, 1);
    private JSliderIntegerPanel longCleanSegmentSlider = new JSliderIntegerPanel(0, 40, GlobalVariables.getInt("parameters.longClean", 8), 10, 1);
    private JButton reset = new JButton("Reset parameters");
    private ButtonGroup frequentUsedSets = new ButtonGroup();
    private JRadioButton set1 = new JRadioButton(this.getSpliningParameterSet().toString());
    private JRadioButton set2 = new JRadioButton("");
    private JRadioButton set3 = new JRadioButton("");
    private JRadioButton set4 = new JRadioButton("");
    private JPanel parameterSetPanel = new JPanel(this.gb);
    private JLabel cp0ListL = new JLabel("Known master '.cp#' files:");
    public static final DefaultComboBoxModel cp0ListModel = new DefaultComboBoxModel();
    public JComboBox cp0List = new JComboBox(cp0ListModel);
    public JFileChooserButton cp0FileSelector = new JFileChooserButton("cp0File", GlobalVariables.workDirectory, (FileFilter)CPXFile.getFilter(), 2, false);
    private Individual currentIndividual = null;

    public SpliningParameterFrame() {
        super("Splining parameters");
        this.setResizable(true);
        this.cp0List.insertItemAt("Please select working directory", 0);
        this.cp0List.setSelectedIndex(0);
        this.frequentUsedSets.add(this.set1);
        this.frequentUsedSets.add(this.set2);
        this.frequentUsedSets.add(this.set3);
        this.frequentUsedSets.add(this.set4);
        JGridBag.add(this.parameterSetPanel, (Component)this.set1, 0, 0, 1, 1, 0, 0, 0, 0);
        JGridBag.add(this.parameterSetPanel, (Component)this.set2, 1, 0, 1, 1, 0, 0, 0, 0);
        JGridBag.add(this.parameterSetPanel, (Component)this.set3, 0, 1, 1, 1, 0, 0, 0, 0);
        JGridBag.add(this.parameterSetPanel, (Component)this.set4, 1, 1, 1, 1, 0, 0, 0, 0);
        JGridBag.add(this.content, (Component)this.cp0ListL, 0, 0, 1, 1, 15, 15, 0, 0);
        JGridBag.add(this.content, (Component)this.cp0List, 2, 0, 1, 1, 15, 0, 15, 0);
        JGridBag.add(this.content, (Component)this.cp0FileSelector, 3, 0, 1, 1, 15, 0, 15, 15);
        JGridBag.add(this.content, (Component)this.openRadiusL, 0, 1, 1, 1, 0, 15, 0, 0);
        JGridBag.add(this.content, (Component)this.openRadiusSlider, 2, 1, 2, 1, 0, 0, 15, 15);
        JGridBag.add(this.content, (Component)this.strucElementL, 0, 2, 1, 1, 0, 15, 0, 0);
        JGridBag.add(this.content, (Component)this.strucElementSlider, 2, 2, 2, 1, 0, 0, 15, 15);
        JGridBag.add(this.content, (Component)this.thresholdL, 0, 3, 1, 1, 0, 15, 0, 0);
        JGridBag.add(this.content, (Component)this.thresholdSlider, 2, 3, 2, 1, 0, 0, 15, 15);
        JGridBag.add(this.content, (Component)this.fillSizeL, 0, 4, 1, 1, 0, 15, 0, 0);
        JGridBag.add(this.content, (Component)this.fillSizeSlider, 2, 4, 2, 1, 0, 0, 15, 15);
        JGridBag.add(this.content, (Component)this.shortCleanSegmentL, 0, 5, 1, 1, 0, 15, 0, 0);
        JGridBag.add(this.content, (Component)this.shortCleanSegmentSlider, 2, 5, 2, 1, 0, 0, 15, 15);
        JGridBag.add(this.content, (Component)this.longCleanSegmentL, 0, 6, 1, 1, 0, 15, 0, 0);
        JGridBag.add(this.content, (Component)this.longCleanSegmentSlider, 2, 6, 2, 1, 0, 0, 15, 15);
        JGridBag.add(this.content, (Component)this.reset, 0, 8, 1, 1, 0, 15, 15, 15);
        this.set1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpliningParameterFrame.this.changeSettings(1);
            }
        });
        this.set2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpliningParameterFrame.this.changeSettings(2);
            }
        });
        this.set3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpliningParameterFrame.this.changeSettings(3);
            }
        });
        this.set4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpliningParameterFrame.this.changeSettings(4);
            }
        });
        this.reset.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SpliningParameterFrame.this.thresholdSlider.reset();
                SpliningParameterFrame.this.openRadiusSlider.reset();
                SpliningParameterFrame.this.strucElementSlider.reset();
                SpliningParameterFrame.this.fillSizeSlider.reset();
                SpliningParameterFrame.this.shortCleanSegmentSlider.reset();
                SpliningParameterFrame.this.longCleanSegmentSlider.reset();
            }
        });
        this.cp0FileSelector.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SpliningParameterFrame.this.changeCp0File();
            }
        });
        this.cp0List.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (GlobalVariables.workDirectoryLoaded) {
                    SpliningParameterFrame.this.loadMasterSpline();
                    SpliningParameterFrame.this.firePropertyChange("cp0Changed", null, GlobalVariables.cpMasterFile);
                }
            }
        });
        this.thresholdSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (SpliningParameterFrame.this.currentIndividual != null && ((SpliningParameterFrame)SpliningParameterFrame.this).currentIndividual.splineParameters.threshold != SpliningParameterFrame.this.thresholdSlider.getValue()) {
                    ((SpliningParameterFrame)SpliningParameterFrame.this).currentIndividual.splineParameters.threshold = SpliningParameterFrame.this.thresholdSlider.getValue();
                    SpliningParameterFrame.this.firePropertyChange("threshold", null, ((SpliningParameterFrame)SpliningParameterFrame.this).currentIndividual.splineParameters.threshold);
                }
            }
        });
        this.openRadiusSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (SpliningParameterFrame.this.currentIndividual != null && ((SpliningParameterFrame)SpliningParameterFrame.this).currentIndividual.splineParameters.openRadius != SpliningParameterFrame.this.openRadiusSlider.getValue()) {
                    ((SpliningParameterFrame)SpliningParameterFrame.this).currentIndividual.splineParameters.openRadius = SpliningParameterFrame.this.openRadiusSlider.getValue();
                    SpliningParameterFrame.this.firePropertyChange("openRadius", null, ((SpliningParameterFrame)SpliningParameterFrame.this).currentIndividual.splineParameters.openRadius);
                }
            }
        });
        this.strucElementSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (SpliningParameterFrame.this.currentIndividual != null && ((SpliningParameterFrame)SpliningParameterFrame.this).currentIndividual.splineParameters.structElementHeight != SpliningParameterFrame.this.strucElementSlider.getValue()) {
                    ((SpliningParameterFrame)SpliningParameterFrame.this).currentIndividual.splineParameters.structElementHeight = SpliningParameterFrame.this.strucElementSlider.getValue();
                    SpliningParameterFrame.this.firePropertyChange("structElementHeight", null, ((SpliningParameterFrame)SpliningParameterFrame.this).currentIndividual.splineParameters.structElementHeight);
                }
            }
        });
        this.fillSizeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (SpliningParameterFrame.this.currentIndividual != null && ((SpliningParameterFrame)SpliningParameterFrame.this).currentIndividual.splineParameters.fillSize != SpliningParameterFrame.this.fillSizeSlider.getValue()) {
                    ((SpliningParameterFrame)SpliningParameterFrame.this).currentIndividual.splineParameters.fillSize = SpliningParameterFrame.this.fillSizeSlider.getValue();
                    SpliningParameterFrame.this.firePropertyChange("fillSize", null, ((SpliningParameterFrame)SpliningParameterFrame.this).currentIndividual.splineParameters.fillSize);
                }
            }
        });
        this.shortCleanSegmentSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (SpliningParameterFrame.this.currentIndividual != null && ((SpliningParameterFrame)SpliningParameterFrame.this).currentIndividual.splineParameters.shortCleanSegment != SpliningParameterFrame.this.shortCleanSegmentSlider.getValue()) {
                    ((SpliningParameterFrame)SpliningParameterFrame.this).currentIndividual.splineParameters.shortCleanSegment = SpliningParameterFrame.this.shortCleanSegmentSlider.getValue();
                    SpliningParameterFrame.this.firePropertyChange("shortCleanSegment", null, ((SpliningParameterFrame)SpliningParameterFrame.this).currentIndividual.splineParameters.shortCleanSegment);
                }
            }
        });
        this.longCleanSegmentSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (SpliningParameterFrame.this.currentIndividual != null && ((SpliningParameterFrame)SpliningParameterFrame.this).currentIndividual.splineParameters.longCleanSegment != SpliningParameterFrame.this.longCleanSegmentSlider.getValue()) {
                    ((SpliningParameterFrame)SpliningParameterFrame.this).currentIndividual.splineParameters.longCleanSegment = SpliningParameterFrame.this.longCleanSegmentSlider.getValue();
                    SpliningParameterFrame.this.firePropertyChange("longCleanSegment", null, ((SpliningParameterFrame)SpliningParameterFrame.this).currentIndividual.splineParameters.longCleanSegment);
                }
            }
        });
        this.pack();
        this.setLocation(GlobalVariables.width - this.getWidth() - 15, 0);
        this.validate();
        this.setVisible(true);
    }

    public void setLocation() {
        this.setLocation(GlobalVariables.width - this.getWidth() - 15, 0);
    }

    private void changeSettings(int i) {
    }

    public void setIndividual(Individual ind) {
        this.currentIndividual = ind;
        if (!this.currentIndividual.hasIndividualSpliningParameters()) {
            this.currentIndividual.setDefaultParameters();
        }
        this.currentIndividual.ready = false;
        this.thresholdSlider.setValue(ind.splineParameters.threshold);
        this.openRadiusSlider.setValue(ind.splineParameters.openRadius);
        this.strucElementSlider.setValue(ind.splineParameters.structElementHeight);
        this.fillSizeSlider.setValue(ind.splineParameters.fillSize);
        this.shortCleanSegmentSlider.setValue(ind.splineParameters.shortCleanSegment);
        this.longCleanSegmentSlider.setValue(ind.splineParameters.longCleanSegment);
        this.currentIndividual.ready = true;
        this.firePropertyChange("IndividualSet", null, ind);
    }

    public void changeCp0File() {
        File addedCP0 = this.cp0FileSelector.getSelectedFile();
        if (addedCP0 != null) {
            LogFrame.log("Manually selected " + GlobalVariables.workDirectory);
            File newCP0 = this.cp0copy(addedCP0);
            if (newCP0 != null) {
                this.cp0List.insertItemAt(File.separator + newCP0.getName(), 1);
                this.cp0List.setSelectedIndex(1);
            }
        }
    }

    public File cp0copy(File source) {
        System.out.println("Add this file: " + source);
        String sourceDir = source.getParent();
        String sourceFilename = source.getName();
        File newCP0 = new File(GlobalVariables.workDirectory, sourceFilename);
        if (!GlobalVariables.workDirectory.toString().equals(sourceDir)) {
            System.out.println("Alien detected: assimilate");
            if (newCP0.exists()) {
                File newSelected;
                System.out.println("Alien detected: assimilation failed because of doubling");
                while (true) {
                    System.out.println("Alien detected: try to find new name!");
                    JFileChooser newName = new JFileChooser(GlobalVariables.workDirectory);
                    newName.setFileSelectionMode(0);
                    newName.setDialogTitle("Select a name for the new *.cpX file!");
                    newName.setFileFilter(CPXFile.getFilter());
                    newName.showSaveDialog(this);
                    newSelected = newName.getSelectedFile();
                    if (newSelected == null) continue;
                    String selected = newSelected.toString();
                    System.out.println("Selected file (1): " + selected);
                    if (selected.lastIndexOf(".cp0") == -1) {
                        selected = selected + ".cp0";
                        newSelected = new File(selected);
                    }
                    System.out.println("Selected file (2): " + selected);
                    if (!newSelected.exists()) break;
                    int result = JOptionPane.showInternalConfirmDialog(this, "Replace existing file?", "Confirmation requested", 1);
                    System.out.println(result);
                    if (result == 0) {
                        System.out.println("This is YES, does return null because the name has not changed");
                        FileCopy.plain(source, newSelected);
                        return null;
                    }
                    if (result == 2) {
                        System.out.println("This is CANCEL, exit dialog and do nothing");
                        return null;
                    }
                    System.out.println("This is NO, let it run again");
                }
                return FileCopy.plain(source, newSelected);
            }
            return FileCopy.plain(source, newCP0);
        }
        if (this.checkCP0(source) == -1) {
            return source;
        }
        return null;
    }

    public int checkCP0(File f) {
        return cp0ListModel.getIndexOf(f.toString());
    }

    public void loadMasterSpline() {
        try {
            GlobalVariables.cpMasterFile = GlobalVariables.workDirectory + (String)this.cp0List.getSelectedItem();
            if (GlobalVariables.cpMasterFile != null) {
                GlobalVariables.masterSplineGroup = CPXFile.read(new File(GlobalVariables.cpMasterFile), GlobalVariables.LMDefinition);
            }
        }
        catch (FileNotFoundException ex) {
            GlobalVariables.cpMasterFile = null;
            GlobalVariables.masterSplineGroup = null;
        }
        catch (IOException ex) {
            GlobalVariables.cpMasterFile = null;
            GlobalVariables.masterSplineGroup = null;
        }
        LogFrame.log("Selected \"" + GlobalVariables.cpMasterFile + "\" from the cp0List");
    }

    public SpliningParameterSet getSpliningParameterSet() {
        return new SpliningParameterSet(this.openRadiusSlider.getValue(), this.strucElementSlider.getValue(), this.thresholdSlider.getValue(), this.fillSizeSlider.getValue(), this.shortCleanSegmentSlider.getValue(), this.longCleanSegmentSlider.getValue());
    }

    public void setSpliningParameterSet(SpliningParameterSet sps) {
        this.thresholdSlider.setValue(sps.threshold);
        this.openRadiusSlider.setValue(sps.openRadius);
        this.strucElementSlider.setValue(sps.structElementHeight);
        this.fillSizeSlider.setValue(sps.fillSize);
        this.shortCleanSegmentSlider.setValue(sps.shortCleanSegment);
        this.longCleanSegmentSlider.setValue(sps.longCleanSegment);
    }
}

