/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.splining;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class ProfileCanvas
extends Canvas {
    private static final long serialVersionUID = 1L;
    double[][] data = null;
    int width = 0;
    int height = 0;
    Dimension d = new Dimension(this.width, this.height);
    int profile = -1;
    int line = -1;
    boolean rotated = false;

    public ProfileCanvas(double[][] energyData) {
        this(energyData, false);
    }

    public ProfileCanvas(double[][] energyData, boolean rotated) {
        this.data = energyData;
        this.rotated = rotated;
        if (rotated) {
            this.width = 100;
            this.height = energyData[0].length;
            this.d.setSize(this.width, this.height);
        } else {
            this.width = energyData.length;
            this.height = 100;
            this.d.setSize(this.width, this.height);
        }
        this.setPreferredSize(this.d);
        this.profile = this.height / 2;
        this.setVisible(true);
    }

    public void setPoint(int row, int column) {
        if (this.rotated) {
            this.profile = row;
            this.line = column;
        } else {
            this.profile = column;
            this.line = row;
        }
        this.repaint();
    }

    public void setRow(int row) {
        this.profile = row;
        this.repaint();
    }

    public void setColumn(int column) {
        this.profile = column;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.gray);
        g2.fillRect(0, 0, this.width, this.height);
        int no = this.rotated ? this.height : this.width;
        int[] xx = new int[no];
        int[] yy = new int[no];
        if (this.rotated) {
            for (int y = 0; y < this.height; ++y) {
                xx[y] = (int)(this.data[this.profile][y] / (260.0 / (double)this.width));
                yy[y] = y;
            }
        } else {
            for (int x = 0; x < this.width; ++x) {
                xx[x] = x;
                yy[x] = (int)(this.data[x][this.profile] / (260.0 / (double)this.height));
            }
        }
        g2.setColor(Color.white);
        g2.fillPolygon(xx, yy, no);
        g2.setColor(Color.black);
        g2.drawPolyline(xx, yy, no);
        g2.setColor(Color.red);
        if (this.rotated) {
            g2.drawLine(0, this.line, 100, this.line);
        } else {
            g2.drawLine(this.line, 0, this.line, 100);
        }
    }
}

