/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.splining;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import kim.image.advanced.convolutionkernels.KernelSizeException;

public class PixelProcessing {
    public static BufferedImage opening(BufferedImage image, int edge, double StructElemHeight) throws KernelSizeException {
        int q;
        int y;
        int p;
        int x;
        int i;
        int j;
        int kernelSize = 2 * edge + 1;
        int edgeSquare = edge * edge;
        int[][] kernel = new int[kernelSize][kernelSize];
        double x2 = 0.0;
        for (int x3 = -edge; x3 <= edge; ++x3) {
            x2 = x3 * x3;
            for (int y2 = -edge; y2 <= edge; ++y2) {
                kernel[x3 + edge][y2 + edge] = (int)(StructElemHeight * (1.0 - (x2 + (double)(y2 * y2)) / (double)edgeSquare) + 0.5);
            }
        }
        ColorModel cm = image.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster ras = image.copyData(null);
        DataBufferByte db = (DataBufferByte)ras.getDataBuffer();
        byte[] data = db.getData();
        int width = image.getWidth();
        int height = image.getHeight();
        int h = (int)(StructElemHeight + 0.5);
        int value = 0;
        int counter = 0;
        for (int q2 = 0; q2 < height; ++q2) {
            int p2 = 0;
            while (p2 < width) {
                value = data[counter] & 0xFF;
                data[counter] = value < h ? (byte)h : (value > 255 - h ? (byte)(255 - h) : (byte)value);
                ++p2;
                ++counter;
            }
        }
        WritableRaster rasNew = image.copyData(null);
        DataBufferByte dbNew = (DataBufferByte)rasNew.getDataBuffer();
        int[][] tempData = new int[height][width];
        int newVal = 1000;
        for (j = edge; j < height - edge; ++j) {
            for (i = edge; i < width - edge; ++i) {
                newVal = 1000;
                x = j - edge;
                p = 0;
                while (x <= j + edge) {
                    y = i - edge;
                    q = 0;
                    while (y <= i + edge) {
                        newVal = StrictMath.min(newVal, (data[x * width + y] & 0xFF) - kernel[p][q]);
                        ++y;
                        ++q;
                    }
                    ++x;
                    ++p;
                }
                tempData[j][i] = newVal;
            }
        }
        for (j = edge; j < height - edge; ++j) {
            for (i = edge; i < width - edge; ++i) {
                newVal = -1000;
                x = j - edge;
                p = 0;
                while (x <= j + edge) {
                    y = i - edge;
                    q = 0;
                    while (y <= i + edge) {
                        newVal = StrictMath.max(newVal, tempData[j][i] + kernel[p][q]);
                        ++y;
                        ++q;
                    }
                    ++x;
                    ++p;
                }
                dbNew.setElem(j * width + i, (byte)(data[j * width + i] - newVal));
            }
        }
        for (j = 0; j < edge; ++j) {
            for (i = 0; i < width; ++i) {
                dbNew.setElem(j * width + i, 0);
            }
        }
        for (j = height - edge; j < height; ++j) {
            for (i = 0; i < width; ++i) {
                dbNew.setElem(j * width + i, 0);
            }
        }
        for (j = 0; j < edge; ++j) {
            for (i = 0; i < height; ++i) {
                dbNew.setElem(j + i * width, 0);
            }
        }
        for (j = width - edge; j < width; ++j) {
            for (i = 0; i < height; ++i) {
                dbNew.setElem(j + i * width, 0);
            }
        }
        return new BufferedImage(cm, rasNew, isAlphaPremultiplied, null);
    }

    public static BufferedImage fillOpenHoles(BufferedImage image, int fillSize) {
        ColorModel cm = image.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster ras = image.copyData(null);
        DataBufferByte db = (DataBufferByte)ras.getDataBuffer();
        byte[] data = db.getData();
        int width = image.getWidth();
        int height = image.getHeight();
        int widthMinusOne = width - 1;
        int heightMinusOne = height - 1;
        for (int i = 0; i < height; ++i) {
            data[i * width] = 1;
            data[i * width + widthMinusOne] = 1;
        }
        for (int j = 1; j < widthMinusOne; ++j) {
            data[j] = 1;
            data[width * heightMinusOne + j] = 1;
        }
        int sf = 0;
        int sp = 0;
        int loc = 0;
        boolean wide = false;
        int ic = 0;
        int jc = 0;
        int fv = 0;
        int choles = 0;
        int cpics = 0;
        int[] stack = new int[200];
        int[] pfill = new int[200];
        for (int i = 1; i < heightMinusOne; ++i) {
            for (int j = 1; j < widthMinusOne; ++j) {
                loc = i * width + j;
                if (data[loc] != 0) continue;
                sp = 1;
                sf = 1;
                pfill[0] = stack[0] = loc;
                wide = false;
                while (sp > 0 && sf < fillSize) {
                    loc = stack[--sp];
                    ic = loc / width;
                    jc = loc % width;
                    data[ic * width + jc] = 2;
                    if (data[(ic - 1) * width + jc] == 0) {
                        int n = sf++;
                        int n2 = sp++;
                        int n3 = loc - width;
                        stack[n2] = n3;
                        pfill[n] = n3;
                    }
                    if (data[ic * width + jc - 1] == 0) {
                        int n = sf++;
                        int n4 = sp++;
                        int n5 = loc - 1;
                        stack[n4] = n5;
                        pfill[n] = n5;
                    }
                    if (data[ic * width + jc + 1] == 0) {
                        int n = sf++;
                        int n6 = sp++;
                        int n7 = loc + 1;
                        stack[n6] = n7;
                        pfill[n] = n7;
                    }
                    if (data[(ic + 1) * width + jc] == 0) {
                        int n = sf++;
                        int n8 = sp++;
                        int n9 = loc + width;
                        stack[n8] = n9;
                        pfill[n] = n9;
                    }
                    if (wide || data[(ic - 1) * width + jc] != 1 && data[ic * width + jc - 1] != 1 && data[ic * width + jc + 1] != 1 && data[(ic + 1) * width + jc] != 1) continue;
                    wide = true;
                }
                if (sp == 0 && !wide) {
                    fv = 255;
                    ++choles;
                    cpics += sf;
                } else {
                    fv = 1;
                }
                for (int k = 0; k < sf; ++k) {
                    db.setElem(pfill[k], (byte)fv);
                }
            }
        }
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            if (data[i] != 1) continue;
            db.setElem(i, 0);
        }
        return new BufferedImage(cm, ras, isAlphaPremultiplied, null);
    }

    public static BufferedImage skeleton(BufferedImage image) {
        ColorModel cm = image.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster ras = image.copyData(null);
        DataBufferByte db = (DataBufferByte)ras.getDataBuffer();
        byte[] data = db.getData();
        int[] intData = new int[data.length];
        for (int x = 0; x < data.length; ++x) {
            intData[x] = data[x] & 0xFF;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        boolean changed = false;
        int[] from = new int[height * width];
        int[] to = new int[height * width];
        int[] tempData = new int[height * width];
        int newpix = 0;
        int width_1 = width - 1;
        int height_1 = height - 1;
        long cpics = 0L;
        int max_steps = width > height ? width : height;
        for (int steps = 0; steps < max_steps; ++steps) {
            changed = false;
            for (int direction = 0; direction < 4; ++direction) {
                if (direction % 2 == 0) {
                    from = intData;
                    to = tempData;
                } else {
                    from = tempData;
                    to = intData;
                }
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int SW;
                        int NE;
                        int NW;
                        int E;
                        if (from[y * width + x] == 0) {
                            to[y * width + x] = 0;
                            continue;
                        }
                        int N = y > 0 ? from[(y - 1) * width + x] : 255;
                        int S = y < height_1 ? from[(y + 1) * width + x] : 255;
                        int W = x > 0 ? from[y * width + (x - 1)] : 255;
                        int n = E = x < width_1 ? from[y * width + (x + 1)] : 255;
                        int n2 = y > 0 ? (x > 0 ? from[(y - 1) * width + (x - 1)] : N) : (NW = W);
                        int n3 = y > 0 ? (x < width_1 ? from[(y - 1) * width + (x + 1)] : N) : (NE = E);
                        int n4 = y < height_1 ? (x > 0 ? from[(y + 1) * width + (x - 1)] : S) : (SW = W);
                        int SE = y < height_1 ? (x < width_1 ? from[(y + 1) * width + (x + 1)] : S) : E;
                        switch (direction) {
                            case 0: {
                                newpix = ~S | N | ~E & (~W | NE) | ~W & NW;
                                break;
                            }
                            case 1: {
                                newpix = ~W | E | ~S & (~N | SE) | ~N & NE;
                                break;
                            }
                            case 2: {
                                newpix = ~N | S | ~W & (~E | SW) | ~E & SE;
                                break;
                            }
                            case 3: {
                                newpix = ~E | W | ~N & (~S | NW) | ~S & SW;
                            }
                        }
                        to[y * width + x] = newpix;
                        if (newpix != 0) continue;
                        changed = true;
                        ++cpics;
                    }
                }
            }
            if (!changed) break;
        }
        for (int i = 0; i < data.length; ++i) {
            db.setElem(i, to[i]);
        }
        return new BufferedImage(cm, ras, isAlphaPremultiplied, null);
    }

    public static BufferedImage cleanup(BufferedImage image, int cleanUpSize) {
        int j;
        int i;
        int it;
        int k;
        int nb;
        int j2;
        int i2;
        ColorModel cm = image.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster ras = image.copyData(null);
        DataBufferByte db = (DataBufferByte)ras.getDataBuffer();
        byte[] data = db.getData();
        int[] intData = new int[data.length];
        for (int x = 0; x < data.length; ++x) {
            intData[x] = data[x] & 0xFF;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        boolean n = false;
        boolean s = false;
        boolean w = false;
        boolean e = false;
        boolean nw = false;
        boolean ne = false;
        boolean sw = false;
        boolean se = false;
        int[] di = new int[]{0, -1, -1, -1, 0, 1, 1, 1};
        int[] dj = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
        int cpics = 0;
        for (i2 = 1; i2 < height - 1; ++i2) {
            for (j2 = 1; j2 < width - 1; ++j2) {
                if (intData[i2 * width + j2] != 255) continue;
                nb = 0;
                for (k = 0; k < 8; ++k) {
                    if (intData[(i2 + di[k]) * width + (j2 + dj[k])] <= 0) continue;
                    ++nb;
                }
                if (nb <= 2) continue;
                intData[i2 * width + j2] = 254;
            }
        }
        for (it = 1; it <= cleanUpSize; ++it) {
            for (i = 1; i < height - 1; ++i) {
                for (j = 1; j < width - 1; ++j) {
                    if (intData[i * width + j] != 255) continue;
                    nb = 0;
                    for (k = 0; k < 8; ++k) {
                        if (intData[(i + di[k]) * width + (j + dj[k])] < it) continue;
                        ++nb;
                    }
                    if (nb > 1) continue;
                    intData[i * width + j] = it;
                }
            }
        }
        for (it = cleanUpSize; it >= 1; --it) {
            for (i = 1; i < height - 1; ++i) {
                for (j = 1; j < width - 1; ++j) {
                    if (intData[i * width + j] != it) continue;
                    nb = 0;
                    for (k = 0; k < 8; ++k) {
                        if (intData[(i + di[k]) * width + (j + dj[k])] != 255) continue;
                        ++nb;
                    }
                    if (nb <= 0) continue;
                    intData[i * width + j] = 255;
                }
            }
        }
        for (i2 = 1; i2 < height - 1; ++i2) {
            for (j2 = 1; j2 < width - 1; ++j2) {
                if (intData[i2 * width + j2] == 254) {
                    nb = 0;
                    for (k = 0; k < 8; ++k) {
                        if (intData[(i2 + di[k]) * width + (j2 + dj[k])] != 255) continue;
                        ++nb;
                        break;
                    }
                    if (nb == 0) {
                        intData[i2 * width + j2] = 0;
                        ++cpics;
                        continue;
                    }
                    intData[i2 * width + j2] = 255;
                    continue;
                }
                if (intData[i2 * width + j2] >= 254 || intData[i2 * width + j2] <= 0) continue;
                intData[i2 * width + j2] = 0;
                ++cpics;
            }
        }
        cpics = 0;
        int count = 1;
        while (count > 0) {
            count = 0;
            for (i2 = 1; i2 < height - 1; ++i2) {
                for (j2 = 1; j2 < width - 1; ++j2) {
                    if (intData[i2 * width + j2] != 1) continue;
                    nw = intData[(i2 - 1) * width + (j2 - 1)] == 1;
                    n = intData[(i2 - 1) * width + j2] == 1;
                    ne = intData[(i2 - 1) * width + (j2 + 1)] == 1;
                    w = intData[i2 * width + (j2 - 1)] == 1;
                    e = intData[i2 * width + (j2 + 1)] == 1;
                    sw = intData[(i2 + 1) * width + (j2 - 1)] == 1;
                    s = intData[(i2 + 1) * width + j2] == 1;
                    boolean bl = se = intData[(i2 + 1) * width + (j2 + 1)] == 1;
                    if (!(n && !sw && !s && !se && (nw || ne || e && w) || e && !nw && !w && !sw && (ne || se || n && s) || s && !nw && !n && !ne && (sw || se || e && w) || w && !ne && !e && !se && (nw || sw || n && s) || n && e && !w && !s && !sw || e && s && !w && !n && !nw || w && s && !n && !e && !ne) && (!w || !n || e || s || se)) continue;
                    intData[i2 * width + j2] = 0;
                    ++count;
                }
            }
            cpics += count;
        }
        for (i2 = 0; i2 < intData.length; ++i2) {
            db.setElem(i2, intData[i2]);
        }
        return new BufferedImage(cm, ras, isAlphaPremultiplied, null);
    }

    public static int[][] opening(int[][] data, int edge, double StructElemHeight) throws KernelSizeException {
        int q;
        int y;
        int p;
        int x;
        int i;
        int j;
        int kernelSize = 2 * edge + 1;
        int edgeSquare = edge * edge;
        int[][] kernel = new int[kernelSize][kernelSize];
        double x2 = 0.0;
        for (int x3 = -edge; x3 <= edge; ++x3) {
            x2 = x3 * x3;
            for (int y2 = -edge; y2 <= edge; ++y2) {
                kernel[x3 + edge][y2 + edge] = (int)(StructElemHeight * (1.0 - (x2 + (double)(y2 * y2)) / (double)edgeSquare) + 0.5);
            }
        }
        int rows = data.length;
        int columns = data[0].length;
        int[][] newData = new int[rows][columns];
        int h = (int)(StructElemHeight + 0.5);
        int value = 0;
        int counter = 0;
        for (int q2 = 0; q2 < rows; ++q2) {
            int p2 = 0;
            while (p2 < columns) {
                value = data[q2][p2];
                data[q2][p2] = value < h ? h : (value > 255 - h ? 255 - h : value);
                ++p2;
                ++counter;
            }
        }
        int[][] tempData = new int[rows][columns];
        int newVal = 1000;
        for (j = edge; j < rows - edge; ++j) {
            for (i = edge; i < columns - edge; ++i) {
                newVal = 1000;
                x = j - edge;
                p = 0;
                while (x <= j + edge) {
                    y = i - edge;
                    q = 0;
                    while (y <= i + edge) {
                        newVal = StrictMath.min(newVal, data[x][y] - kernel[p][q]);
                        ++y;
                        ++q;
                    }
                    ++x;
                    ++p;
                }
                tempData[j][i] = newVal;
            }
        }
        for (j = edge; j < rows - edge; ++j) {
            for (i = edge; i < columns - edge; ++i) {
                newVal = -1000;
                x = j - edge;
                p = 0;
                while (x <= j + edge) {
                    y = i - edge;
                    q = 0;
                    while (y <= i + edge) {
                        newVal = StrictMath.max(newVal, tempData[j][i] + kernel[p][q]);
                        ++y;
                        ++q;
                    }
                    ++x;
                    ++p;
                }
                newData[j][i] = data[j][i] - newVal;
            }
        }
        for (int i2 = 0; i2 <= edge; ++i2) {
            for (int j2 = 0; j2 < columns; ++j2) {
                newData[i2][j2] = 0;
                newData[rows - i2 - 1][j2] = 0;
            }
        }
        int t = rows - edge;
        for (i = edge; i < t; ++i) {
            for (int j3 = 0; j3 <= edge; ++j3) {
                newData[i][j3] = 0;
                newData[i][columns - j3 - 1] = 0;
            }
        }
        return newData;
    }

    public static int[][] fillOpenHoles(int[][] data, int fillSize) {
        int j;
        int i;
        int rows = data.length;
        int columns = data[0].length;
        int columnsMinusOne = columns - 1;
        int rowsMinusOne = rows - 1;
        for (int i2 = 0; i2 < rows; ++i2) {
            data[i2][0] = 1;
            data[i2][columnsMinusOne] = 1;
        }
        for (int j2 = 1; j2 < columnsMinusOne; ++j2) {
            data[0][j2] = 1;
            data[rowsMinusOne][j2] = 1;
        }
        int sf = 0;
        int sp = 0;
        int loc = 0;
        boolean wide = false;
        int ic = 0;
        int jc = 0;
        int fv = 0;
        int choles = 0;
        int cpics = 0;
        int[] stack = new int[1000];
        int[] pfill = new int[1000];
        for (i = 1; i < rows - 1; ++i) {
            for (j = 1; j < columns - 1; ++j) {
                if (data[i][j] != 0) continue;
                sp = 1;
                sf = 1;
                pfill[0] = stack[0] = (loc = i * columns + j);
                wide = false;
                while (sp > 0 && sf < fillSize) {
                    loc = stack[--sp];
                    ic = loc / columns;
                    jc = loc % columns;
                    data[ic][jc] = 2;
                    if (data[ic - 1][jc] == 0) {
                        int n = sf++;
                        int n2 = sp++;
                        int n3 = loc - columns;
                        stack[n2] = n3;
                        pfill[n] = n3;
                    }
                    if (data[ic][jc - 1] == 0) {
                        int n = sf++;
                        int n4 = sp++;
                        int n5 = loc - 1;
                        stack[n4] = n5;
                        pfill[n] = n5;
                    }
                    if (data[ic][jc + 1] == 0) {
                        int n = sf++;
                        int n6 = sp++;
                        int n7 = loc + 1;
                        stack[n6] = n7;
                        pfill[n] = n7;
                    }
                    if (data[ic + 1][jc] == 0) {
                        int n = sf++;
                        int n8 = sp++;
                        int n9 = loc + columns;
                        stack[n8] = n9;
                        pfill[n] = n9;
                    }
                    if (wide || data[ic - 1][jc] != 1 && data[ic][jc - 1] != 1 && data[ic][jc + 1] != 1 && data[ic + 1][jc] != 1) continue;
                    wide = true;
                }
                if (sp == 0 && !wide) {
                    fv = 255;
                    ++choles;
                    cpics += sf;
                } else {
                    fv = 1;
                }
                for (int k = 0; k < sf; ++k) {
                    ic = pfill[k] / columns;
                    jc = pfill[k] % columns;
                    data[ic][jc] = fv;
                }
            }
        }
        for (i = 0; i < rows; ++i) {
            for (j = 0; j < columns; ++j) {
                if (data[i][j] != 1) continue;
                data[i][j] = 0;
            }
        }
        return data;
    }

    public static int[][] skeleton(int[][] data) {
        int rows = data.length;
        int columns = data[0].length;
        boolean changed = false;
        int[][] from = new int[rows][columns];
        int[][] to = new int[rows][columns];
        int[][] tempData = new int[rows][columns];
        int newpix = 0;
        int columns_1 = columns - 1;
        int rows_1 = rows - 1;
        long cpics = 0L;
        int max_steps = columns > rows ? columns : rows;
        for (int steps = 0; steps < max_steps; ++steps) {
            changed = false;
            for (int direction = 0; direction < 4; ++direction) {
                if (direction % 2 == 0) {
                    from = data;
                    to = tempData;
                } else {
                    from = tempData;
                    to = data;
                }
                for (int y = 0; y < rows; ++y) {
                    for (int x = 0; x < columns; ++x) {
                        int SW;
                        int NE;
                        int NW;
                        int E;
                        if (from[y][x] == 0) {
                            to[y][x] = 0;
                            continue;
                        }
                        int N = y > 0 ? from[y - 1][x] : 255;
                        int S = y < rows_1 ? from[y + 1][x] : 255;
                        int W = x > 0 ? from[y][x - 1] : 255;
                        int n = E = x < columns_1 ? from[y][x + 1] : 255;
                        int n2 = y > 0 ? (x > 0 ? from[y - 1][x - 1] : N) : (NW = W);
                        int n3 = y > 0 ? (x < columns_1 ? from[y - 1][x + 1] : N) : (NE = E);
                        int n4 = y < rows_1 ? (x > 0 ? from[y + 1][x - 1] : S) : (SW = W);
                        int SE = y < rows_1 ? (x < columns_1 ? from[y + 1][x + 1] : S) : E;
                        switch (direction) {
                            case 0: {
                                newpix = ~S | N | ~E & (~W | NE) | ~W & NW;
                                break;
                            }
                            case 1: {
                                newpix = ~W | E | ~S & (~N | SE) | ~N & NE;
                                break;
                            }
                            case 2: {
                                newpix = ~N | S | ~W & (~E | SW) | ~E & SE;
                                break;
                            }
                            case 3: {
                                newpix = ~E | W | ~N & (~S | NW) | ~S & SW;
                            }
                        }
                        to[y][x] = newpix;
                        if (newpix != 0) continue;
                        changed = true;
                        ++cpics;
                    }
                }
            }
            if (!changed) break;
        }
        int[][] newData = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                newData[i][j] = to[i][j] & 0xFF;
            }
        }
        return newData;
    }

    public static int[][] cleanup(int[][] data, int cleanUpSize) {
        int j;
        int i;
        int it;
        int k;
        int nb;
        int j2;
        int i2;
        int rows = data.length;
        int columns = data[0].length;
        boolean n = false;
        boolean s = false;
        boolean w = false;
        boolean e = false;
        boolean nw = false;
        boolean ne = false;
        boolean sw = false;
        boolean se = false;
        int[] di = new int[]{0, -1, -1, -1, 0, 1, 1, 1};
        int[] dj = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
        int cpics = 0;
        for (i2 = 1; i2 < rows - 1; ++i2) {
            for (j2 = 1; j2 < columns - 1; ++j2) {
                if (data[i2][j2] != 255) continue;
                nb = 0;
                for (k = 0; k < 8; ++k) {
                    if (data[i2 + di[k]][j2 + dj[k]] <= 0) continue;
                    ++nb;
                }
                if (nb <= 2) continue;
                data[i2][j2] = 254;
            }
        }
        for (it = 1; it <= cleanUpSize; ++it) {
            for (i = 1; i < rows - 1; ++i) {
                for (j = 1; j < columns - 1; ++j) {
                    if (data[i][j] != 255) continue;
                    nb = 0;
                    for (k = 0; k < 8; ++k) {
                        if (data[i + di[k]][j + dj[k]] < it) continue;
                        ++nb;
                    }
                    if (nb > 1) continue;
                    data[i][j] = it;
                }
            }
        }
        for (it = cleanUpSize; it >= 1; --it) {
            for (i = 1; i < rows - 1; ++i) {
                for (j = 1; j < columns - 1; ++j) {
                    if (data[i][j] != it) continue;
                    nb = 0;
                    for (k = 0; k < 8; ++k) {
                        if (data[i + di[k]][j + dj[k]] != 255) continue;
                        ++nb;
                    }
                    if (nb <= 0) continue;
                    data[i][j] = 255;
                }
            }
        }
        for (i2 = 1; i2 < rows - 1; ++i2) {
            for (j2 = 1; j2 < columns - 1; ++j2) {
                if (data[i2][j2] == 254) {
                    nb = 0;
                    for (k = 0; k < 8; ++k) {
                        if (data[i2 + di[k]][j2 + dj[k]] != 255) continue;
                        ++nb;
                        break;
                    }
                    if (nb == 0) {
                        data[i2][j2] = 0;
                        ++cpics;
                        continue;
                    }
                    data[i2][j2] = 255;
                    continue;
                }
                if (data[i2][j2] >= 254 || data[i2][j2] <= 0) continue;
                data[i2][j2] = 0;
                ++cpics;
            }
        }
        cpics = 0;
        int count = 1;
        while (count > 0) {
            count = 0;
            for (i2 = 1; i2 < rows - 1; ++i2) {
                for (j2 = 1; j2 < columns - 1; ++j2) {
                    if (data[i2][j2] != 1) continue;
                    nw = data[i2 - 1][j2 - 1] == 1;
                    n = data[i2 - 1][j2] == 1;
                    ne = data[i2 - 1][j2 + 1] == 1;
                    w = data[i2][j2 - 1] == 1;
                    e = data[i2][j2 + 1] == 1;
                    sw = data[i2 + 1][j2 - 1] == 1;
                    s = data[i2 + 1][j2] == 1;
                    boolean bl = se = data[i2 + 1][j2 + 1] == 1;
                    if (!(n && !sw && !s && !se && (nw || ne || e && w) || e && !nw && !w && !sw && (ne || se || n && s) || s && !nw && !n && !ne && (sw || se || e && w) || w && !ne && !e && !se && (nw || sw || n && s) || n && e && !w && !s && !sw || e && s && !w && !n && !nw || w && s && !n && !e && !ne) && (!w || !n || e || s || se)) continue;
                    data[i2][j2] = 0;
                    ++count;
                }
            }
            cpics += count;
        }
        return data;
    }
}

