/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.splining;

import commonSense.math.curves.BSpline;
import commonSense.math.curves.BSplineMath;
import commonSense.math.linear.LineXD;
import commonSense.math.linear.PointXD;
import kim.bin.bio.wings.spline.Spline;
import kim.bin.bio.wings.spline.SplineGroup;
import kim.bin.bio.wings.splining.EnergyField;
import kim.image.advanced.convolutionkernels.KernelSizeException;

public class FitSplines {
    private static final long serialVersionUID = 1L;
    private static final int MAX_ITER = 100;
    private static final double ENERGY_EPS = 0.1;
    private static final double INIT_OMEGA = 0.002;
    private static final double T_OMEGA = 0.001;
    private static final double MIN_OMEGA = 1.0E-4;
    private static final double OVERSHOOT = 0.01;
    private static final int THRESHOLD = 2;
    private static final double EXP_RATE = 0.12;
    private static final int NP = 20;
    private double[][] gradient = new double[20][2];
    private double[][] c0 = new double[3][2];
    private double[][] c1 = new double[3][2];
    private double fx = 0.0;
    private double fy = 0.0;
    private EnergyField ef = null;
    private double[][] energyData = null;
    private LineXD baseLine = null;
    private SplineGroup splines = null;
    private PointXD[] userMarks = null;
    private SplineGroup newSplines = null;

    public FitSplines(int[][] imageData, SplineGroup splines, PointXD[] userMarks) throws KernelSizeException {
        this.splines = splines;
        this.userMarks = userMarks;
        this.baseLine = new LineXD(userMarks[1], userMarks[0]);
        this.ef = new EnergyField(imageData);
        this.energyData = this.ef.getEnergyData();
    }

    public SplineGroup fitSplines() throws KernelSizeException {
        int[] beginPointLocation = new int[]{-1, 0, 0, 0, 0, 0, 1, 2, 1};
        int[] endPointLocation = new int[]{-1, -1, -1, -1, 3, -1, 2, 3, 0};
        double[][] cut = new double[3][2];
        double[][] tempControl = new double[20][2];
        PointXD tempPoint = null;
        PointXD tempVector = null;
        this.newSplines = this.splines.copy();
        double[] distortions = this.newSplines.getSpline(0).getDistortions();
        double t0 = 0.0;
        double t1 = 1.0;
        cut[0][0] = 0.0;
        cut[0][1] = 0.0;
        cut[1][0] = (this.userMarks[0].getX() - this.userMarks[1].getX()) / (t1 - t0);
        cut[1][1] = (this.userMarks[0].getY() - this.userMarks[1].getY()) / (t1 - t0);
        cut[2][0] = this.userMarks[1].getX() - cut[1][0] * t0;
        cut[2][1] = this.userMarks[1].getY() - cut[1][1] * t0;
        double[][] tempC = new double[3][2];
        double tmpt = -1.0;
        int ncurves = this.newSplines.getNoSplines();
        for (int k = 0; k < ncurves; ++k) {
            int i;
            int noCp = this.newSplines.getSpline(k).getNoPoints();
            double[][] controlPointData = this.newSplines.getSpline(k).getData();
            tempControl = new double[controlPointData.length][2];
            if (beginPointLocation[k] < 0) {
                for (i = 0; i < 3; ++i) {
                    this.c0[i][0] = cut[i][0];
                    this.c0[i][1] = cut[i][1];
                }
                t0 = this.baseLine.getFraction(controlPointData[0][0], controlPointData[0][1]);
                tempPoint = this.baseLine.getPointOnLine(t0);
                tempControl[0][0] = tempPoint.getX();
                tempControl[0][1] = tempPoint.getY();
            } else {
                t0 = this.findsegment(this.newSplines.getSpline(beginPointLocation[k]), controlPointData[0][0], controlPointData[0][1], this.c0);
                tempVector = this.newSplines.getSpline(beginPointLocation[k]).getBSplineMath().findClosestPoint(controlPointData[0][0], controlPointData[0][1]);
                tempControl[0][0] = tempVector.getX();
                tempControl[0][1] = tempVector.getY();
            }
            if (endPointLocation[k] < 0) {
                for (i = 0; i < 3; ++i) {
                    this.c1[i][0] = cut[i][0];
                    this.c1[i][1] = cut[i][1];
                }
                t1 = this.baseLine.getFraction(controlPointData[noCp - 1][0], controlPointData[noCp - 1][1]);
                tempPoint = this.baseLine.getPointOnLine(t1);
                tempControl[noCp - 1][0] = tempPoint.getX();
                tempControl[noCp - 1][1] = tempPoint.getY();
            } else {
                t1 = this.findsegment(this.newSplines.getSpline(endPointLocation[k]), controlPointData[noCp - 1][0], controlPointData[noCp - 1][1], this.c1);
                tempVector = this.newSplines.getSpline(beginPointLocation[k]).getBSplineMath().findClosestPoint(controlPointData[noCp - 1][0], controlPointData[noCp - 1][1]);
                tempControl[noCp - 1][0] = tempVector.getX();
                tempControl[noCp - 1][1] = tempVector.getY();
            }
            if (k == 1) {
                tempC[0][0] = this.c0[0][0];
                tempC[1][0] = this.c0[1][0];
                tempC[2][0] = this.c0[2][0] - controlPointData[0][0];
                tempC[0][1] = this.c0[0][1];
                tempC[1][1] = this.c0[1][1];
                tempC[2][1] = this.c0[2][1] - controlPointData[0][1];
                tmpt = t0;
            } else if (k == 8) {
                this.c1[0][0] = tempC[0][0];
                this.c1[1][0] = tempC[1][0];
                this.c1[2][0] = tempC[2][0] + controlPointData[noCp - 1][0];
                this.c1[0][1] = tempC[0][1];
                this.c1[1][1] = tempC[1][1];
                this.c1[2][1] = tempC[2][1] + controlPointData[noCp - 1][1];
                t1 = tmpt;
            }
            for (int j = 0; j < 100; ++j) {
                double tw1;
                double tw0;
                double[] doubleTemp;
                int i2;
                double newEnergy;
                double omega = 0.002;
                double startEnergy = this.curveEnergyEvaluation(controlPointData);
                do {
                    for (i2 = 1; i2 < noCp - 1; ++i2) {
                        tempControl[i2][0] = controlPointData[i2][0] - omega * this.gradient[i2][0];
                        tempControl[i2][1] = controlPointData[i2][1] - omega * this.gradient[i2][1];
                    }
                    doubleTemp = this.qdprime(this.c0, t0);
                    double dt0 = this.gradient[0][0] * doubleTemp[0] + this.gradient[0][1] * doubleTemp[1];
                    tw0 = t0 - omega * dt0 * 0.001;
                    if (tw0 < -0.01) {
                        tw0 = -0.01;
                    } else if (tw0 > 1.01) {
                        tw0 = 1.01;
                    }
                    doubleTemp = this.qdeval(this.c0, tw0);
                    tempControl[0][0] = doubleTemp[0];
                    tempControl[0][1] = doubleTemp[1];
                    doubleTemp = this.qdprime(this.c1, t1);
                    double dt1 = this.gradient[noCp - 1][0] * doubleTemp[0] + this.gradient[noCp - 1][1] * doubleTemp[1];
                    tw1 = t1 - omega * dt1 * 0.001;
                    if (tw1 < -0.01) {
                        tw1 = -0.01;
                    } else if (tw1 > 1.01) {
                        tw1 = 1.01;
                    }
                    doubleTemp = this.qdeval(this.c1, tw1);
                    tempControl[noCp - 1][0] = doubleTemp[0];
                    tempControl[noCp - 1][1] = doubleTemp[1];
                } while ((newEnergy = this.curveEnergyEvaluation(tempControl)) >= startEnergy && (omega /= 2.0) > 1.0E-4);
                if ((tw0 < 0.0 || tw0 > 1.0) && beginPointLocation[k] >= 0) {
                    tw0 = this.findsegment(this.newSplines.getSpline(beginPointLocation[k]), tempControl[0][0], tempControl[0][1], this.c0);
                    doubleTemp = this.qdeval(this.c0, tw0);
                    tempControl[0][0] = doubleTemp[0];
                    tempControl[0][1] = doubleTemp[1];
                }
                if ((tw1 < 0.0 || tw1 > 1.0) && endPointLocation[k] >= 0 && k != 8) {
                    tw1 = this.findsegment(this.newSplines.getSpline(endPointLocation[k]), tempControl[noCp - 1][0], tempControl[noCp - 1][1], this.c1);
                    doubleTemp = this.qdeval(this.c1, tw1);
                    tempControl[noCp - 1][0] = doubleTemp[0];
                    tempControl[noCp - 1][1] = doubleTemp[1];
                }
                for (i2 = 0; i2 < noCp; ++i2) {
                    controlPointData[i2][0] = tempControl[i2][0];
                    controlPointData[i2][1] = tempControl[i2][1];
                }
                t0 = tw0;
                t1 = tw1;
                if (StrictMath.abs(newEnergy - startEnergy) < 0.1) break;
            }
            Spline sp = new Spline(controlPointData, distortions);
            this.newSplines.setSpline(k, new Spline(controlPointData, distortions));
        }
        return this.newSplines;
    }

    double findsegment(Spline spline, double x0, double y0, double[][] c) {
        double d;
        double pt = 0.0;
        int nsamps = 10;
        double dmin = 1000000.0;
        double xold = 0.0;
        double yold = 0.0;
        double xnew = 0.0;
        double ynew = 0.0;
        double a0 = 0.0;
        double b0 = 0.0;
        double a1 = 0.0;
        double b1 = 0.0;
        double a2 = 0.0;
        double b2 = 0.0;
        int noCp = spline.getNoPoints();
        double[][] cpData = spline.getData();
        double delta = 1.0 / (double)nsamps;
        for (int i = 1; i < noCp - 1; ++i) {
            double x1 = cpData[i - 1][0];
            double y1 = cpData[i - 1][1];
            double x2 = cpData[i][0];
            double y2 = cpData[i][1];
            double x3 = cpData[i + 1][0];
            double y3 = cpData[i + 1][1];
            if (i == 1) {
                x1 = 2.0 * x1 - x2;
                y1 = 2.0 * y1 - y2;
            }
            if (i == noCp - 2) {
                x3 = 2.0 * x3 - x2;
                y3 = 2.0 * y3 - y2;
            }
            a0 = 0.5 * (x1 + x3) - x2;
            b0 = 0.5 * (y1 + y3) - y2;
            a1 = x2 - x1;
            b1 = y2 - y1;
            a2 = 0.5 * (x1 + x2);
            b2 = 0.5 * (y1 + y2);
            xold = a2;
            yold = b2;
            if (i == 1) {
                pt = 0.0;
                dmin = StrictMath.hypot(x0 - xold, y0 - yold);
                c[0][0] = a0;
                c[1][0] = a1;
                c[2][0] = a2;
                c[0][1] = b0;
                c[1][1] = b1;
                c[2][1] = b2;
            }
            for (int j = 1; j <= nsamps; ++j) {
                double t = (double)j * delta;
                xnew = (a0 * t + a1) * t + a2;
                double dx = xnew - xold;
                ynew = (b0 * t + b1) * t + b2;
                double dy = ynew - yold;
                double r0 = ((x0 - xold) * dx + (y0 - yold) * dy) / (dx * dx + dy * dy);
                if (r0 > -0.001 && r0 < 1.001 && (d = StrictMath.abs((x0 - xold) * dy - (y0 - yold) * dx) / StrictMath.hypot(dx, dy)) < dmin) {
                    pt = ((double)(j - 1) + r0) * delta;
                    dmin = d;
                    c[0][0] = a0;
                    c[1][0] = a1;
                    c[2][0] = a2;
                    c[0][1] = b0;
                    c[1][1] = b1;
                    c[2][1] = b2;
                }
                if ((d = StrictMath.hypot(x0 - xold, y0 - yold)) < dmin) {
                    pt = (double)(j - 1) * delta;
                    dmin = d;
                    c[0][0] = a0;
                    c[1][0] = a1;
                    c[2][0] = a2;
                    c[0][1] = b0;
                    c[1][1] = b1;
                    c[2][1] = b2;
                }
                xold = xnew;
                yold = ynew;
            }
        }
        d = StrictMath.hypot(x0 - xold, y0 - yold);
        if (d < dmin) {
            pt = 1.0;
            c[0][0] = a0;
            c[1][0] = a1;
            c[2][0] = a2;
            c[0][1] = b0;
            c[1][1] = b1;
            c[2][1] = b2;
        }
        return pt;
    }

    double curveEnergyEvaluation(double[][] cpData) {
        int i;
        int msamp = 25;
        double sum = 0.0;
        double dt = 1.0 / (double)msamp;
        int np = cpData.length;
        for (i = 0; i < np; ++i) {
            this.gradient[i][0] = 0.0;
            this.gradient[i][1] = 0.0;
        }
        for (i = 1; i < np - 1; ++i) {
            for (int it = 0; it < msamp; ++it) {
                double t = (double)it * dt;
                double a = (1.0 - t) * (1.0 - t) / 2.0;
                double b = 0.5 + t - t * t;
                double c = t * t / 2.0;
                double a1 = t - 1.0;
                double b1 = 1.0 - 2.0 * t;
                double c1 = t;
                if (i == 1) {
                    b -= a;
                    a = 2.0 * a;
                    b1 -= a1;
                    a1 = 2.0 * a1;
                }
                if (i == np - 2) {
                    b -= c;
                    c = 2.0 * c;
                    b1 -= c1;
                    c1 = 2.0 * c1;
                }
                double x = cpData[i - 1][0] * a + cpData[i][0] * b + cpData[i + 1][0] * c;
                double y = cpData[i - 1][1] * a + cpData[i][1] * b + cpData[i + 1][1] * c;
                double x1 = cpData[i - 1][0] * a1 + cpData[i][0] * b1 + cpData[i + 1][0] * c1;
                double y1 = cpData[i - 1][1] * a1 + cpData[i][1] * b1 + cpData[i + 1][1] * c1;
                double pixelEnergy = this.pixelEnergyEvaluation(x, y);
                double ds = StrictMath.hypot(x1, y1);
                sum += pixelEnergy * ds;
                double[] dArray = this.gradient[i - 1];
                dArray[0] = dArray[0] + (this.fx * a * ds + pixelEnergy * x1 * a1 / ds);
                double[] dArray2 = this.gradient[i - 1];
                dArray2[1] = dArray2[1] + (this.fy * a * ds + pixelEnergy * y1 * a1 / ds);
                double[] dArray3 = this.gradient[i];
                dArray3[0] = dArray3[0] + (this.fx * b * ds + pixelEnergy * x1 * b1 / ds);
                double[] dArray4 = this.gradient[i];
                dArray4[1] = dArray4[1] + (this.fy * b * ds + pixelEnergy * y1 * b1 / ds);
                double[] dArray5 = this.gradient[i + 1];
                dArray5[0] = dArray5[0] + (this.fx * c * ds + pixelEnergy * x1 * c1 / ds);
                double[] dArray6 = this.gradient[i + 1];
                dArray6[1] = dArray6[1] + (this.fy * c * ds + pixelEnergy * y1 * c1 / ds);
            }
        }
        sum *= dt;
        for (i = 0; i < np; ++i) {
            double[] dArray = this.gradient[i];
            dArray[0] = dArray[0] * dt;
            double[] dArray7 = this.gradient[i];
            dArray7[1] = dArray7[1] * dt;
        }
        return sum;
    }

    double curveEnergyEvaluation(Spline spline, double[][] gradient, double[][] energyData) {
        BSplineMath bsm = spline.getBSplineMath();
        BSpline bs = spline.getBSpline();
        double length = bsm.curveLength();
        int noSamples = (int)length / 5;
        double t = 0.0;
        for (int x = 0; x < noSamples; ++x) {
            t = (double)x / (double)noSamples;
        }
        return 0.0;
    }

    double pixelEnergyEvaluation(PointXD point) {
        return this.pixelEnergyEvaluation(point.getX(), point.getY());
    }

    double pixelEnergyEvaluation(double x, double y) {
        int nc = this.energyData.length;
        int nr = this.energyData[0].length;
        int ix = (int)x;
        int iy = (int)y;
        double tx = x - (double)ix;
        double ty = y - (double)iy;
        if (iy < 0 || iy >= nr - 1 || ix < 0 || ix >= nc - 1) {
            this.fy = 0.0;
            this.fx = 0.0;
            return 255.0;
        }
        this.fx = (this.energyData[ix + 1][iy] - this.energyData[ix][iy]) * ty + (this.energyData[ix + 1][iy + 1] - this.energyData[ix][iy + 1]) * (1.0 - ty);
        this.fy = (this.energyData[ix][iy + 1] - this.energyData[ix][iy]) * tx + (this.energyData[ix + 1][iy + 1] - this.energyData[ix + 1][iy]) * (1.0 - tx);
        return (this.energyData[ix][iy] * (1.0 - tx) + this.energyData[ix + 1][iy] * tx) * (1.0 - ty) + (this.energyData[ix][iy + 1] * (1.0 - tx) + this.energyData[ix + 1][iy + 1] * tx) * ty;
    }

    private void print(double[][] values) {
        String temp = "";
        for (int x = 0; x < values.length; ++x) {
            temp = temp + values[x][0] + "\t" + values[x][1] + "\n";
        }
        System.out.println(temp);
    }

    private void print(double[] values) {
        System.out.println(values[0] + "\t" + values[1] + "\n");
    }

    private double[] qdeval(double[][] values, double x) {
        double[] temp = new double[]{(values[0][0] * x + values[1][0]) * x + values[2][0], (values[0][1] * x + values[1][1]) * x + values[2][1]};
        return temp;
    }

    private double[] qdprime(double[][] values, double x) {
        double[] temp = new double[]{2.0 * values[0][0] * x + values[1][0], 2.0 * values[0][1] * x + values[1][1]};
        return temp;
    }

    public static void wait(double n) {
        long t1;
        long t0 = System.currentTimeMillis();
        while ((double)((t1 = System.currentTimeMillis()) - t0) < n) {
        }
    }

    public SplineGroup getFitSplineGroup() {
        return this.newSplines;
    }
}

