/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.splining;

import commonSense.math.linear.Matrix;
import kim.image.advanced.convolutionkernels.KernelSizeException;

public class EnergyField
extends Matrix {
    private static final long serialVersionUID = 1L;
    double ExpRate = 0.12;
    int threshold = 2;
    int[][] intData = null;

    public EnergyField(int[][] inData) throws KernelSizeException {
        super(inData.length, inData[0].length);
        this.intData = new int[inData.length][inData[0].length];
        for (int x = 0; x < inData.length; ++x) {
            System.arraycopy(inData[x], 0, this.intData[x], 0, inData[0].length);
        }
        this.data = this.energize(this.intData);
    }

    public int[][] getEnergyDataInt() {
        int[][] out = new int[this.data.length][this.data[0].length];
        for (int x = 0; x < this.data.length; ++x) {
            for (int y = 0; y < this.data[0].length; ++y) {
                out[x][y] = (int)this.data[x][y];
                if (out[x][y] < 0) {
                    out[x][y] = 0;
                    continue;
                }
                if (out[x][y] <= 255) continue;
                out[x][y] = 255;
            }
        }
        return out;
    }

    public double[][] getEnergyData() {
        return this.copyOut();
    }

    private double[][] energize(int[][] data) throws KernelSizeException {
        int i;
        double[] energyTable = new double[256];
        double[][] work = new double[this.rows][this.columns];
        double[][] eData = new double[this.rows][this.columns];
        for (i = 0; i < 256; ++i) {
            energyTable[i] = i <= this.threshold ? 255.0 : 255.0 * StrictMath.exp(-this.ExpRate * (double)(i - this.threshold));
        }
        for (i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                eData[i][j] = energyTable[data[i][j]];
            }
        }
        int columnsMinusOne = this.columns - 1;
        int rowsMinusOne = this.rows - 1;
        for (int k = 0; k < 2; ++k) {
            work = EnergyField.averageSmoothing(eData, 3);
            for (int i2 = 0; i2 < work.length; ++i2) {
                work[i2][columnsMinusOne] = 255.0;
                work[i2][0] = 255.0;
            }
            for (int j = 0; j < work[0].length; ++j) {
                work[rowsMinusOne][j] = 255.0;
                work[0][j] = 255.0;
            }
            eData = EnergyField.averageSmoothing(work, 3);
        }
        return eData;
    }

    public static double[][] averageSmoothing(double[][] data, int kernelSize) throws KernelSizeException {
        if (kernelSize % 2 != 1) {
            throw new KernelSizeException();
        }
        int edge = (kernelSize - 1) / 2;
        int rowsMinusEdge = data.length - edge;
        int columnsMinusEdge = data[0].length - edge;
        double[][] smoothedData = new double[data.length][data[0].length];
        double sum = 0.0;
        for (int i = edge; i < rowsMinusEdge; ++i) {
            for (int j = edge; j < columnsMinusEdge; ++j) {
                for (int x = i - edge; x <= i + edge; ++x) {
                    for (int y = j - edge; y <= j + edge; ++y) {
                        sum += data[x][y];
                    }
                }
                smoothedData[i][j] = (sum + 4.0) / 9.0;
                sum = 0.0;
            }
        }
        return smoothedData;
    }

    public static double[][] averageSmoothing(int[][] data, int kernelSize) throws KernelSizeException {
        if (kernelSize % 2 != 1) {
            throw new KernelSizeException();
        }
        int edge = (kernelSize - 1) / 2;
        int rowsMinusEdge = data.length - edge;
        int columnsMinusEdge = data[0].length - edge;
        double[][] smoothedData = new double[data.length][data[0].length];
        double sum = 0.0;
        for (int i = edge; i < rowsMinusEdge; ++i) {
            for (int j = edge; j < columnsMinusEdge; ++j) {
                for (int x = i - edge; x <= i + edge; ++x) {
                    for (int y = j - edge; y <= j + edge; ++y) {
                        sum += (double)data[x][y];
                    }
                }
                smoothedData[i][j] = (sum + 4.0) / 9.0;
                sum = 0.0;
            }
        }
        return smoothedData;
    }
}

