/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.spline;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import kim.bin.bio.wings.GlobalVariables;
import kim.bin.bio.wings.spline.Spline;
import kim.bin.bio.wings.spline.SplineColorCanvas;
import kim.util.JGridBag;

public class SplinePropertyChoser
extends JPanel {
    private static final long serialVersionUID = 1L;
    private SplineColorCanvas scc;
    private Color c;
    private JButton changeColorButton;
    private JButton deleteButton;
    private ImageIcon down = new ImageIcon("images" + File.separatorChar + "color_wheel.png");
    private ImageIcon deleteIcon = new ImageIcon("images" + File.separatorChar + "delete16.png");
    private JLabel t;
    private JLabel noCp;
    private JSpinner noCpSpinner = new JSpinner();
    private Spline spline;
    private Dimension d = new Dimension(22, 22);
    private boolean editable = false;

    public SplinePropertyChoser(Color splineColor, final int splineNumber, Spline spline) {
        this.c = splineColor;
        this.spline = spline;
        this.noCp = new JLabel("" + spline.getNoPoints() + " cp");
        this.noCp.setPreferredSize(new Dimension(40, 25));
        this.t = new JLabel("Spline " + splineNumber);
        this.t.setFont(new Font(null, 0, 14));
        this.changeColorButton = new JButton(this.down);
        this.deleteButton = new JButton(this.deleteIcon);
        this.setLayout(new GridBagLayout());
        this.scc = new SplineColorCanvas(splineColor);
        this.changeColorButton.setPreferredSize(this.d);
        JGridBag.add(this, (Component)this.t, 0, 0, 1, 1);
        JGridBag.add(this, (Component)this.scc, 1, 0, 1, 1);
        JGridBag.add(this, (Component)this.changeColorButton, 3, 0, 1, 1);
        JGridBag.add(this, (Component)this.noCpSpinner, 2, 0, 1, 1);
        JGridBag.add(this, (Component)this.deleteButton, 4, 0, 1, 1);
        JGridBag.add(this, (Component)this.noCp, 2, 0, 1, 1);
        this.noCpSpinner.setVisible(this.editable);
        this.noCpSpinner.setValue(spline.getNoPoints());
        this.noCp.setVisible(!this.editable);
        this.deleteButton.setVisible(this.editable);
        this.changeColorButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Color newColor = JColorChooser.showDialog(SplinePropertyChoser.this, "Change color for spline", Color.BLACK);
                Color oldColor = GlobalVariables.colors[splineNumber];
                SplinePropertyChoser.this.scc.setColor(newColor);
                GlobalVariables.colors[splineNumber] = newColor;
                SplinePropertyChoser.this.firePropertyChange("SplineColorsChanged", oldColor, newColor);
            }
        });
    }

    public Color getColor() {
        return this.c;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.noCpSpinner.setVisible(editable);
        this.noCp.setVisible(!editable);
        this.deleteButton.setVisible(editable);
        this.validate();
    }
}

