/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.spline;

import commonSense.math.linear.Matrix;
import kim.bin.bio.wings.spline.Spline;

public class SplineGroup {
    private Spline[] splines;
    private String name = "";

    public SplineGroup() {
        this.name = "Time stamp: " + System.currentTimeMillis();
    }

    public SplineGroup(int noSplines) {
        this.splines = new Spline[noSplines];
        this.name = "Time stamp: " + System.currentTimeMillis();
    }

    public int getNoSplines() {
        return this.splines.length;
    }

    public void addSpline(Spline theSpline) {
        if (this.splines == null) {
            this.splines = new Spline[1];
            this.setSpline(0, theSpline);
        } else {
            this.addSpline(this.splines.length + 1, theSpline);
        }
    }

    public void addSpline(int location, Spline theSpline) {
        System.out.println(theSpline);
        if (this.splines == null) {
            this.splines = new Spline[location + 1];
            this.setSpline(location, theSpline);
        } else {
            Spline[] tempSplines = new Spline[this.splines.length + 1];
            System.arraycopy(this.splines, 0, tempSplines, 0, this.splines.length);
            tempSplines[this.splines.length] = theSpline;
            this.splines = tempSplines;
        }
    }

    public void setSpline(int location, Spline theSpline) {
        this.splines[location] = theSpline;
    }

    public Spline getSpline(int location) {
        return this.splines[location];
    }

    public SplineGroup copy() {
        SplineGroup s = new SplineGroup(this.splines.length);
        for (int x = 0; x < this.splines.length; ++x) {
            s.setSpline(x, this.splines[x].splineCopy());
        }
        return s;
    }

    public Matrix getSemiLandMarks(int splineNo, int numberOfSemiLandMarks, boolean distortionCorrection, boolean rotationCorrection) {
        return this.splines[splineNo].getSemiLandMarks(numberOfSemiLandMarks, distortionCorrection, rotationCorrection);
    }

    public String toLinearString() {
        return this.toLinearString("\t");
    }

    public Matrix toSemiLandmarkMatrix(int noPerCP) {
        double[][] gapData = new double[][]{{1000000.0, 1000000.0}};
        Matrix gap = new Matrix(gapData);
        Matrix out = this.getSemiLandMarks(0, this.splines[0].getRowDimension() * noPerCP, true, true);
        for (int x = 1; x < this.splines.length; ++x) {
            out = out.concatenateColumns(gap);
            out = out.concatenateColumns(this.getSemiLandMarks(x, this.splines[x].getRowDimension() * noPerCP, true, true));
        }
        return out;
    }

    public String toLinearString(String delim) {
        String out = "" + this.splines.length;
        for (int x = 0; x < this.splines.length; ++x) {
            out = out + delim + this.splines[x].toLinearString(delim);
        }
        return out;
    }

    public String toString() {
        String out = this.name + "\n\r" + this.splines.length + "\n\r";
        for (int x = 0; x < this.splines.length; ++x) {
            out = out + "" + this.splines[x].toString();
        }
        return out;
    }

    public SplineGroup getAffineTransformedCopy(Matrix uniform) {
        SplineGroup s = new SplineGroup(this.splines.length);
        for (int x = 0; x < this.splines.length; ++x) {
            s.setSpline(x, this.splines[x].getAffineTransformedCopy(uniform));
        }
        return s;
    }

    public int findClosestSpline(double x, double y) {
        double minDis = Double.MAX_VALUE;
        double dis = -1.0;
        int splineNo = -1;
        for (int i = 0; i < this.splines.length; ++i) {
            double[] d = this.splines[i].getBSplineMath().findClosestPoint(x, y).getCoordinates();
            dis = StrictMath.hypot(x - d[0], y - d[1]);
            if (!(dis < minDis)) continue;
            minDis = dis;
            splineNo = i;
        }
        return splineNo;
    }
}

