/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.spline;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import kim.bin.bio.wings.GlobalVariables;
import kim.bin.bio.wings.images.EditableImage;
import kim.bin.bio.wings.spline.Spline;
import kim.bin.bio.wings.spline.SplineGroup;
import kim.bin.bio.wings.spline.SplinePropertiesFrame;
import kim.bin.bio.wings.spline.SplinePropertyChoser;
import kim.image.ImageFile;
import kim.util.JGridBag;

public class MasterSplineGeneratorFrame
extends SplinePropertiesFrame {
    private static final long serialVersionUID = 1L;
    private EditableImage edit = null;
    private JScrollPane editPane = new JScrollPane();
    private JButton newSplineGroup = new JButton("Create new cpXfile");
    private JButton modify = new JButton("Modify model");
    private JButton newSpline = new JButton(this.newSplineIcon());
    private JButton addCP = new JButton(this.addControlPointIcon());
    private JButton endCP = new JButton(this.addEndPointIcon());
    private JButton normal = new JButton(this.normalIcon());
    private JButton linkSplines = new JButton(this.linkSplinesIcon());
    private String[] magnifications = new String[]{"100%", "125%", "150%", "175%", "200%", "225%", "250%", "275%", "300%", "325%", "350%", "375%", "400%", "425%", "450%", "475%", "500%"};
    private JComboBox scaling = new JComboBox<String>(this.magnifications);
    private JLabel scalingL = new JLabel("Magnification:");
    private static final Stroke LINE_STROKE = new BasicStroke(3.5f);

    public MasterSplineGeneratorFrame() {
        try {
            this.editMode = true;
            this.chooseImage();
            this.splineGroup = this.generateSplines(Integer.parseInt(JOptionPane.showInputDialog(this, (Object)"Please indicate initial number of splines (can be modified later)")));
            this.edit = new EditableImage();
            this.setDefaultCloseOperation(2);
            this.editPane.setViewportView(this.edit);
            this.getContentPane().setLayout(new GridBagLayout());
            JGridBag.add(this, (Component)this.editPane, 0, 1, 2, 1);
            JGridBag.add(this, (Component)this.scalingL, 0, 2, 1, 1);
            JGridBag.add(this, (Component)this.scaling, 1, 2, 1, 1);
            JGridBag.add(this, (Component)this.newSpline, 3, 0, 1, 1);
            JGridBag.add(this, (Component)this.addCP, 3, 1, 1, 1);
            JGridBag.add(this, (Component)this.endCP, 3, 2, 1, 1);
            JGridBag.add(this, (Component)this.normal, 3, 3, 1, 1);
            JGridBag.add(this, (Component)this.linkSplines, 3, 4, 1, 1);
            this.newSpline.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    try {
                        MasterSplineGeneratorFrame.this.addSpline(Integer.parseInt(JOptionPane.showInputDialog(MasterSplineGeneratorFrame.this, "How many control points?", "Add spline", 3)));
                    }
                    catch (NumberFormatException nfex) {
                        Logger.getLogger(MasterSplineGeneratorFrame.class.getName()).log(Level.SEVERE, null, nfex);
                    }
                }
            });
        }
        catch (IOException IOex) {
            Logger.getLogger(MasterSplineGeneratorFrame.class.getName()).log(Level.SEVERE, null, IOex);
        }
        this.setLocation(150, 0);
        this.setSize(500, 500);
        this.validate();
        this.pack();
        this.setVisible(true);
    }

    private void chooseImage() throws IOException, NullPointerException {
        JOptionPane.showMessageDialog(this, "Please select image file to be used for the master spline model generation.", "Master Spline Generator", 1);
        JFileChooser fileChooser = new JFileChooser();
        if (GlobalVariables.workDirectory != null) {
            fileChooser.setCurrentDirectory(GlobalVariables.workDirectory);
        }
        fileChooser.showOpenDialog(this);
        FileSeekableStream originalImageStream = new FileSeekableStream(fileChooser.getSelectedFile());
        this.imageDisplay.setImage(ImageFile.load((SeekableStream)originalImageStream, "tiff"));
    }

    private void increaseCapacity() {
        SplinePropertyChoser[] newLines = new SplinePropertyChoser[this.noSplines + 1];
        System.arraycopy(this.lines, 0, newLines, 0, this.noSplines);
        this.lines = newLines;
        ++this.noSplines;
    }

    private void addSpline(int rankOrder, Spline spline) {
        System.out.println(rankOrder + " " + this.noSplines);
        if (rankOrder > this.noSplines) {
            this.increaseCapacity();
        }
        System.out.println(rankOrder + " " + this.noSplines);
        this.splineGroup.addSpline(spline);
        this.lines[--rankOrder] = new SplinePropertyChoser(GlobalVariables.colors[rankOrder % GlobalVariables.colors.length], rankOrder, spline);
        JGridBag.add(this.content, (Component)this.lines[rankOrder], 2, rankOrder + 1, 1, 1);
        this.validate();
    }

    public void addSpline(int noCp) {
        double[][] rawData = new double[noCp][2];
        for (int i = 0; i < noCp; ++i) {
            rawData[i][0] = 5.0 * (double)i;
            rawData[i][1] = 5.0 * (double)i;
        }
        double[] distortions = new double[]{1.0, 1.0};
        this.addSpline(this.noSplines + 1, new Spline(rawData, distortions));
        this.imageDisplay.setEditMode(true);
        this.imageDisplay.setMagnification(2.5f);
        this.saveFile.setVisible(true);
        this.setSize(1200, 800);
        this.setLocation(15, 60);
        this.validate();
    }

    public SplineGroup generateSplines(int noSplines) {
        this.splineGroup = new SplineGroup(noSplines);
        if (this.splineGroup != null) {
            this.lines = new SplinePropertyChoser[noSplines];
            this.imageDisplay.setText("");
            double[][] tempCP = null;
            for (int i = 0; i < noSplines; ++i) {
                tempCP = new double[5][2];
                for (int j = 0; j < 5; ++j) {
                    tempCP[j][0] = (j + 1) * 25;
                    tempCP[j][1] = (i + 1) * 25;
                }
                this.splineGroup.setSpline(i, new Spline(tempCP, GlobalVariables.distortions));
                this.lines[i] = new SplinePropertyChoser(GlobalVariables.colors[i % GlobalVariables.colors.length], i, this.splineGroup.getSpline(i));
                this.lines[i].setEditable(true);
                JGridBag.add(this.content, (Component)this.lines[i], 2, i + 1, 1, 1, 0, 0, i == noSplines - 1 ? 25 : 0, 25);
                this.lines[i].addPropertyChangeListener("SplineColorsChanged", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        MasterSplineGeneratorFrame.this.imageDisplay.repaint();
                    }
                });
            }
        }
        this.imageDisplay.setSplineGroup(this.splineGroup, true);
        return this.splineGroup;
    }

    private ImageIcon newSplineIcon() {
        BufferedImage iconImage = new BufferedImage(25, 25, 2);
        Graphics2D g2 = (Graphics2D)iconImage.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(LINE_STROKE);
        g2.setColor(Color.black);
        g2.drawOval(2, 6, 12, 12);
        g2.fillRect(16, 11, 16, 4);
        g2.dispose();
        return new ImageIcon(iconImage);
    }

    private ImageIcon addControlPointIcon() {
        BufferedImage iconImage = new BufferedImage(25, 25, 2);
        Graphics2D g2 = (Graphics2D)iconImage.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(LINE_STROKE);
        g2.setColor(Color.black);
        g2.drawOval(6, 6, 12, 12);
        g2.fillRect(20, 11, 5, 4);
        g2.fillRect(0, 11, 6, 4);
        g2.dispose();
        return new ImageIcon(iconImage);
    }

    private ImageIcon addEndPointIcon() {
        BufferedImage iconImage = new BufferedImage(25, 25, 2);
        Graphics2D g2 = (Graphics2D)iconImage.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(LINE_STROKE);
        g2.setColor(Color.black);
        g2.drawLine(0, 13, 15, 13);
        g2.fillRect(14, 5, 5, 15);
        g2.dispose();
        return new ImageIcon(iconImage);
    }

    private ImageIcon normalIcon() {
        BufferedImage iconImage = new BufferedImage(25, 25, 2);
        Graphics2D g2 = (Graphics2D)iconImage.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(LINE_STROKE);
        g2.setColor(Color.black);
        g2.drawRect(1, 1, 8, 8);
        g2.dispose();
        return new ImageIcon(iconImage);
    }

    private ImageIcon linkSplinesIcon() {
        BufferedImage iconImage = new BufferedImage(25, 25, 2);
        Graphics2D g2 = (Graphics2D)iconImage.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(LINE_STROKE);
        g2.setColor(Color.black);
        g2.drawOval(6, 6, 12, 12);
        g2.fillRect(20, 11, 5, 4);
        g2.fillRect(0, 11, 6, 4);
        g2.fillRect(13, 15, 13, 25);
        g2.dispose();
        return new ImageIcon(iconImage);
    }
}

