/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.outliers;

import commonSense.math.linear.Matrix;
import commonSense.math.linear.PointXD;
import commonSense.math.linear.geometrics.DoubleProcrustes;
import commonSense.math.linear.geometrics.Geometrics;
import kim.bin.bio.wings.landmark.LandMarkDefinition;
import kim.bin.bio.wings.landmark.LandMarkExtractor;
import kim.bin.bio.wings.spline.SplineGroup;

public class SplineCheck {
    private SplineCheck() {
    }

    public static double evaluate(SplineGroup master, SplineGroup check, PointXD[] userMarks, LandMarkDefinition LMDef) {
        double[][] masterLandMarks = LandMarkExtractor.extractLandMarks(master, LMDef);
        double[][] masterUserMarks = LandMarkExtractor.extractUserMarks(master, LMDef);
        double[][] checkLandMarks = LandMarkExtractor.extractLandMarks(check, LMDef);
        Matrix[] landMarkMatrices = new Matrix[]{new Matrix(masterLandMarks), new Matrix(checkLandMarks)};
        Matrix[] userMarkMatrices = new Matrix[]{new Matrix(masterUserMarks), new Matrix(userMarks)};
        DoubleProcrustes bc = new DoubleProcrustes(userMarkMatrices, landMarkMatrices);
        Matrix[] result = bc.getShapeMatrices();
        return Geometrics.calculateProcrustesDistance(result[0], result[1]);
    }
}

