/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.landmark;

import kim.bin.bio.wings.spline.SplineLocationConstants;

public class LandMarkLocation
implements SplineLocationConstants {
    private int landMarkNo = -1;
    private int[] splineNo = new int[]{-1, -1};
    private int[] locationStatus = new int[]{-1, -1};
    private double[] parameters = new double[]{-1.0, -1.0};

    public LandMarkLocation(int LMNo) {
        this.landMarkNo = LMNo;
    }

    public void setLocation(int firstSpline, int firstSplineLocationStatus, int secondSpline, int secondSplineLocationStatus) {
        this.splineNo[0] = firstSpline;
        this.locationStatus[0] = firstSplineLocationStatus;
        if (firstSplineLocationStatus == 1) {
            this.parameters[0] = 1.0;
        }
        if (firstSplineLocationStatus == 0) {
            this.parameters[0] = 0.0;
        }
        this.splineNo[1] = secondSpline;
        this.locationStatus[1] = secondSplineLocationStatus;
        if (secondSplineLocationStatus == 1) {
            this.parameters[1] = 1.0;
        }
        if (secondSplineLocationStatus == 0) {
            this.parameters[0] = 0.0;
        }
    }

    public void setLocation(int firstSpline, int firstSplineLocationStatus) {
        this.splineNo[0] = firstSpline;
        this.splineNo[1] = -1;
        this.locationStatus[0] = firstSplineLocationStatus;
        this.locationStatus[1] = -1;
    }

    public boolean onSpline(int spline) {
        if (spline < 0) {
            return false;
        }
        return this.splineNo[0] == spline || this.splineNo[1] == spline;
    }

    public int[] noSplines() {
        return this.splineNo;
    }

    public int sameSpline(LandMarkLocation LMLocation) {
        int[] otherSplineNo = LMLocation.noSplines();
        if (otherSplineNo[0] > 0) {
            if (otherSplineNo[0] == this.splineNo[0]) {
                return this.splineNo[0];
            }
            if (otherSplineNo[0] == this.splineNo[1]) {
                return this.splineNo[1];
            }
        } else if (otherSplineNo[1] > 0) {
            if (otherSplineNo[1] == this.splineNo[0]) {
                return this.splineNo[0];
            }
            if (otherSplineNo[1] == this.splineNo[1]) {
                return this.splineNo[1];
            }
        }
        return -1;
    }

    public int getBeginLocationSplineNo() {
        if (this.locationStatus[0] == 0) {
            return this.splineNo[0];
        }
        if (this.locationStatus[1] == 0) {
            return this.splineNo[1];
        }
        return -1;
    }

    public int getEndLocationSplineNo() {
        if (this.locationStatus[0] == 1) {
            return this.splineNo[0];
        }
        if (this.locationStatus[1] == 1) {
            return this.splineNo[1];
        }
        return -1;
    }

    public int getMatchingSplineNo(int splineNumber) {
        if (this.splineNo[0] == splineNumber) {
            return this.splineNo[1];
        }
        if (this.splineNo[1] == splineNumber) {
            return this.splineNo[0];
        }
        return -1;
    }

    public boolean setParameter(double parameter, int splineNumber) {
        if (this.splineNo[0] == splineNumber) {
            this.parameters[0] = parameter;
            return true;
        }
        if (this.splineNo[1] == splineNumber) {
            this.parameters[1] = parameter;
            return true;
        }
        return false;
    }

    public double getParameter(int splineNumber) {
        if (this.splineNo[0] == splineNumber) {
            return this.parameters[0];
        }
        if (this.splineNo[1] == splineNumber) {
            return this.parameters[1];
        }
        return -1.0;
    }

    public void setLandMarkNumber(int LMNo) {
        this.landMarkNo = LMNo;
    }

    public int getLandMarkNumber() {
        return this.landMarkNo;
    }
}

