/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.landmark;

import kim.bin.bio.wings.individual.Individual;
import kim.bin.bio.wings.landmark.LandMarkDefinition;
import kim.bin.bio.wings.landmark.LandMarkLocation;
import kim.bin.bio.wings.landmark.LandMarks;
import kim.bin.bio.wings.spline.SplineGroup;

public class LandMarkExtractor {
    private Individual ind;

    public LandMarkExtractor(Individual ind) {
        this.ind = ind;
    }

    public LandMarks extractLandMarks() {
        LandMarkDefinition LMDef = this.ind.getLandMarkDefinition();
        SplineGroup splines = this.ind.getSplineGroup();
        return new LandMarks(this.ind.getLandMarkDefinition(), LandMarkExtractor.extractLandMarks(splines, LMDef), this.ind.getDistortions(), false, this.ind.getSide());
    }

    public static double[][] extractLandMarks(SplineGroup splines, LandMarkDefinition LMDef) {
        LandMarkLocation LMLoc = null;
        int point = -1;
        int points = LMDef.getNoLandMarks(false);
        double[][] data = new double[points][2];
        for (int x = 0; x < points; ++x) {
            LMLoc = LMDef.getLandMarkLocation(x, false);
            point = LMLoc.getBeginLocationSplineNo();
            if (point != -1) {
                data[x] = splines.getSpline(point).getBeginPoint();
                continue;
            }
            point = LMLoc.getEndLocationSplineNo();
            if (point != -1) {
                data[x] = splines.getSpline(point).getEndPoint();
                continue;
            }
            throw new Error("What the heck is going on here. Landmark " + x + " can not be extracted");
        }
        return data;
    }

    public static double[][] extractUserMarks(SplineGroup splines, LandMarkDefinition LMDef) {
        LandMarkLocation LMLoc = null;
        int point = -1;
        double[][] data = new double[2][2];
        for (int x = 0; x < 2; ++x) {
            LMLoc = LMDef.getUserMarkLocation(x);
            point = LMLoc.getBeginLocationSplineNo();
            if (point != -1) {
                data[x] = splines.getSpline(point).getBeginPoint();
                continue;
            }
            point = LMLoc.getEndLocationSplineNo();
            if (point != -1) {
                data[x] = splines.getSpline(point).getEndPoint();
                continue;
            }
            throw new Error("What the heck is going on here. Landmark " + x + " can not be extracted");
        }
        return data;
    }
}

