/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.landmark;

import kim.bin.bio.wings.landmark.LandMarkLocation;
import kim.bin.bio.wings.landmark.LandMarkSubset;

public class LandMarkDefinition {
    private int noLandMarks = 0;
    private LandMarkLocation[] locations;
    private String name = "";
    private LandMarkSubset subset;
    private LandMarkLocation[] userLocations;

    public LandMarkDefinition() {
        this.userLocations = new LandMarkLocation[2];
    }

    public LandMarkDefinition(int noLandMarks) {
        this.noLandMarks = noLandMarks;
        this.locations = new LandMarkLocation[noLandMarks];
        this.userLocations = new LandMarkLocation[2];
    }

    public LandMarkDefinition(LandMarkLocation[] locations) {
        this.noLandMarks = locations.length;
        this.locations = locations;
        this.userLocations = new LandMarkLocation[2];
    }

    public void setUserMarkLocation(int location, LandMarkLocation userLocation) {
        this.userLocations[location] = userLocation;
    }

    public LandMarkLocation getUserMarkLocation(int location) {
        return this.userLocations[location];
    }

    public LandMarkLocation[] getUserMarkLocations() {
        return this.userLocations;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setSubset(LandMarkSubset LMsubset) {
        this.subset = LMsubset;
    }

    public LandMarkSubset getSubset() {
        return this.subset;
    }

    public int getNoLandMarks() {
        return this.noLandMarks;
    }

    public int getNoLandMarks(boolean subsetOnly) {
        if (subsetOnly) {
            return this.subset.getNoLandMarks();
        }
        return this.noLandMarks;
    }

    public int getNoSubsetLandMarks() {
        return this.subset.getNoLandMarks();
    }

    public void setLMLocation(int location, LandMarkLocation LMLocation, boolean subsetNumbering) {
        if (subsetNumbering) {
            this.locations[this.subset.getLocation((int)location)] = LMLocation;
        } else {
            this.locations[location] = LMLocation;
        }
    }

    public LandMarkLocation getLandMarkLocation(int location, boolean subsetNumbering) {
        if (subsetNumbering) {
            return this.locations[this.subset.getLocation(location)];
        }
        return this.locations[location];
    }

    public String toString() {
        return this.name + " " + this.noLandMarks;
    }
}

