/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.individual;

import kim.bin.bio.wings.individual.Individual;

public class IndividualHeapSort {
    private double[] a;
    private Individual[] o;
    int sortWay = 0;

    public IndividualHeapSort(double[] sizes, Individual[] obj) {
        this.a = sizes;
        this.o = obj;
        this.heapify(this.a, this.o);
        for (int i = this.a.length - 1; i >= 0; --i) {
            this.deleteMax(i, this.a, this.o);
        }
    }

    public void sortDirection(int sortDirection) {
        if (this.sortWay != sortDirection) {
            this.sortWay = sortDirection;
            int num = this.a.length;
            Individual[] ind = new Individual[num];
            double[] sizes = new double[num];
            for (int x = 0; x < num; ++x) {
                ind[x] = this.o[num - 1 - x];
                sizes[x] = this.a[num - 1 - x];
            }
            this.o = ind;
            this.a = sizes;
        }
    }

    public double[] getSortedSizes() {
        return this.a;
    }

    public Individual[] getSortedIndividuals() {
        return this.o;
    }

    private void heapify(double[] a, Individual[] o) {
        for (int i = a.length / 2; i >= 0; --i) {
            this.bubbleDown(i, a, o, a.length - 1);
        }
    }

    private void bubbleDown(int i, double[] a, Individual[] o, int size) {
        double topSize = a[i];
        Individual topObject = o[i];
        int root = i;
        while (root * 2 + 1 <= size) {
            if (root * 2 + 1 == size || a[root * 2 + 1] > a[root * 2 + 2]) {
                if (a[root * 2 + 1] < topSize) break;
                a[root] = a[root * 2 + 1];
                o[root] = o[root * 2 + 1];
                root = root * 2 + 1;
                continue;
            }
            if (a[root * 2 + 2] < topSize) break;
            a[root] = a[root * 2 + 2];
            o[root] = o[root * 2 + 2];
            root = root * 2 + 2;
        }
        a[root] = topSize;
        o[root] = topObject;
    }

    private void deleteMax(int i, double[] a, Individual[] o) {
        this.swap(0, i, a, o);
        this.bubbleDown(0, a, o, i - 1);
    }

    private void swap(int i, int j, double[] a, Individual[] o) {
        double tempSize = a[i];
        a[i] = a[j];
        a[j] = tempSize;
        Individual tempObject = o[i];
        o[i] = o[j];
        o[j] = tempObject;
    }
}

