/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.individual;

import commonSense.math.linear.Matrix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import kim.bin.bio.wings.GlobalVariables;
import kim.bin.bio.wings.individual.Individual;
import kim.bin.bio.wings.individual.IndividualStatus;
import kim.bin.bio.wings.landmark.LandMarkDefinition;
import kim.bin.bio.wings.landmark.LandMarks;
import kim.bio.Sex;
import kim.math.Random;

public class IndividualGroup
extends LinkedHashMap<String, Individual>
implements Sex,
IndividualStatus {
    private static final long serialVersionUID = 1L;
    private int noIndividuals = 0;
    private int noImages = 0;
    private LandMarkDefinition LMDef;
    private LandMarks consensus = null;
    private int dim = 0;
    private String name = "";

    public IndividualGroup(LandMarkDefinition LMDefinition, int dim, String name) {
        this.name = name;
        this.LMDef = LMDefinition;
        this.dim = dim;
    }

    public IndividualGroup(int initialCapacity, LandMarkDefinition LMDefinition, int dim, String name) {
        super(initialCapacity);
        this.name = name;
        this.LMDef = LMDefinition;
        this.dim = dim;
    }

    @Override
    public void clear() {
        super.clear();
        this.noIndividuals = 0;
        this.consensus = null;
        this.noImages = 0;
        this.LMDef = null;
        this.dim = 0;
    }

    public Object remove(String key) {
        Individual o = (Individual)super.remove(key);
        --this.noIndividuals;
        return o;
    }

    @Override
    public Individual put(String key, Individual newInd) {
        GlobalVariables.sexes[newInd.sex()] = true;
        if (!this.containsKey(key)) {
            ++this.noIndividuals;
        }
        return super.put(key, newInd);
    }

    public int getImageCount() {
        return this.noImages;
    }

    public int totalNumber() {
        return this.noIndividuals;
    }

    public int getNoLandmarks(boolean subsetOnly) {
        return this.LMDef.getNoLandMarks(subsetOnly);
    }

    public String toString(boolean isExcluded, boolean isOutlier) {
        Iterator i = this.keySet().iterator();
        String data = this.name + ": ";
        while (i.hasNext()) {
            Individual ind = (Individual)this.get(i.next());
            if (ind.isRejected() || ind.isOutlier()) continue;
            data = data + ind.ID + "; ";
        }
        return data;
    }

    public Individual[] getSubset(int sex) {
        ArrayList<Individual> subset = new ArrayList<Individual>(10);
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            Individual ind = (Individual)this.get(i.next());
            if (ind.sex() != sex || !ind.isSplined() || ind.isRejected()) continue;
            subset.add(ind);
        }
        return IndividualGroup.toArray(subset);
    }

    private static Individual[] toArray(ArrayList<Individual> subset) {
        int length = subset.size();
        Individual[] i = new Individual[length];
        for (int a = 0; a < length; ++a) {
            i[a] = subset.get(a);
        }
        return i;
    }

    public Individual[] toArray() {
        Collection<Individual> c = this.values();
        int length = c.size();
        Individual[] ind = new Individual[length];
        Iterator<Individual> i = c.iterator();
        for (int a = 0; a < length; ++a) {
            ind[a] = i.next();
        }
        return ind;
    }

    public Matrix[] getRawLandmarkMatrices(boolean onlySubset, boolean distortionCorrection, boolean rotationCorrection) {
        return IndividualGroup.getRawLandmarkMatrices(this.toArray(), onlySubset, distortionCorrection, rotationCorrection);
    }

    public static Matrix[] getRawLandmarkMatrices(Individual[] inds, boolean onlySubset, boolean distortionCorrection, boolean rotationCorrection) {
        ArrayList<Individual> subsubset = new ArrayList<Individual>(10);
        int length = inds.length;
        for (int a = 0; a < length; ++a) {
            if (!inds[a].hasSplineGroup() || !inds[a].isSplined()) continue;
            subsubset.add(inds[a]);
        }
        length = subsubset.size();
        inds = IndividualGroup.toArray(subsubset);
        Matrix[] m = new Matrix[length];
        for (int a = 0; a < length; ++a) {
            m[a] = inds[a].getRawLandMarks().getCorrectedDataMatrix(onlySubset, distortionCorrection, rotationCorrection);
        }
        return m;
    }

    public static Matrix[] getSemiLandmarkMatrices(Individual[] inds, int splineNo, int numberOfSemiLandMarks, boolean distortionCorrection, boolean rotationCorrection) {
        ArrayList<Individual> subsubset = new ArrayList<Individual>(10);
        int length = inds.length;
        for (int a = 0; a < length; ++a) {
            if (!inds[a].hasSplineGroup() || !inds[a].isSplined()) continue;
            subsubset.add(inds[a]);
        }
        length = subsubset.size();
        inds = IndividualGroup.toArray(subsubset);
        Matrix[] m = new Matrix[length];
        for (int a = 0; a < length; ++a) {
            m[a] = inds[a].getSplineGroup().getSemiLandMarks(splineNo, numberOfSemiLandMarks, distortionCorrection, rotationCorrection);
        }
        return m;
    }

    @Override
    public Collection<Individual> values() {
        LinkedHashMap<String, Individual> c = new LinkedHashMap<String, Individual>(10);
        for (Individual ind : super.values()) {
            if (ind.isRejected()) continue;
            c.put(ind.ID, ind);
        }
        return c.values();
    }

    public void reset() {
        Iterator<Individual> i = this.values().iterator();
        while (i.hasNext()) {
            i.next().reset();
        }
    }

    public void saveAll() {
        Iterator<Individual> i = this.values().iterator();
        Object ind = null;
        while (i.hasNext()) {
            i.next().saveData(true);
        }
    }

    public IndividualGroup getFraction(double fraction) {
        IndividualGroup fractionInd = new IndividualGroup(this.LMDef, this.dim, "Fraction");
        int[] series = Random.seriesInt(this.size());
        int cutoff = (int)((double)this.size() * fraction);
        Individual[] individuals = this.toArray();
        for (int i = 0; i < series.length; ++i) {
            if (series[i] > cutoff) continue;
            fractionInd.put(individuals[i].ID, individuals[i]);
        }
        return fractionInd;
    }

    public boolean hasOutliers() {
        Individual[] individuals = this.toArray();
        for (int i = 0; i < individuals.length; ++i) {
            if (!individuals[i].isOutlier()) continue;
            return true;
        }
        return false;
    }

    public IndividualGroup getOutliers() {
        IndividualGroup outlierInd = new IndividualGroup(this.LMDef, this.dim, "Outliers");
        Individual[] individuals = this.toArray();
        for (int i = 0; i < individuals.length; ++i) {
            if (!individuals[i].isOutlier()) continue;
            outlierInd.put(individuals[i].ID, individuals[i]);
        }
        return outlierInd;
    }

    public int outlierCount() {
        int count = 0;
        Individual[] individuals = this.toArray();
        for (int i = 0; i < individuals.length; ++i) {
            if (!individuals[i].isOutlier()) continue;
            ++count;
        }
        return count;
    }

    public boolean hasUnsplinedIndividuals() {
        Individual[] individuals = this.toArray();
        for (int i = 0; i < individuals.length; ++i) {
            if (individuals[i].isSplined()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSplinedIndividuals() {
        Individual[] individuals = this.toArray();
        for (int i = 0; i < individuals.length; ++i) {
            if (!individuals[i].isSplined()) continue;
            return true;
        }
        return false;
    }

    public IndividualGroup getUnsplinedIndividuals() {
        IndividualGroup unsplinedInd = new IndividualGroup(this.LMDef, this.dim, "Unsplined");
        Individual[] individuals = this.toArray();
        for (int i = 0; i < individuals.length; ++i) {
            if (individuals[i].isSplined()) continue;
            unsplinedInd.put(individuals[i].ID, individuals[i]);
        }
        return unsplinedInd;
    }

    public int unsplinedCount() {
        int count = 0;
        Individual[] individuals = this.toArray();
        for (int i = 0; i < individuals.length; ++i) {
            if (individuals[i].isSplined()) continue;
            ++count;
        }
        return count;
    }

    public int splinedCount() {
        int count = 0;
        Individual[] individuals = this.toArray();
        for (int i = 0; i < individuals.length; ++i) {
            if (!individuals[i].isSplined()) continue;
            ++count;
        }
        return count;
    }

    public boolean hasUneditedIndividuals() {
        Individual[] individuals = this.toArray();
        for (int i = 0; i < individuals.length; ++i) {
            if (individuals[i].isEdited()) continue;
            return true;
        }
        return false;
    }

    public boolean hasEditedIndividuals() {
        Individual[] individuals = this.toArray();
        for (int i = 0; i < individuals.length; ++i) {
            if (!individuals[i].isEdited()) continue;
            return true;
        }
        return false;
    }

    public IndividualGroup getUneditedIndividuals() {
        IndividualGroup unEditedInd = new IndividualGroup(this.LMDef, this.dim, "Unsplined");
        Individual[] individuals = this.toArray();
        for (int i = 0; i < individuals.length; ++i) {
            if (individuals[i].isEdited()) continue;
            unEditedInd.put(individuals[i].ID, individuals[i]);
        }
        return unEditedInd;
    }

    public int uneditedCount() {
        int count = 0;
        Individual[] individuals = this.toArray();
        for (int i = 0; i < individuals.length; ++i) {
            if (individuals[i].isEdited()) continue;
            ++count;
        }
        return count;
    }

    public int editedCount() {
        int count = 0;
        Individual[] individuals = this.toArray();
        for (int i = 0; i < individuals.length; ++i) {
            if (!individuals[i].isEdited()) continue;
            ++count;
        }
        return count;
    }

    public boolean hasUnfinishedIndividuals() {
        Individual[] individuals = this.toArray();
        for (int i = 0; i < individuals.length; ++i) {
            if (individuals[i].isFinished()) continue;
            return true;
        }
        return false;
    }

    public boolean hasFinishedIndividuals() {
        Individual[] individuals = this.toArray();
        for (int i = 0; i < individuals.length; ++i) {
            if (!individuals[i].isFinished()) continue;
            return true;
        }
        return false;
    }

    public IndividualGroup getUnfinishedIndividuals() {
        IndividualGroup unFinishedInd = new IndividualGroup(this.LMDef, this.dim, "Unsplined");
        Individual[] individuals = this.toArray();
        for (int i = 0; i < individuals.length; ++i) {
            if (individuals[i].isFinished()) continue;
            unFinishedInd.put(individuals[i].ID, individuals[i]);
        }
        return unFinishedInd;
    }

    public int unfinishedCount() {
        int count = 0;
        Individual[] individuals = this.toArray();
        for (int i = 0; i < individuals.length; ++i) {
            if (individuals[i].isFinished()) continue;
            ++count;
        }
        return count;
    }

    public int finishedCount() {
        int count = 0;
        Individual[] individuals = this.toArray();
        for (int i = 0; i < individuals.length; ++i) {
            if (!individuals[i].isFinished()) continue;
            ++count;
        }
        return count;
    }
}

