/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.individual;

import commonSense.math.linear.PointXD;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import javax.media.jai.GraphicsJAI;
import kim.bin.bio.wings.GlobalVariables;
import kim.bin.bio.wings.fileTypes.CPFile;
import kim.bin.bio.wings.fileTypes.LandMarkDefinitionFile;
import kim.bin.bio.wings.images.DataToImage;
import kim.bin.bio.wings.landmark.LandMarkDefinition;
import kim.bin.bio.wings.landmark.LandMarkExtractor;
import kim.bin.bio.wings.landmark.LandMarks;
import kim.bin.bio.wings.outliers.OutlierType;
import kim.bin.bio.wings.spline.Spline;
import kim.bin.bio.wings.spline.SplineGroup;
import kim.bin.bio.wings.splining.SpliningParameterSet;
import kim.bin.bio.wings.util.Side;
import kim.bio.Sex;
import kim.image.ImageFile;

public class Individual
implements Sex,
Side,
OutlierType {
    private int side = 0;
    private PointXD[] userMarks = new PointXD[2];
    public double[] distortions = null;
    public double[] corrections = null;
    public double pixelToMmScaling = 0.0;
    private String wingCode = "";
    private int wingCodeNumber = 0;
    private String imageFileName = "";
    private int outlier = 0;
    private LandMarkDefinition LMDefinition;
    public String comment = "";
    public String ID = "";
    public String strainID = "";
    public String date = "";
    public String time = "";
    public int sex = 0;
    public String imagedBy = "";
    public String splinedBy = "";
    public double centroidSize = 0.0;
    public double MD = 0.0;
    private boolean wingFileExists = false;
    private boolean imageFileExists = false;
    private boolean cpFileExists = false;
    private double imageScaler = 1.0;
    private int[][] rawData = null;
    public int dim = 0;
    public int splineVersion = 0;
    private SplineGroup fittedSplines = null;
    public SplineGroup masterSplines = null;
    public String cpMasterFile = null;
    public Stack<SplineGroup> splineStack = new Stack();
    public int isOutlier = 0;
    public SpliningParameterSet splineParameters = new SpliningParameterSet();
    public double procrustesDistance;
    private boolean hasIndividualSpliningParameters = false;
    public boolean isDebugged = false;
    public boolean ready = false;
    private boolean rejected = false;
    private boolean userDataLoaded = false;
    private boolean imageLoaded = false;
    private boolean isSplined = false;
    private boolean isEdited = false;
    private boolean isFinished = false;
    private boolean MVEPerformed = false;

    public Individual(LandMarkDefinition LandMarkDef, int dimension) {
        this.LMDefinition = LandMarkDef;
        this.dim = dimension;
        this.distortions = new double[this.dim];
        this.distortions[0] = 1.0;
        this.distortions[1] = 0.986;
        for (int x = 2; x < this.dim; ++x) {
            this.distortions[x] = 1.0;
        }
    }

    public void setDistortions(double[] dis) {
        System.arraycopy(dis, 0, this.distortions, 0, dis.length);
    }

    public LandMarkDefinition getLandMarkDefinition() {
        return this.LMDefinition;
    }

    public int getNoLandMarks() {
        return this.LMDefinition.getNoLandMarks();
    }

    public boolean setImageFile(String imageFileName) {
        this.imageFileName = imageFileName;
        if (new File(GlobalVariables.workDirectory, File.separator + imageFileName).exists()) {
            this.imageFileExists = true;
            return true;
        }
        this.imageFileExists = false;
        return false;
    }

    public boolean imageFileExists() {
        return this.imageFileExists;
    }

    public int getSide() {
        return this.side;
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public String getWingCode() {
        return this.wingCode;
    }

    public int getWingCodeNumber() {
        return Integer.parseInt(this.wingCode.substring(4, 8));
    }

    public void setWingCodeNumber(int num) {
        this.wingCodeNumber = num;
    }

    public boolean setWingCode(String wingCode) {
        int last = wingCode.indexOf(46);
        last = last == -1 ? wingCode.length() : last;
        this.wingCode = wingCode.substring(0, last);
        try {
            this.wingCodeNumber = Integer.parseInt(wingCode.substring(4, 8));
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return this.fileCheck();
    }

    private boolean fileCheck() {
        this.wingFileExists = new File(GlobalVariables.workDirectory, File.separator + this.wingCode + ".tif").exists() || new File(GlobalVariables.workDirectory, File.separator + "wing" + this.wingCodeNumber + ".tif").exists();
        this.cpFileExists = new File(GlobalVariables.workDirectory, File.separator + this.wingCode + ".cp").exists() || new File(GlobalVariables.workDirectory, File.separator + "wing" + this.wingCodeNumber + ".cp").exists();
        return this.wingFileExists && this.cpFileExists;
    }

    public void setUserMarkCoordinates(PointXD firstPoint, PointXD secondPoint) {
        this.userMarks[0] = firstPoint;
        this.userMarks[1] = secondPoint;
        if (this.userMarks[0].getY() > this.userMarks[1].getY()) {
            this.side = 1;
            System.out.println(this.ID + " is upside down");
        }
    }

    public String getUserMarkCoordinates(boolean scaled, boolean rotationCorrection, String delimiter) {
        double scaler = scaled ? this.imageScaler : 1.0;
        int rotation = rotationCorrection ? -this.side * 480 : 0;
        return "" + this.userMarks[0].getX() / scaler + delimiter + (this.userMarks[0].getY() - (double)rotation) / scaler + delimiter + this.userMarks[1].getX() / scaler + delimiter + (this.userMarks[1].getY() - (double)rotation) / scaler;
    }

    public PointXD[] getUserMarkCoordinateValues(boolean scaled, boolean rotationCorrection) {
        double scaler = scaled ? this.imageScaler : 1.0;
        int rotation = rotationCorrection ? -this.side * 480 : 0;
        PointXD[] out = new PointXD[]{new PointXD(this.userMarks[0].getX() / scaler, (this.userMarks[0].getY() - (double)rotation) / scaler), new PointXD(this.userMarks[1].getX() / scaler, (this.userMarks[1].getY() - (double)rotation) / scaler)};
        return out;
    }

    public String getManualCoordinates(boolean scaled, boolean rotationCorrection) {
        return this.getUserMarkCoordinates(scaled, rotationCorrection, " ");
    }

    public void setImageStatus(boolean imageLoaded) {
        this.imageLoaded = imageLoaded;
    }

    public boolean hasImageLoaded() {
        return this.imageLoaded;
    }

    public void setUserDataStatus(boolean userDataLoaded) {
        this.userDataLoaded = userDataLoaded;
        System.out.println("" + this + " has ASC data set to: " + userDataLoaded);
    }

    public boolean getUserDataStatus() {
        System.out.println("" + this + " has ASC data: " + this.userDataLoaded);
        return this.userDataLoaded;
    }

    protected void setOutlier(int iteration) {
        this.outlier = iteration;
    }

    public int getOutlierIteration() {
        return this.outlier;
    }

    public int increaseOutlierIteration() {
        return ++this.outlier;
    }

    public boolean isOutlier() {
        return this.outlier > 0;
    }

    public void replaceSplineGroup(SplineGroup group) {
        this.splineStack.clear();
        this.fittedSplines = group.copy();
    }

    public SplineGroup getSplineGroup() {
        return this.fittedSplines;
    }

    public int getNoSplines() {
        return this.fittedSplines.getNoSplines();
    }

    public void setPixelToMmScaling(double pixelToMmScaling) {
        this.pixelToMmScaling = pixelToMmScaling;
    }

    public double getPixelToMmScaling(boolean scaled) {
        if (scaled) {
            return this.pixelToMmScaling * this.imageScaler;
        }
        return this.pixelToMmScaling;
    }

    public double getScaler() {
        return this.imageScaler;
    }

    public void setComment(String comment) {
        this.comment = this.comment + " " + comment;
    }

    public String getComment() {
        return this.comment;
    }

    public int sex() {
        return this.sex;
    }

    public boolean hasSplineGroup() {
        return this.fittedSplines != null;
    }

    public void setSplineGroup(SplineGroup group) {
        this.stackSplines();
        this.fittedSplines = group.copy();
    }

    public boolean stackSplines() {
        if (this.fittedSplines == null) {
            return false;
        }
        this.splineStack.push(this.fittedSplines.copy());
        return true;
    }

    public LandMarks getRawLandMarks() {
        return new LandMarkExtractor(this).extractLandMarks();
    }

    public double[] getDistortions() {
        return this.distortions;
    }

    public double[] getDistortionsCopy() {
        double[] out = new double[this.distortions.length];
        System.arraycopy(this.distortions, 0, out, 0, out.length);
        return out;
    }

    public void reset() {
        this.splineVersion = 0;
        this.splineStack.clear();
        this.fittedSplines = null;
        this.isSplined = false;
        this.isEdited = false;
    }

    public void setOutlierType(int outlierType) {
        this.isOutlier = this.isOutlier > 0 ? 4 : outlierType;
    }

    public String getOutlierMessage() {
        String msg = "Editing " + this.ID + "/" + this.wingCode + " (round:" + this.splineVersion + "): ";
        if (this.isOutlier == 0) {
            msg = msg + "not an outlier";
        } else if (this.isOutlier == 4) {
            msg = msg + "double outlier, outlier value " + this.MD;
        } else if (this.isOutlier == 1) {
            msg = msg + "landmark outlier, outlier value " + this.MD;
        } else if (this.isOutlier == 2) {
            msg = msg + "outline outlier, outlier value " + this.MD;
        }
        return msg;
    }

    public String toString() {
        return this.ID;
    }

    public int[][] getRawImageData() {
        return this.rawData;
    }

    public boolean hasRawImageData() {
        return this.rawData != null;
    }

    public int[][] loadRawImageData() throws IOException {
        BufferedImage originalImage = ImageIO.read(new File(GlobalVariables.workDirectory, this.getImageFileName()));
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        this.imageScaler = StrictMath.min((double)width / 320.0, (double)height / 240.0);
        int newWidth = (int)((double)width / this.imageScaler);
        int newHeight = (int)((double)height / this.imageScaler);
        BufferedImage scaledImage = new BufferedImage(newWidth, newHeight, 10);
        Graphics2D g2d = scaledImage.createGraphics();
        g2d.drawImage(originalImage, 0, 0, newWidth, newHeight, null);
        WritableRaster ras = scaledImage.copyData(null);
        DataBufferByte db = (DataBufferByte)ras.getDataBuffer();
        byte[] rawByteData = db.getData();
        this.rawData = new int[newWidth][newHeight];
        int count = 0;
        for (int y = 0; y < newHeight; ++y) {
            int x = 0;
            while (x < newWidth) {
                this.rawData[x][y] = rawByteData[count] & 0xFF;
                ++x;
                ++count;
            }
        }
        this.setImageStatus(true);
        this.setOutlierType(0);
        return this.rawData;
    }

    public static Individual getTestIndividual() {
        double[][] data1 = new double[][]{{275.200012207031, 127.199996948242}, {272.0, 160.800003051757}, {234.275687, 189.029912}, {161.600006103515, 202.0}, {140.374931, 196.078966}, {121.874218, 198.629802}, {55.6509, 182.85258}, {23.034116, 154.170625}, {27.799746, 123.231341}, {78.504819, 83.319664}, {198.688625, 75.815377}, {234.661109, 94.691614}, {250.0, 100.0}, {267.200012207031, 99.1999969482421}};
        double[][] data2 = new double[][]{{140.985612131153, 197.161627828226}, {148.889515, 175.998299}, {178.681665, 157.469687}, {228.010821, 132.795801}, {272.313004, 118.23732}};
        double[][] data3 = new double[][]{{38.1919154673165, 167.477026339603}, {90.548884, 153.942264}, {135.191356, 145.841051}, {153.199996948242, 145.199996948242}, {184.800003051757, 134.0}, {214.0, 122.0}, {224.492535, 121.65341}, {271.200012207031, 110.800003051757}};
        double[][] data4 = new double[][]{{25.1626166971338, 144.200547375038}, {62.127549, 132.258034}, {138.025749, 115.566659}, {187.842415, 109.425673}, {213.199996948242, 115.599998474121}, {247.600006103515, 108.400001525878}, {258.0, 108.800003051757}, {269.200012207031, 104.400001525878}};
        double[][] data5 = new double[][]{{51.4094887340179, 104.663894575844}, {66.0, 108.400001525878}, {150.0, 94.0}, {217.600006103515, 100.800003051757}, {246.800003051757, 101.199996948242}, {253.29489081797, 108.608660172137}};
        double[][] data6 = new double[][]{{221.220531606021, 87.6151652363157}, {227.564537, 80.65883}, {263.289935, 87.003621}};
        double[][] data7 = new double[][]{{161.265679082473, 168.422297708006}, {153.795403, 163.342001}, {152.976564042113, 144.316020902669}};
        double[][] data8 = new double[][]{{213.724948378206, 122.849912418352}, {213.600006103515, 119.199996948242}, {212.385707231244, 113.933023012804}};
        double[][] data9 = new double[][]{{258.14426436225, 123.010054438417}, {261.714832, 129.946153}, {265.328519, 129.150997}, {259.720008, 152.186556}};
        SplineGroup splines = new SplineGroup(9);
        double[] d = new double[]{1.0, 1.0};
        splines.setSpline(0, new Spline(data1, d));
        splines.setSpline(1, new Spline(data2, d));
        splines.setSpline(2, new Spline(data3, d));
        splines.setSpline(3, new Spline(data4, d));
        splines.setSpline(4, new Spline(data5, d));
        splines.setSpline(5, new Spline(data6, d));
        splines.setSpline(6, new Spline(data7, d));
        splines.setSpline(7, new Spline(data8, d));
        splines.setSpline(8, new Spline(data9, d));
        try {
            LandMarkDefinition lmdef = LandMarkDefinitionFile.load(new File("C:\\java\\projects\\Wings4\\supportFiles\\HouleLabDrosoWing.definition"));
            Individual ind = new Individual(lmdef, 2);
            GlobalVariables.workDirectory = new File("c:\\wings\\java\\");
            ind.setImageFile("upreg30000.tif");
            ind.loadRawImageData();
            ind.setSplineGroup(splines);
            ind.ID = "First";
            ind.setUserMarkCoordinates(new PointXD(263.289935, 87.003621), new PointXD(275.200012207031, 127.1999969482421));
            ind.imagedBy = "Kim";
            ind.date = "date";
            ind.time = "time";
            ind.strainID = "strainID";
            ind.sex = 1;
            ind.pixelToMmScaling = 5.0E-5;
            ind.wingCodeNumber = 1000;
            return ind;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Individual getTestIndividual2() {
        double[][] data1 = new double[][]{{280.12, 132.45}, {283.62747, 167.59528}, {243.695752, 197.088857}, {167.572783, 213.500991}, {65.729524, 200.601445}, {22.271636, 150.478175}, {85.117022, 97.530012}, {219.462513, 85.496378}, {246.278212, 99.716742}, {263.47716, 102.902793}, {271.691739, 100.844021}};
        double[][] data2 = new double[][]{{144.678201, 209.539391}, {145.616804, 192.119089}, {176.126148, 170.766604}, {225.626807, 139.477017}, {276.058984, 117.22119}};
        double[][] data3 = new double[][]{{51.152936, 182.619767}, {92.545563, 167.563686}, {139.828156, 158.112094}, {156.304951, 152.016128}, {187.990775, 137.552254}, {212.761179, 125.477258}, {224.31096, 126.585469}, {273.643655, 108.163708}};
        double[][] data4 = new double[][]{{35.239104, 157.26171}, {74.471632, 141.834853}, {149.841852, 123.131816}, {193.233618, 117.072106}, {206.276986, 119.239079}, {242.115888, 109.880914}, {250.297578, 106.288803}, {271.325822, 99.471832}};
        double[][] data5 = new double[][]{{72.030771, 111.839771}, {105.099355, 113.080105}, {167.533222, 104.858576}, {243.617707, 103.165878}, {251.170831, 106.203453}};
        double[][] data6 = new double[][]{{231.001961, 91.775675}, {236.479833, 84.145405}, {267.884731, 86.567741}};
        double[][] data7 = new double[][]{{158.724275, 183.034616}, {152.732226, 168.91311}, {149.0385, 154.699991}};
        double[][] data8 = new double[][]{{211.783555, 126.927884}, {211.795903, 126.91691}, {209.564901, 117.732639}};
        double[][] data9 = new double[][]{{262.688429, 123.210751}, {268.751911, 134.547812}, {265.002699, 148.036555}, {263.555313, 163.15599}};
        SplineGroup splines = new SplineGroup(9);
        double[] d = new double[]{1.0, 1.0};
        splines.setSpline(0, new Spline(data1, d));
        splines.setSpline(1, new Spline(data2, d));
        splines.setSpline(2, new Spline(data3, d));
        splines.setSpline(3, new Spline(data4, d));
        splines.setSpline(4, new Spline(data5, d));
        splines.setSpline(5, new Spline(data6, d));
        splines.setSpline(6, new Spline(data7, d));
        splines.setSpline(7, new Spline(data8, d));
        splines.setSpline(8, new Spline(data9, d));
        try {
            LandMarkDefinition lmdef = LandMarkDefinitionFile.load(new File("C:\\java\\projects\\Wings4\\supportFiles\\HouleLabDrosoWing.definition"));
            Individual ind = new Individual(lmdef, 2);
            ind.setImageFile("original.tif");
            ind.loadRawImageData();
            ind.setSplineGroup(splines);
            ind.ID = "Second";
            return ind;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean saveData(boolean saveImage) {
        if (this.hasSplineGroup()) {
            try {
                String name = this.imageFileName.substring(0, this.imageFileName.lastIndexOf(46));
                CPFile.save(new File(GlobalVariables.workDirectory, name + ".cp"), this);
                if (saveImage && Boolean.parseBoolean(GlobalVariables.props.getProperty("overlay.store"))) {
                    BufferedImage originalImage = null;
                    double overlayScaler = this.imageScaler;
                    if (GlobalVariables.props.getProperty("overlay.size").equalsIgnoreCase("originalSize")) {
                        originalImage = ImageIO.read(new File(GlobalVariables.workDirectory, this.getImageFileName()));
                    } else {
                        originalImage = DataToImage.createImage(this.rawData);
                        overlayScaler = 1.0;
                    }
                    FileImageOutputStream out = new FileImageOutputStream(new File(GlobalVariables.workDirectory, name + ".overlay." + GlobalVariables.props.getProperty("overlay.fileType")));
                    BufferedImage overlaidImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 1);
                    Graphics2D g2d = overlaidImage.createGraphics();
                    GraphicsJAI graphicsJAI = GraphicsJAI.createGraphicsJAI((Graphics2D)g2d, null);
                    graphicsJAI.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    if (originalImage != null) {
                        graphicsJAI.drawImage((Image)originalImage, 0, 0, null);
                    }
                    if (this.isOutlier()) {
                        graphicsJAI.drawString("R E J E C T E D", 25, 25);
                    } else if (this.fittedSplines != null) {
                        int noSplines = this.fittedSplines.getNoSplines();
                        int no = 0;
                        int[] xx = null;
                        int[] yy = null;
                        double[][] data = null;
                        for (int x = 0; x < noSplines; ++x) {
                            int y;
                            graphicsJAI.setColor(GlobalVariables.colors[x]);
                            if (this.fittedSplines.getSpline(x) == null) continue;
                            data = this.fittedSplines.getSpline(x).getData();
                            no = data.length;
                            for (y = 0; y < no; ++y) {
                                graphicsJAI.drawOval((int)((data[y][0] - 2.0) * overlayScaler), (int)((data[y][1] - 2.0) * overlayScaler), 4, 4);
                            }
                            no = this.fittedSplines.getSpline(x).getRowDimension() * 10;
                            data = this.fittedSplines.getSpline(x).getBSpline().getCurveCoordinates(no - 1);
                            xx = new int[no];
                            yy = new int[no];
                            for (y = 0; y < no; ++y) {
                                xx[y] = (int)(data[y][0] * overlayScaler);
                                yy[y] = (int)(data[y][1] * overlayScaler);
                            }
                            graphicsJAI.drawPolyline(xx, yy, no);
                        }
                    }
                    ImageFile.save(overlaidImage, out, GlobalVariables.props.getProperty("overlay.fileType"));
                }
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(Individual.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(Individual.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return true;
    }

    public double getProcrustesDistance() {
        return this.procrustesDistance;
    }

    public void setProcrustesDistance(double procrustesDistance) {
        this.procrustesDistance = procrustesDistance;
    }

    public boolean setDefaultParameters() {
        this.masterSplines = GlobalVariables.masterSplineGroup;
        this.cpMasterFile = GlobalVariables.cpMasterFile;
        this.hasIndividualSpliningParameters = false;
        return true;
    }

    public void setSpliningParameters(SpliningParameterSet splineParameters) {
        this.splineParameters = splineParameters.copy();
        this.hasIndividualSpliningParameters = true;
    }

    public boolean hasIndividualSpliningParameters() {
        return this.splineParameters.isComplete();
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public void setRejected(boolean b) {
        this.rejected = b;
    }

    public boolean isSplined() {
        return this.isSplined;
    }

    public boolean isEdited() {
        return this.isEdited;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void setSplined(boolean b) {
        this.isSplined = b;
    }

    public void setEdited(boolean b) {
        this.isEdited = b;
    }

    public void setFinished(boolean b) {
        this.isFinished = b;
    }

    public boolean hasMVEPerformed() {
        return this.MVEPerformed;
    }

    public void setMVEPerformed(boolean MVEPerformed) {
        this.MVEPerformed = MVEPerformed;
    }
}

