/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.images;

import commonSense.math.linear.PointXD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.media.jai.GraphicsJAI;
import javax.swing.JPanel;
import kim.bin.bio.wings.GlobalVariables;
import kim.bin.bio.wings.images.DataToImage;
import kim.bin.bio.wings.images.LMCircle;
import kim.bin.bio.wings.spline.SplineGroup;

public class DisplayImage
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BufferedImage image = null;
    private BufferedImage scaledImage = null;
    private Dimension d = new Dimension(320, 240);
    private String text = null;
    private Point[] joints = null;
    SplineGroup splines = null;
    private PointXD[] userMarks = null;
    private PointXD[] features = null;
    private boolean multiColor = false;
    private int[] inspect = null;
    int borderWidth = 0;
    float magnification = 1.0f;
    private int imageWidth = 320;
    private int imageHeight = 240;
    private int displayWidth = 0;
    private int displayHeight = 0;
    LMCircle[][] splinePoints;
    private boolean locked = true;
    private boolean edit = false;

    public DisplayImage() {
        this.setPreferredSize(this.d);
    }

    public DisplayImage(int[][] imageData) {
        this(DataToImage.createImage(imageData));
    }

    public DisplayImage(BufferedImage image) {
        this.setImage(image);
    }

    @Override
    public void paintComponent(Graphics g) {
        int x;
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        GraphicsJAI graphicsJAI = GraphicsJAI.createGraphicsJAI((Graphics2D)g2d, (Component)this);
        graphicsJAI.setColor(Color.black);
        graphicsJAI.fillRect(0, 0, this.borderWidth * 2 + (int)(this.magnification * (float)this.imageWidth), this.borderWidth * 2 + (int)(this.magnification * (float)this.imageHeight));
        graphicsJAI.setColor(Color.red);
        if (this.image != null) {
            if (this.magnification == 1.0f) {
                graphicsJAI.drawImage((Image)this.image, this.borderWidth, this.borderWidth, null);
            } else {
                graphicsJAI.drawImage((Image)this.scaledImage, this.borderWidth, this.borderWidth, null);
            }
        }
        if (this.splines != null) {
            int noSplines = this.splines.getNoSplines();
            graphicsJAI.setColor(Color.red);
            for (int x2 = 0; x2 < noSplines; ++x2) {
                int y;
                int no;
                double[][] data;
                if (this.multiColor) {
                    graphicsJAI.setColor(GlobalVariables.colors[x2]);
                }
                if (this.splines.getSpline(x2) == null) continue;
                if (!this.edit) {
                    data = this.splines.getSpline(x2).getData();
                    no = data.length;
                    for (y = 0; y < no; ++y) {
                        graphicsJAI.drawOval(this.borderWidth + (int)((double)this.magnification * data[y][0]), this.borderWidth + (int)((double)this.magnification * data[y][1]), 4, 4);
                    }
                }
                no = this.splines.getSpline(x2).getRowDimension() * 10;
                data = this.splines.getSpline(x2).getBSpline().getCurveCoordinates(no - 1);
                int[] xx = new int[no];
                int[] yy = new int[no];
                for (y = 0; y < no; ++y) {
                    xx[y] = this.borderWidth + (int)((double)this.magnification * data[y][0]);
                    yy[y] = this.borderWidth + (int)((double)this.magnification * data[y][1]);
                }
                graphicsJAI.drawPolyline(xx, yy, no);
            }
        }
        if (this.userMarks != null) {
            graphicsJAI.setColor(Color.yellow);
            if (this.locked) {
                graphicsJAI.drawOval(this.borderWidth + (int)((double)this.magnification * this.userMarks[0].getX()), this.borderWidth + (int)((double)this.magnification * this.userMarks[0].getY()), 4, 4);
                graphicsJAI.drawOval(this.borderWidth + (int)((double)this.magnification * this.userMarks[1].getX()), this.borderWidth + (int)((double)this.magnification * this.userMarks[1].getY()), 4, 4);
            } else {
                graphicsJAI.fillOval(this.borderWidth + (int)((double)this.magnification * this.userMarks[0].getX()), this.borderWidth + (int)((double)this.magnification * this.userMarks[0].getY()), 4, 4);
                graphicsJAI.fillOval(this.borderWidth + (int)((double)this.magnification * this.userMarks[1].getX()), this.borderWidth + (int)((double)this.magnification * this.userMarks[1].getY()), 4, 4);
            }
            graphicsJAI.drawLine(this.borderWidth + (int)((double)this.magnification * this.userMarks[0].getX()), this.borderWidth + (int)((double)this.magnification * this.userMarks[0].getY()), this.borderWidth + (int)((double)this.magnification * this.userMarks[1].getX()), this.borderWidth + (int)((double)this.magnification * this.userMarks[1].getY()));
        }
        if (this.edit) {
            if (this.splinePoints != null) {
                for (x = 0; x < this.splinePoints.length; ++x) {
                    graphicsJAI.setColor(GlobalVariables.colors[x]);
                    for (int y = 0; y < this.splinePoints[x].length; ++y) {
                        graphicsJAI.drawOval(this.borderWidth + (int)((double)this.magnification * this.splinePoints[x][y].x) + 6, this.borderWidth + (int)((double)this.magnification * this.splinePoints[x][y].y) + 6, 8, 8);
                    }
                }
            }
        } else {
            graphicsJAI.setColor(Color.red);
            graphicsJAI.drawString(this.text == null ? "0.0" : this.text, 10, 20);
            if (this.joints != null) {
                graphicsJAI.setColor(Color.red);
                for (x = 0; x < this.joints.length; ++x) {
                    if (this.joints[x] == null) continue;
                    graphicsJAI.drawOval(this.borderWidth + (int)((double)(this.magnification * (float)this.joints[x].x) - 2.0), this.borderWidth + (int)((double)(this.magnification * (float)this.joints[x].y) - 2.0), 4, 4);
                    graphicsJAI.drawString("" + x, this.borderWidth + (int)((double)(this.magnification * (float)this.joints[x].x) - 8.0), this.borderWidth + (int)((double)(this.magnification * (float)this.joints[x].y) - 8.0));
                }
            }
            if (this.features != null) {
                for (x = 0; x < this.features.length; ++x) {
                    graphicsJAI.setColor(Color.green);
                    if (this.features[x] == null) continue;
                    graphicsJAI.drawOval(this.borderWidth + (int)((double)this.magnification * this.features[x].getX() - 2.0), this.borderWidth + (int)((double)this.magnification * this.features[x].getY() - 2.0), 4, 4);
                    graphicsJAI.drawString("" + x, this.borderWidth + (int)((double)this.magnification * this.features[x].getX() - 6.0), this.borderWidth + (int)((double)this.magnification * this.features[x].getY() - 6.0));
                }
                if (this.features.length > 5 && this.features[6] != null) {
                    if (this.features[1] != null) {
                        graphicsJAI.drawLine(this.borderWidth + (int)((double)this.magnification * this.features[1].getX()), this.borderWidth + (int)((double)this.magnification * this.features[1].getY()), this.borderWidth + (int)((double)this.magnification * this.features[6].getX()), this.borderWidth + (int)((double)this.magnification * this.features[6].getY()));
                    }
                    if (this.features[2] != null) {
                        graphicsJAI.drawLine(this.borderWidth + (int)((double)this.magnification * this.features[2].getX()), this.borderWidth + (int)((double)this.magnification * this.features[2].getY()), this.borderWidth + (int)((double)this.magnification * this.features[6].getX()), this.borderWidth + (int)((double)this.magnification * this.features[6].getY()));
                    }
                }
            }
            if (this.inspect != null) {
                graphicsJAI.setColor(Color.green);
                graphicsJAI.drawLine(this.inspect[0], this.borderWidth, this.inspect[0], this.borderWidth + this.imageHeight);
                graphicsJAI.drawLine(this.borderWidth, this.inspect[1], this.borderWidth + this.imageWidth, this.inspect[1]);
            }
        }
    }

    public final void setImage(BufferedImage image) {
        this.image = image;
        this.imageWidth = image.getWidth();
        this.imageHeight = image.getHeight();
        this.resize();
    }

    public void setImageData(int[][] imageData) {
        this.setImage(DataToImage.createImage(imageData));
        this.resize();
    }

    public void setText(String text) {
        this.text = text;
        this.resize();
    }

    public void setJoints(Point[] joints) {
        this.joints = joints;
        this.resize();
    }

    public void setSplineGroup(SplineGroup splineGroup, boolean multipleColors) {
        this.splines = splineGroup;
        if (splineGroup == null) {
            this.setText("No spline model selected.");
        }
        this.setMultiColor(multipleColors);
        this.resize();
    }

    public void setUserMarks(PointXD[] userMarks) {
        this.userMarks = userMarks;
        this.resize();
    }

    public void setFeatures(PointXD[] features) {
        System.out.println("Number of feature points: " + features.length);
        this.features = features;
        this.resize();
    }

    public PointXD[] getUserMarks() {
        return this.userMarks;
    }

    public void setBorder(int borderWidth) {
        this.borderWidth = borderWidth;
        this.resize();
    }

    public void setMagnification(float magnification) {
        this.magnification = magnification;
        this.resize();
    }

    public BufferedImage getScaledImage(float magnification) {
        this.scaledImage = new BufferedImage((int)((float)this.imageWidth * magnification), (int)((float)this.imageHeight * magnification), 10);
        Graphics2D g2d = this.scaledImage.createGraphics();
        g2d.drawImage(this.image, 0, 0, (int)((float)this.imageWidth * magnification), (int)((float)this.imageHeight * magnification), this);
        return this.scaledImage;
    }

    private void resize() {
        this.displayWidth = this.borderWidth * 2 + (int)((float)this.imageWidth * this.magnification);
        this.displayHeight = this.borderWidth * 2 + (int)((float)this.imageHeight * this.magnification);
        this.getScaledImage(this.magnification);
        this.d = new Dimension(this.displayWidth, this.displayHeight);
        this.setPreferredSize(this.d);
        this.setMinimumSize(this.d);
        this.setMaximumSize(this.d);
        this.setSize(this.d);
        this.validate();
        this.repaint();
    }

    public boolean isMultiColor() {
        return this.multiColor;
    }

    public void setMultiColor(boolean multiColor) {
        this.multiColor = multiColor;
        this.resize();
        this.repaint();
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.resize();
        this.repaint();
    }

    public void setEditMode(boolean editMode) {
        this.edit = editMode;
        this.borderWidth = this.edit ? 25 : 0;
    }

    public float getScale() {
        return this.magnification;
    }

    public void update() {
        System.out.println("Update requested");
        this.repaint();
    }
}

