/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.fileTypes;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileNameExtensionFilter;
import kim.bin.bio.wings.GlobalVariables;
import kim.bin.bio.wings.fileTypes.CPFile;
import kim.bin.bio.wings.individual.Individual;
import kim.bin.bio.wings.landmark.LandMarkDefinition;
import kim.bin.bio.wings.spline.Spline;
import kim.bin.bio.wings.spline.SplineGroup;
import kim.io.file.ReadDataFile;

public class CPXFile
extends CPFile {
    public static SplineGroup read(File f, LandMarkDefinition LMDefinition) throws FileNotFoundException, IOException {
        String data = ReadDataFile.getData(f);
        StringTokenizer lines = new StringTokenizer(data, "\n\r");
        String firstLine = lines.nextToken().trim();
        int noSplines = 0;
        while (firstLine.startsWith("#")) {
            firstLine = lines.nextToken().trim();
        }
        noSplines = Integer.parseInt(firstLine);
        SplineGroup splines = new SplineGroup(noSplines);
        int points = 0;
        double[][] values = null;
        for (int x = 0; x < noSplines; ++x) {
            points = Integer.parseInt(lines.nextToken().trim());
            values = new double[points][GlobalVariables.dimensions];
            for (int y = 0; y < points; ++y) {
                StringTokenizer cells = new StringTokenizer(lines.nextToken());
                for (int z = 0; z < GlobalVariables.dimensions; ++z) {
                    values[y][z] = Double.parseDouble(cells.nextToken());
                }
            }
            splines.setSpline(x, new Spline(values, GlobalVariables.distortions));
        }
        return splines;
    }

    public static void save(Individual ind, File pathName) throws IOException {
        System.out.println("(CPFile.save) " + pathName);
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(pathName)));
        out.print("# CPXFile");
        out.println(" " + ind.getPixelToMmScaling(true));
        out.flush();
        SplineGroup sg = ind.getSplineGroup();
        int noSplines = sg.getNoSplines();
        out.println(noSplines);
        int no = -1;
        for (int x = 0; x < noSplines; ++x) {
            out.println(sg.getSpline(x).getDataString(" ", true, true));
            out.flush();
        }
        out.close();
    }

    public static void save(SplineGroup sg, File pathName) throws IOException {
        System.out.println("(CPFile.save) " + pathName);
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(pathName)));
        out.println("# CPXFile");
        int noSplines = sg.getNoSplines();
        out.println(noSplines);
        int no = -1;
        for (int x = 0; x < noSplines; ++x) {
            out.println(sg.getSpline(x).getDataString(" ", true, true));
            out.flush();
        }
        out.close();
    }

    public static FileNameExtensionFilter getFilter() {
        return new FileNameExtensionFilter("Spline data master files (*.cp0; *.cp1; *.cp2; *.cp3; *.cp4; *.cp5; *.cp6; *.cp7; *.cp8; *.cp9)", "cp0", "cp1", "cp2", "cp3", "cp4", "cp5", "cp6", "cp7", "cp8", "cp9");
    }

    public static boolean saveModelFile(SplineGroup splines) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(GlobalVariables.workDirectory);
        chooser.setFileFilter(CPXFile.getFilter());
        chooser.setFileSelectionMode(2);
        int returnVal = chooser.showSaveDialog(new JFrame());
        if (returnVal == 0) {
            try {
                CPXFile.save(splines, chooser.getSelectedFile());
            }
            catch (IOException ex) {
                return false;
            }
        }
        return true;
    }
}

