/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.fileTypes;

import commonSense.math.linear.PointXD;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import kim.bin.bio.wings.GlobalVariables;
import kim.bin.bio.wings.LogFrame;
import kim.bin.bio.wings.dataImport.DataCheck;
import kim.bin.bio.wings.individual.Individual;
import kim.bin.bio.wings.individual.IndividualGroup;
import kim.io.file.ReadDataFile;

public class ASCFile {
    private ASCFile() {
    }

    public static IndividualGroup read(File f) throws FileNotFoundException, IOException {
        GlobalVariables.workDirectory = f.getParentFile();
        String data = ReadDataFile.getData(f);
        StringTokenizer lines = new StringTokenizer(data, "\n\r");
        int noLines = lines.countTokens();
        IndividualGroup individuals = new IndividualGroup(noLines, GlobalVariables.LMDefinition, 2, "" + f.getName());
        String comment = "";
        String dump = "";
        String line = "";
        double temp = 0.0;
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double yMax = 0.0;
        boolean errorsDetected = false;
        while (lines.hasMoreTokens()) {
            line = lines.nextToken();
            StringTokenizer cells = new StringTokenizer(line, " \t");
            if (cells.countTokens() >= 11) {
                int x;
                Individual ind = new Individual(GlobalVariables.LMDefinition, GlobalVariables.dimensions);
                String name = cells.nextToken();
                ind.setImageFile(name);
                ind.ID = name;
                try {
                    x1 = DataCheck.checkDouble(cells.nextToken());
                }
                catch (Exception e) {
                    LogFrame.log("Error in ASC file at line: " + line + "\n" + e.getMessage());
                    errorsDetected = true;
                }
                try {
                    y1 = DataCheck.checkDouble(cells.nextToken());
                }
                catch (Exception e) {
                    LogFrame.log("Error in ASC file at line: " + line + "\n" + e.getMessage());
                    errorsDetected = true;
                }
                try {
                    x2 = DataCheck.checkDouble(cells.nextToken());
                }
                catch (Exception e) {
                    LogFrame.log("Error in ASC file at line: " + line + "\n" + e.getMessage());
                    errorsDetected = true;
                }
                try {
                    y2 = DataCheck.checkDouble(cells.nextToken());
                }
                catch (Exception e) {
                    LogFrame.log("Error in ASC file at line: " + line + "\n" + e.getMessage());
                    errorsDetected = true;
                }
                yMax = y1 > yMax ? y1 : yMax;
                yMax = y2 > yMax ? y2 : yMax;
                ind.setUserMarkCoordinates(new PointXD(x1, y1), new PointXD(x2, y2));
                ind.imagedBy = cells.nextToken();
                try {
                    ind.date = DataCheck.checkDate(cells.nextToken());
                }
                catch (Exception e) {
                    LogFrame.log("Error in ASC file at line: " + line + "\n" + e.getMessage());
                    errorsDetected = true;
                }
                ind.time = cells.nextToken();
                ind.strainID = cells.nextToken();
                try {
                    ind.sex = DataCheck.checkSex(cells.nextToken());
                }
                catch (Exception e) {
                    LogFrame.log("Error in ASC file at line: " + line + "\n" + e.getMessage());
                    errorsDetected = true;
                }
                try {
                    ind.setPixelToMmScaling(DataCheck.checkDouble(cells.nextToken()));
                }
                catch (Exception e) {
                    LogFrame.log("Error in ASC file at line: " + line + "\n" + e.getMessage());
                    errorsDetected = true;
                }
                if (cells.hasMoreTokens()) {
                    for (x = 0; x < GlobalVariables.dimensions; ++x) {
                        try {
                            dump = cells.nextToken();
                            try {
                                temp = DataCheck.checkDouble(dump);
                            }
                            catch (Exception e) {
                                LogFrame.log("Error in ASC file at line: " + line + "\n" + e.getMessage());
                                errorsDetected = true;
                            }
                            if (temp > 0.9 || temp < 1.1) {
                                ind.distortions[x] = temp;
                                continue;
                            }
                            comment = comment + temp + " ";
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            comment = comment + dump + " ";
                        }
                    }
                } else {
                    ind.distortions[0] = 1.0;
                    ind.distortions[1] = 0.986;
                    for (x = 2; x < GlobalVariables.dimensions; ++x) {
                        ind.distortions[x] = 1.0;
                    }
                }
                while (cells.hasMoreTokens()) {
                    comment = comment + cells.nextToken();
                }
                ind.setComment(comment);
                comment = "";
                if (!errorsDetected) {
                    ind.setUserDataStatus(true);
                }
                individuals.put(ind.ID, ind);
                continue;
            }
            LogFrame.log("Missing data in line " + line);
            errorsDetected = true;
        }
        if (errorsDetected) {
            JOptionPane.showMessageDialog(new Frame(), "Incomplete data. \n No data loaded, errors in log frame.");
            return null;
        }
        return individuals;
    }

    public static void save(IndividualGroup individuals, File file, boolean reScale, boolean included) throws FileNotFoundException, IOException {
        System.out.println("ASCFile: file to be saved " + file);
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        Iterator<Individual> i = individuals.values().iterator();
        while (i.hasNext()) {
            Individual ind;
            if (included) {
                do {
                    if (!(ind = i.next()).isRejected()) continue;
                    ind = null;
                } while (ind == null && i.hasNext());
            } else {
                ind = i.next();
            }
            if (ind != null) {
                out.print(ind.getImageFileName() + " ");
                out.print(ind.getManualCoordinates(reScale, false) + " ");
                out.print(ind.imagedBy + " ");
                out.print(ind.date + " ");
                out.print(ind.time + " ");
                out.print(ind.strainID + " ");
                out.print(ind.sex + " ");
                out.println(ind.getPixelToMmScaling(reScale) + " ");
            }
            out.flush();
        }
        out.close();
    }

    public static FileNameExtensionFilter getFilter() {
        return new FileNameExtensionFilter("ASC files (*.asc, *.ascii)", "asc", "ascii");
    }
}

