/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.dataImport;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import kim.bin.bio.wings.dataImport.ImportTableHeaderRenderer;
import kim.bin.bio.wings.dataImport.ImportTableModel;
import kim.io.file.ReadDataFile;

public class ImportTable
extends JPanel {
    private static final long serialVersionUID = 1L;
    boolean DEBUG = false;
    private static Object[][] data;
    private String[] columnNames = new String[]{"Image file name", "CP file name", "User mark 1.x", "User mark 1.y", "User mark 2.x", "User mark 2.y", "Imaged by", "Splined by", "Date", "Time", "Genotype/treatment", "Sex", "Scale", "Camera distortion x-axis", "Camera distortion y-axis", "User mark 2.z", "User mark 1.z", "Camera distortion z-axis"};

    public ImportTable(Object[][] data) {
        super(new GridLayout(1, 0));
        JTable table = new JTable(new ImportTableModel(data));
        table.setPreferredScrollableViewportSize(new Dimension(1500, 1000));
        table.setFillsViewportHeight(true);
        table.getTableHeader().setDefaultRenderer(new ImportTableHeaderRenderer(this.columnNames));
        JScrollPane scrollPane = new JScrollPane(table);
        this.add(scrollPane);
    }

    private static void createAndShowGUI() throws FileNotFoundException, IOException {
        JFrame frame = new JFrame("TableDemo");
        frame.setDefaultCloseOperation(3);
        String importData = ReadDataFile.getData("C:\\wings\\Upreg\\small\\WM3Upreg.asc");
        StringTokenizer lines = new StringTokenizer(importData, "\n");
        int noRows = lines.countTokens();
        StringTokenizer cells = null;
        int noColumns = 0;
        while (lines.hasMoreTokens()) {
            cells = new StringTokenizer(lines.nextToken());
            noColumns = Math.max(noColumns, cells.countTokens());
        }
        data = new Object[noRows][noColumns];
        ImportTable newContentPane = new ImportTable(data);
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ImportTable.createAndShowGUI();
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(ImportTable.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(ImportTable.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }
}

