/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.dataImport;

import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import kim.bin.bio.wings.GlobalVariables;
import kim.bin.bio.wings.LogFrame;
import kim.bin.bio.wings.Wings;
import kim.bin.bio.wings.WingsStatus;
import kim.bin.bio.wings.fileTypes.ASCFile;
import kim.bin.bio.wings.fileTypes.CPFile;
import kim.bin.bio.wings.fileTypes.CPFilter;
import kim.bin.bio.wings.individual.Individual;
import kim.bin.bio.wings.individual.IndividualGroup;

public class ImportSplineDir
implements WingsStatus {
    private ImportSplineDir() {
    }

    public static void doIt(File directory) {
        System.out.println("ImportSplineDir: importing " + directory);
        if (directory == null) {
            return;
        }
        LogFrame.log("Selected: " + directory + " as working directory.");
        File[] fileList = directory.listFiles();
        GlobalVariables.individuals = ImportSplineDir.startData(fileList);
        if (GlobalVariables.individuals == null) {
            System.out.println("ImportSplineDir: nothing");
            return;
        }
        ImportSplineDir.splined();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IndividualGroup startData(File[] fileList) {
        File ascFile = null;
        IndividualGroup individuals = null;
        int numberOfASCFiles = 0;
        Wings.reworkCpXList();
        for (int x = fileList.length - 1; x >= 0; --x) {
            String s = "" + fileList[x];
            if ((s = s.substring(s.lastIndexOf(File.separator) + 1, s.length())).endsWith(".asc")) {
                LogFrame.log("ImportSplineDir(startData): Found asc-file: " + s);
                ++numberOfASCFiles;
                ascFile = fileList[x];
            }
            if (!s.endsWith(".cp0") && !s.endsWith(".cp1") && !s.endsWith(".cp2") && !s.endsWith(".cp3") && !s.endsWith(".cp4") && !s.endsWith(".cp5") && !s.endsWith(".cp6") && !s.endsWith(".cp7") && !s.endsWith(".cp8") && !s.endsWith(".cp9") || s.lastIndexOf(46) != s.indexOf(46)) continue;
            LogFrame.log("ImportSplineDir(startData): Found spline data master file: " + GlobalVariables.workDirectory + File.separator + s);
            Wings.setCPXFile(1, File.separator + s);
        }
        if (numberOfASCFiles > 1) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(ASCFile.getFilter());
            chooser.setCurrentDirectory(GlobalVariables.workDirectory);
            chooser.setApproveButtonText("Select");
            chooser.setMultiSelectionEnabled(false);
            chooser.setDialogTitle("ImportSplineDir(startData): Please select the correct ASC file");
            if (0 != chooser.showOpenDialog(null)) return null;
            ascFile = chooser.getSelectedFile();
            Wings.ascFileName.setText(ascFile.getName());
            numberOfASCFiles = 1;
        } else {
            Wings.ascFileName.setText(ascFile.getName());
        }
        if (numberOfASCFiles == 1) {
            String name = Wings.ascFileName.getText();
            System.out.println("ImportSplineDir(startData): " + name);
            GlobalVariables.speciesName = name.substring(0, name.indexOf(46));
            individuals = ImportSplineDir.importAscFile();
            LogFrame.log("ImportSplineDir(startData): Start data available");
            return individuals;
        }
        if (numberOfASCFiles != 0) return null;
        Wings.ascFileName.setText("*.asc");
        JOptionPane.showMessageDialog(null, "No *.asc file found. Import aborted.");
        LogFrame.log("ImportSplineDir(startData): ERROR: No *.asc file found.");
        return null;
    }

    public static IndividualGroup importAscFile() {
        IndividualGroup individuals = null;
        try {
            individuals = ASCFile.read(new File(GlobalVariables.workDirectory, Wings.ascFileName.getText()));
        }
        catch (FileNotFoundException fnfe) {
            Logger.getLogger(ImportSplineDir.class.getName()).log(Level.SEVERE, null, fnfe);
            LogFrame.log("" + fnfe);
            return null;
        }
        catch (IOException ioe) {
            Logger.getLogger(ImportSplineDir.class.getName()).log(Level.SEVERE, null, ioe);
            LogFrame.log("" + ioe);
            return null;
        }
        if (individuals == null) {
            return null;
        }
        LogFrame.log("ImportSplineDir(startData): Found " + individuals.size());
        return individuals;
    }

    public static void splined() {
        System.out.println("ImportSplineDir(splined): " + GlobalVariables.workDirectory);
        CPFilter fnf = new CPFilter(false);
        File[] files = GlobalVariables.workDirectory.listFiles(fnf);
        int noFiles = files.length;
        Individual ind = null;
        String fileName = "";
        String name = "";
        int count = 0;
        File f = null;
        boolean doubt = true;
        try {
            block4: for (int x = 0; x < noFiles; ++x) {
                System.out.println("Importing: " + files[x]);
                fileName = files[x].getName();
                if (fileName.lastIndexOf(46) != fileName.indexOf(46)) continue;
                ind = CPFile.read(files[x], GlobalVariables.LMDefinition, 2);
                GlobalVariables.individuals.put(ind.ID, ind);
                name = fileName.substring(0, fileName.indexOf(46));
                count = 0;
                doubt = true;
                while (true) {
                    if ((f = new File(GlobalVariables.workDirectory, name + "." + ++count + ".cp")).exists()) {
                        ind = CPFile.add(f, ind);
                        continue;
                    }
                    if (!doubt) continue block4;
                    doubt = false;
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            Logger.getLogger(ImportSplineDir.class.getName()).log(Level.SEVERE, null, fnfe);
        }
        catch (IOException ioe) {
            Logger.getLogger(ImportSplineDir.class.getName()).log(Level.SEVERE, null, ioe);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new Frame(), "Error in CP file: " + f + "\n" + e.getMessage());
        }
    }
}

